/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.document.CloneableDocumentComponent;
import com.jidesoft.document.DocumentComponent;
import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.SyntaxDocument;
import com.jidesoft.editor.language.LanguageSpec;
import com.jidesoft.editor.language.LanguageSpecManager;
import com.jidesoft.editor.marker.MarkerArea;
import com.jidesoft.editor.status.CodeEditorStatusBar;
import com.jidesoft.status.StatusBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class CodeEditorDocumentComponent
extends DocumentComponent
implements CloneableDocumentComponent {
    private CodeEditor \u0116;
    private String \u0115;

    public CodeEditorDocumentComponent(String string) {
        super(new JPanel(), string);
        this.initComponents();
    }

    public CodeEditorDocumentComponent(String string, String string2) {
        super(new JPanel(), string, string2);
        this.initComponents();
    }

    public CodeEditorDocumentComponent(String string, String string2, Icon icon) {
        super(new JPanel(), string, string2, icon);
        this.initComponents();
    }

    public CodeEditorDocumentComponent(JComponent jComponent, String string, String string2, Icon icon) {
        super(jComponent, string, string2, icon);
    }

    protected void initComponents() {
        this.\u0116 = this.createCodeEditor();
        this.\u0101();
    }

    private void \u0101() {
        StatusBar statusBar;
        JComponent jComponent = this.getComponent();
        jComponent.setLayout(new BorderLayout());
        jComponent.add(this.\u0116);
        MarkerArea markerArea = this.createMarkerArea(this.\u0116);
        if (markerArea != null) {
            jComponent.add((Component)markerArea, "After");
        }
        if ((statusBar = this.createStatusBar(this.\u0116)) != null) {
            jComponent.add((Component)statusBar, "Last");
        }
    }

    protected StatusBar createStatusBar(CodeEditor codeEditor) {
        return new CodeEditorStatusBar(codeEditor);
    }

    protected MarkerArea createMarkerArea(CodeEditor codeEditor) {
        return new MarkerArea(codeEditor);
    }

    public String getLanguageName() {
        return this.\u0115;
    }

    public void setLanguageName(String string) {
        this.\u0115 = string;
        LanguageSpec languageSpec = LanguageSpecManager.getInstance().getLanguageSpec(string);
        if (languageSpec != null) {
            languageSpec.configureCodeEditor(this.getCodeEditor());
        }
    }

    protected CodeEditor createCodeEditor() {
        CodeEditor codeEditor = new CodeEditor();
        codeEditor.setName(this.getTitle());
        return codeEditor;
    }

    public void setCodeEditor(CodeEditor codeEditor) {
        if (this.\u0116 != codeEditor) {
            JComponent jComponent;
            if (this.\u0116 != null && (jComponent = this.getComponent()) != null) {
                jComponent.removeAll();
            }
            this.\u0116 = codeEditor;
            this.\u0101();
        }
    }

    public CodeEditor getCodeEditor() {
        return this.\u0116;
    }

    public void open(String string) throws IOException {
        this.open(new FileInputStream(string));
    }

    public void open(String string, String string2) throws IOException {
        this.open(new FileInputStream(string), string2);
    }

    public void open(ClassLoader classLoader, String string) throws IOException {
        InputStream inputStream;
        if (classLoader != null) {
            inputStream = classLoader.getResourceAsStream(string);
            if (inputStream == null) {
                throw new IllegalArgumentException("Resource " + string + " doesn't exist.");
            }
        } else {
            throw new IllegalArgumentException("Classloader cannot be null.");
        }
        this.open(inputStream);
    }

    public void open(SyntaxDocument syntaxDocument) {
        this.getCodeEditor().setDocument(syntaxDocument);
    }

    public void open(InputStream inputStream) throws IOException {
        this.open(inputStream, null);
    }

    public void open(InputStream inputStream, String string) throws IOException {
        StringBuffer stringBuffer = CodeEditorDocumentComponent.\u0101(inputStream, string);
        this.getCodeEditor().setText(stringBuffer.toString());
    }

    public void save(String string) throws IOException {
        this.save(new FileOutputStream(string));
    }

    public void save(String string, String string2) throws IOException {
        this.save(new FileOutputStream(string), string2);
    }

    public void save(OutputStream outputStream) throws IOException {
        this.save(outputStream, null);
    }

    public void save(OutputStream outputStream, String string) throws IOException {
        OutputStreamWriter outputStreamWriter = string == null ? new OutputStreamWriter(outputStream) : new OutputStreamWriter(outputStream, string);
        String string2 = this.getCodeEditor().getText();
        outputStream.write(string == null ? string2.getBytes() : string2.getBytes(string));
    }

    private static StringBuffer \u0101(InputStream inputStream, String string) throws IOException {
        int n2;
        InputStreamReader inputStreamReader = string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string);
        char[] cArray = new char[1024];
        StringBuffer stringBuffer = new StringBuffer();
        while ((n2 = inputStreamReader.read(cArray)) != -1) {
            stringBuffer.append(cArray, 0, n2);
        }
        ((Reader)inputStreamReader).close();
        return stringBuffer;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CodeEditorDocumentComponent codeEditorDocumentComponent = this.cloneDocumentComponent();
        codeEditorDocumentComponent.open(this.getCodeEditor().getDocument());
        codeEditorDocumentComponent.setLanguageName(this.getLanguageName());
        return codeEditorDocumentComponent;
    }

    protected CodeEditorDocumentComponent cloneDocumentComponent() {
        return new CodeEditorDocumentComponent(this.getName(), this.getTitle(), this.getIcon());
    }
}

