/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core.jdbc42;

import com.amazon.dsi.core.interfaces.IStatement;
import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.dataengine.utilities.ParameterType;
import com.amazon.dsi.exceptions.IncorrectTypeException;
import com.amazon.exceptions.ExceptionConverter;
import com.amazon.exceptions.JDBCMessageKey;
import com.amazon.jdbc.common.SConnection;
import com.amazon.jdbc.jdbc42.S42CallableStatement;
import com.amazon.redshift.core.PGDSIOverrideHelper;
import com.amazon.redshift.core.PGJDBCStatement;
import com.amazon.redshift.core.jdbc42.PGJDBCS42ForwardResultSet;
import com.amazon.redshift.dataengine.PGQueryExecutor;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import com.amazon.support.exceptions.ExceptionType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class PGJDBC42CallableStatement
extends S42CallableStatement {
    public static final int NOT_REGISTERED = -11111;
    private List<Integer> registeredType = new ArrayList<Integer>();
    private List<ParameterType> m_argModes = null;

    public PGJDBC42CallableStatement(String string, IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        super(string, iStatement, sConnection, n);
        if (this.m_queryExecutor instanceof PGQueryExecutor) {
            this.m_argModes = ((PGQueryExecutor)this.m_queryExecutor).getStoredProcArgModes();
            int n2 = ((PGQueryExecutor)this.m_queryExecutor).getOutputArgCount();
            this.m_parameterRegistered = new ArrayList(n2);
            for (int i = 0; i < n2; ++i) {
                this.m_parameterRegistered.add(i, Boolean.FALSE);
                this.registeredType.add(-11111);
            }
        }
    }

    @Override
    protected void checkValidParameterIndex(int n) throws SQLException {
        int n2 = this.m_numParameters;
        if (null != this.m_argModes && 0 < this.m_argModes.size()) {
            n2 = this.m_argModes.size();
        }
        PGDSIOverrideHelper.checkValidParameterIndex(n2, n, (PGJDBCStatement)this.m_statement, this.m_warningListener);
    }

    @Override
    public synchronized void registerOutParameter(int n, int n2, int n3) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, n2, n3);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            this.checkTypeSupported(n2);
            PGDSIOverrideHelper.registerOutParameter(n, n2, n3, this.m_warningListener, this.m_argModes, null, n3, ((PGQueryExecutor)this.m_queryExecutor).getStoredProcAllParamMetadata());
            int n4 = this.getOutputParameterOnlyIndex(n);
            this.registeredType.set(n4 - 1, n2);
            this.m_parameterRegistered.set(n4 - 1, Boolean.TRUE);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    protected void checkTypeSupported(int n) throws SQLException {
        switch (n) {
            case 2012: {
                break;
            }
            default: {
                super.checkTypeSupported(n);
            }
        }
    }

    @Override
    protected DataWrapper getOutputParameterValue(int n) throws SQLException {
        ResultSet resultSet = null;
        if (this.m_resultSets != null) {
            resultSet = super.getResultSet();
        }
        int n2 = -1;
        if (0 < ((PGQueryExecutor)this.m_queryExecutor).getOutputIndices().size()) {
            n2 = ((PGQueryExecutor)this.m_queryExecutor).getOutputIndices().indexOf(n - 1);
        }
        if (-1 == n2) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_INDEX, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, String.valueOf(n));
        }
        int n3 = this.registeredType.get(n2);
        if (1111 == n3 || 2012 == n3) {
            try {
                if (resultSet.isBeforeFirst()) {
                    resultSet.next();
                }
                String string = "\"" + resultSet.getString(n2 + 1) + "\"";
                PGJDBCS42ForwardResultSet pGJDBCS42ForwardResultSet = new PGJDBCS42ForwardResultSet(this, ((PGQueryExecutor)this.m_queryExecutor).getResultSetForRefCursor(string), this.m_logger);
                pGJDBCS42ForwardResultSet.initializeColumnNameMap();
                DataWrapper dataWrapper = new DataWrapper();
                dataWrapper.setData(n3, pGJDBCS42ForwardResultSet);
                return dataWrapper;
            }
            catch (ErrorException errorException) {
                throw ExceptionConverter.getInstance().toSQLException(errorException, this.m_warningListener, this.m_logger);
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(incorrectTypeException, this.m_warningListener, this.m_logger);
            }
        }
        return PGDSIOverrideHelper.getOutputParameterValue(n, resultSet, this.registeredType.get(n2), ((PGQueryExecutor)this.m_queryExecutor).getStoredProcAllParamMetadata(), n2 + 1, -11111);
    }

    @Override
    protected int getOutputParameterOnlyIndex(int n) throws SQLException {
        this.checkValidParameterIndex(n);
        return PGDSIOverrideHelper.getOutputParameterOnlyIndex(n, this.m_argModes, this.m_warningListener);
    }

    @Override
    public synchronized boolean execute() throws SQLException {
        boolean bl = super.execute();
        return bl;
    }

    @Override
    public synchronized ResultSet executeQuery() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        ResultSet resultSet = super.executeQuery();
        return resultSet;
    }
}

