/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.functions.Function;
import org.icepdf.core.pobjects.graphics.GraphicsState;
import org.icepdf.core.pobjects.graphics.PColorSpace;
import org.icepdf.core.pobjects.graphics.ShadingType2Pattern;
import org.icepdf.core.pobjects.graphics.batik.ext.awt.LinearGradientPaint;
import org.icepdf.core.pobjects.graphics.batik.ext.awt.MultipleGradientPaint;
import org.icepdf.core.util.Library;

public class ShadingType1Pattern
extends ShadingType2Pattern {
    private static final Logger logger = Logger.getLogger(ShadingType1Pattern.class.toString());
    private LinearGradientPaint linearGradientPaint;

    public ShadingType1Pattern(Library library, HashMap entries) {
        super(library, entries);
    }

    public synchronized void init(GraphicsState graphicsState) {
        if (this.inited) {
            return;
        }
        if (this.shadingDictionary == null) {
            this.shadingDictionary = this.library.getDictionary(this.entries, SHADING_KEY);
        }
        this.colorSpace = PColorSpace.getColorSpace(this.library, this.library.getObject(this.shadingDictionary, COLORSPACE_KEY));
        Object tmp = this.library.getObject(this.shadingDictionary, DOMAIN_KEY);
        if (tmp instanceof List) {
            this.domain = (List)tmp;
        } else {
            this.domain = new ArrayList(2);
            this.domain.add(Float.valueOf(0.0f));
            this.domain.add(Float.valueOf(1.0f));
            this.domain.add(Float.valueOf(0.0f));
            this.domain.add(Float.valueOf(1.0f));
        }
        tmp = this.library.getObject(this.shadingDictionary, FUNCTION_KEY);
        if (tmp != null) {
            if (!(tmp instanceof List)) {
                this.function = new Function[]{Function.getFunction(this.library, tmp)};
            } else {
                List functionTemp = (List)tmp;
                this.function = new Function[functionTemp.size()];
                for (int i = 0; i < functionTemp.size(); ++i) {
                    this.function[i] = Function.getFunction(this.library, functionTemp.get(i));
                }
            }
        }
        Point2D.Float startPoint = new Point2D.Float(((Number)this.domain.get(0)).floatValue(), ((Number)this.domain.get(2)).floatValue());
        Point2D.Float endPoint = new Point2D.Float(((Number)this.domain.get(0)).floatValue(), ((Number)this.domain.get(3)).floatValue());
        float t0 = ((Number)this.domain.get(0)).floatValue();
        float t1 = ((Number)this.domain.get(3)).floatValue();
        try {
            int numberOfPoints = 10;
            Color[] colors = this.calculateColorPoints(numberOfPoints, startPoint, endPoint, t0, t1);
            float[] dist = this.calculateDomainEntries(numberOfPoints, t0, t1);
            this.linearGradientPaint = new LinearGradientPaint(startPoint, endPoint, dist, colors, MultipleGradientPaint.NO_CYCLE, MultipleGradientPaint.LINEAR_RGB, this.matrix);
            this.inited = true;
        }
        catch (Exception e) {
            logger.finer("Failed ot initialize gradient paint type 1.");
        }
    }

    public Paint getPaint() {
        return null;
    }

    public String toSting() {
        return super.toString() + "\n                    domain: " + this.domain + "\n                    matrix: " + this.matrix + "\n                 function: " + this.function;
    }
}

