/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;

public class LogFileTailer
extends Thread {
    private static final String REPLACEMENT = "\ufffd";
    private static final int BUFFER_SIZE = 4096;
    private final File file;
    private final TailListener listener;
    private boolean initialScan = true;
    private LineQueue lineQueue;
    private Charset charset;
    private int maxBytesPerChar;
    private byte[] newline;
    private long lastPosition = 0L;
    private int replacementOffset = 0;
    private ByteBuffer readBuffer = ByteBuffer.allocate(4096);
    private ByteArrayOutputStream lineBuffer = new ByteArrayOutputStream();

    public LogFileTailer(File file, Charset charset, int maxLines, TailListener listener) {
        this.file = file;
        this.charset = charset;
        this.listener = listener;
        this.lineQueue = new LineQueue(maxLines);
        this.maxBytesPerChar = (int)this.charset.newEncoder().maxBytesPerChar();
        this.newline = "\n".getBytes(this.charset);
    }

    @Override
    public void run() {
        while (!this.isInterrupted()) {
            try {
                this.checkLogFile();
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException e) {
                return;
            }
            if (!this.initialScan) continue;
            this.listener.setText(this.getText());
            this.initialScan = false;
        }
        return;
    }

    private String getText() {
        StringBuilder buffer = new StringBuilder();
        for (String line : this.lineQueue) {
            buffer.append(line);
        }
        return buffer.toString();
    }

    private void checkLogFile() throws IOException, InterruptedException {
        Thread.sleep(200L);
        long fileLength = this.file.length();
        if (!this.initialScan && fileLength < this.lastPosition) {
            this.logFileRotated();
        } else if (fileLength > this.lastPosition) {
            String line;
            this.readBuffer.clear();
            this.readBuffer.flip();
            RandomAccessFile randomFileAccess = new RandomAccessFile(this.file, "rw");
            randomFileAccess.seek(this.lastPosition - (long)this.replacementOffset);
            this.replacementOffset = 0;
            while ((this.readBuffer.hasRemaining() || randomFileAccess.getFilePointer() < randomFileAccess.length()) && (line = this.readLine(randomFileAccess)) != null) {
                if (this.initialScan) {
                    this.lineQueue.add(line);
                    continue;
                }
                this.lineQueue.addText(line);
                this.listener.addText(line);
            }
            this.lastPosition = randomFileAccess.getFilePointer();
            randomFileAccess.close();
        }
    }

    private void logFileRotated() throws IOException, InterruptedException {
        this.lineQueue.clear();
        this.replacementOffset = 0;
        this.lastPosition = 0L;
        this.initialScan = true;
        this.checkLogFile();
    }

    public String readLine(RandomAccessFile in) throws IOException {
        this.lineBuffer.reset();
        boolean eof = false;
        int newlineCheckPosition = 0;
        while (true) {
            if (!this.readBuffer.hasRemaining() && !this.fillBuffer(in)) {
                eof = true;
                break;
            }
            byte b = this.readBuffer.get();
            this.lineBuffer.write(b);
            if (b == this.newline[newlineCheckPosition]) {
                if (++newlineCheckPosition != this.newline.length) continue;
                break;
            }
            newlineCheckPosition = 0;
        }
        byte[] bytes = this.lineBuffer.toByteArray();
        String string = new String(bytes, this.charset);
        if (eof) {
            while (string.endsWith(REPLACEMENT) && this.replacementOffset < this.maxBytesPerChar - 1) {
                ++this.replacementOffset;
                string = new String(bytes, 0, bytes.length - this.replacementOffset);
            }
        }
        return string;
    }

    private boolean fillBuffer(RandomAccessFile in) throws IOException {
        this.readBuffer.clear();
        int bytesRead = in.getChannel().read(this.readBuffer);
        this.readBuffer.flip();
        return bytesRead > 0;
    }

    public static interface TailListener {
        public void setText(@NotNull String var1);

        public void addText(@NotNull String var1);

        public void removeFirstLine();
    }

    private class LineQueue
    extends LinkedList<String> {
        private int capacity;

        public LineQueue(int capacity) {
            this.capacity = capacity;
        }

        @Override
        public boolean add(String e) {
            if (this.size() >= this.capacity) {
                this.removeFirst();
                LogFileTailer.this.listener.removeFirstLine();
            }
            return super.add(e);
        }

        public void addText(String text) {
            if (this.size() > 0) {
                String lastLine = (String)this.getLast();
                if (!lastLine.endsWith("\n")) {
                    this.removeLast();
                    this.add(lastLine + text);
                } else {
                    this.add(text);
                }
            } else {
                this.add(text);
            }
        }
    }
}

