/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.ProtocolException;
import com.exasol.jdbc.Translator;
import com.sun.jna.Platform;
import com.sun.jna.platform.win32.Sspi;
import com.sun.jna.platform.win32.Win32Exception;
import java.io.IOException;
import java.sql.SQLException;
import waffle.windows.auth.IWindowsCredentialsHandle;
import waffle.windows.auth.impl.WindowsCredentialsHandleImpl;
import waffle.windows.auth.impl.WindowsSecurityContextImpl;

public class SSPIClient {
    private EXAConnection connection;
    private IWindowsCredentialsHandle clientCredentials;
    private WindowsSecurityContextImpl sspiContext;
    private String targetName;

    public SSPIClient(EXAConnection eXAConnection) {
        this.connection = eXAConnection;
    }

    public boolean isSSPISupported() {
        try {
            if (!Platform.isWindows()) {
                this.connection.log("SSPI supported only on Windows.");
                return false;
            }
            Class.forName("waffle.windows.auth.impl.WindowsSecurityContextImpl");
            return true;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            this.connection.log("SSPI not available. Please make shure that the Waffle/JNA libraries are in the classpath." + noClassDefFoundError.getMessage());
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.connection.log("SSPI unavailable (no Waffle/JNA libraries?)" + classNotFoundException.getMessage());
            return false;
        }
    }

    public void startSSPI() throws SQLException, IOException {
        this.connection.log("Begin SSPI negotiation with package: kerberos");
        try {
            this.clientCredentials = WindowsCredentialsHandleImpl.getCurrent((String)"kerberos");
            this.clientCredentials.initialize();
        }
        catch (Win32Exception win32Exception) {
            throw new SQLException("Cannot get Windows SSPI credentials." + win32Exception.getMessage());
        }
        try {
            this.targetName = this.connection.getKerberosTargetNameSSPI();
            this.connection.log("SSPI target name: " + this.targetName);
            this.sspiContext = new WindowsSecurityContextImpl();
            this.sspiContext.setPrincipalName(this.targetName);
            this.sspiContext.setCredentialsHandle(this.clientCredentials.getHandle());
            this.sspiContext.setSecurityPackage("kerberos");
            this.sspiContext.initialize(null, null, this.targetName);
        }
        catch (Win32Exception win32Exception) {
            throw new SQLException("Cannot initialize SSPI security context. " + win32Exception.getMessage());
        }
        if (null != this.sendSSPIResponse(this.sspiContext.getToken())) {
            throw new ProtocolException(Translator.Connection_refused() + " Unsexpected response from server.");
        }
        this.connection.getAttributes();
    }

    public void continueSSPI(int n) throws SQLException, IOException {
        if (this.sspiContext == null) {
            throw new IllegalStateException("Cannot continue SSPI authentication that we didn't begin");
        }
        this.connection.log("Continuing SSPI negotiation");
        byte[] byArray = null;
        Sspi.SecBufferDesc secBufferDesc = new Sspi.SecBufferDesc(2, byArray);
        this.sspiContext.initialize(this.sspiContext.getHandle(), secBufferDesc, this.targetName);
        byte[] byArray2 = this.sspiContext.getToken();
        if (byArray2.length > 0) {
            this.sendSSPIResponse(byArray2);
        } else {
            this.connection.log("SSPI authentication done.");
        }
    }

    private byte[] sendSSPIResponse(byte[] byArray) throws SQLException {
        byte[] byArray2 = null;
        if (byArray != null) {
            byArray2 = this.connection.exchangeTicket(byArray);
        }
        return byArray2;
    }

    public void dispose() {
        if (this.sspiContext != null) {
            this.sspiContext.dispose();
            this.sspiContext = null;
        }
        if (this.clientCredentials != null) {
            this.clientCredentials.dispose();
            this.clientCredentials = null;
        }
    }
}

