/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.security;

import com.nuodb.impl.security.RemoteGroup;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public class RemotePassword {
    static byte[] hexDigits;
    MessageDigest sha1;
    BigInteger prime;
    BigInteger generator;
    BigInteger k;
    BigInteger clientPrivateKey;
    BigInteger clientPublicKey;
    BigInteger serverPrivateKey;
    BigInteger serverPublicKey;
    BigInteger scramble;
    Random random;

    public RemotePassword() {
        RemoteGroup group = RemoteGroup.getGroup(1024);
        this.prime = group.prime;
        this.generator = group.generator;
        this.k = group.k;
        this.random = RemoteGroup.random;
        try {
            this.sha1 = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        String saltString = "BEB25379D1A8581EB5A727673A2441EE";
        String a = "60975527035CF2AD1989806F0407210BC81EDC04E2762A56AFD529DDDA2D4393";
        String b = "E487CB59D31AC550471E81F00F6928E01DDA08E974A004F49E61F5D105284D20";
        RemotePassword server = new RemotePassword();
        RemotePassword client = new RemotePassword();
        String verifier = server.computeVerifier("alice", "password123", saltString);
        String clientKey = client.setClientPrivateKey(a);
        String serverKey = server.setServerPrivateKey(b, verifier);
        byte[] key1 = client.computeSessionKey("alice", "password123", saltString, serverKey);
        byte[] key2 = server.computeSessionKey(clientKey, verifier);
        System.out.println();
    }

    public static BigInteger getBigInteger(String hex) {
        return new BigInteger(1, RemotePassword.getBytes(hex));
    }

    public static byte[] getBytes(String hex) {
        int length = hex.length() / 2;
        byte[] bytes = new byte[length];
        int n = 0;
        int c = 0;
        while (n < length) {
            bytes[n] = (byte)(hexDigits[hex.charAt(c)] << 4 | hexDigits[hex.charAt(c + 1)]);
            ++n;
            c += 2;
        }
        return bytes;
    }

    public static String getHex(BigInteger number) {
        return RemotePassword.getHex(number.toByteArray());
    }

    public static String getHex(byte[] rep) {
        int n = 0;
        int length = rep.length;
        if (rep[0] == 0) {
            ++n;
            --length;
        }
        byte[] hex = new byte[length * 2];
        int c = 0;
        while (n < rep.length) {
            int b = rep[n] & 0xFF;
            int high = b >> 4;
            int low = b & 0xF;
            hex[c++] = (byte)(high < 10 ? 48 + high : 65 + high - 10);
            hex[c++] = (byte)(low < 10 ? 48 + low : 65 + low - 10);
            ++n;
        }
        return new String(hex);
    }

    public BigInteger getUserHash(String account, String password, String salt) {
        this.sha1.reset();
        this.sha1.update(account.getBytes());
        this.sha1.update(":".getBytes());
        this.sha1.update(password.getBytes());
        byte[] hash1 = this.sha1.digest();
        byte[] saltBytes = RemotePassword.getBytes(salt);
        this.sha1.reset();
        this.sha1.update(saltBytes);
        return new BigInteger(1, this.sha1.digest(hash1));
    }

    public String computeVerifier(String account, String password, String salt) {
        BigInteger x = this.getUserHash(account, password, salt);
        BigInteger verifier = this.generator.modPow(x, this.prime);
        byte[] result = verifier.toByteArray();
        return RemotePassword.getHex(result);
    }

    public String setClientPrivateKey(String key) {
        this.clientPrivateKey = new BigInteger(1, RemotePassword.getBytes(key));
        this.clientPublicKey = this.generator.modPow(this.clientPrivateKey, this.prime);
        return RemotePassword.getHex(this.clientPublicKey);
    }

    public String genClientKey() {
        this.clientPrivateKey = new BigInteger(256, this.random);
        this.clientPublicKey = this.generator.modPow(this.clientPrivateKey, this.prime);
        return RemotePassword.getHex(this.clientPublicKey);
    }

    public String setServerPrivateKey(String key, String verifier) {
        return this.genServerKey(new BigInteger(1, RemotePassword.getBytes(key)), verifier);
    }

    public String genServerKey(BigInteger privateKey, String verifier) {
        this.serverPrivateKey = privateKey;
        BigInteger gb = this.generator.modPow(this.serverPrivateKey, this.prime);
        BigInteger v = new BigInteger(1, RemotePassword.getBytes(verifier));
        BigInteger kv = this.k.multiply(v);
        kv = kv.mod(this.prime);
        this.serverPublicKey = kv.add(gb);
        this.serverPublicKey = this.serverPublicKey.mod(this.prime);
        return RemotePassword.getHex(this.serverPublicKey);
    }

    public String genServerKey(String verifier) {
        return this.genServerKey(new BigInteger(256, this.random), verifier);
    }

    public void computeScramble() {
        byte[] client = this.clientPublicKey.toByteArray();
        byte[] server = this.serverPublicKey.toByteArray();
        this.sha1.reset();
        int n = client[0] == 0 ? 1 : 0;
        this.sha1.update(client, n, client.length - n);
        n = server[0] == 0 ? 1 : 0;
        this.sha1.update(server, n, server.length - n);
        this.scramble = new BigInteger(1, this.sha1.digest());
    }

    public byte[] computeSessionKey(String account, String password, String salt, String serverPubKey) {
        this.serverPublicKey = RemotePassword.getBigInteger(serverPubKey);
        this.computeScramble();
        BigInteger x = this.getUserHash(account, password, salt);
        BigInteger gx = this.generator.modPow(x, this.prime);
        BigInteger kgx = this.k.multiply(gx).mod(this.prime);
        BigInteger diff = this.serverPublicKey.subtract(kgx).mod(this.prime);
        BigInteger ux = this.scramble.multiply(x).mod(this.prime);
        BigInteger aux = this.clientPrivateKey.add(ux).mod(this.prime);
        BigInteger sessionSecret = diff.modPow(aux, this.prime);
        byte[] secret = sessionSecret.toByteArray();
        int n = secret[0] == 0 ? 1 : 0;
        this.sha1.reset();
        this.sha1.update(secret, n, secret.length - n);
        return this.sha1.digest();
    }

    public byte[] computeSessionKey(String clientPubKey, String verifier) {
        this.clientPublicKey = RemotePassword.getBigInteger(clientPubKey);
        this.computeScramble();
        BigInteger v = RemotePassword.getBigInteger(verifier);
        BigInteger vu = v.modPow(this.scramble, this.prime);
        BigInteger Avu = this.clientPublicKey.multiply(vu).mod(this.prime);
        BigInteger sessionSecret = Avu.modPow(this.serverPrivateKey, this.prime);
        byte[] secret = sessionSecret.toByteArray();
        int n = secret[0] == 0 ? 1 : 0;
        this.sha1.reset();
        this.sha1.update(secret, n, secret.length - n);
        return this.sha1.digest();
    }

    public String genSalt() {
        BigInteger n = new BigInteger(256, this.random);
        return RemotePassword.getHex(n);
    }

    static {
        int n;
        hexDigits = new byte[256];
        for (n = 0; n < 10; ++n) {
            RemotePassword.hexDigits[48 + n] = (byte)n;
        }
        for (n = 0; n < 6; n = (int)((byte)(n + 1))) {
            RemotePassword.hexDigits[97 + n] = (byte)(10 + n);
            RemotePassword.hexDigits[65 + n] = (byte)(10 + n);
        }
    }
}

