/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.plaf.jytabbedpane;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaRootPaneUI;
import de.javasoft.swing.JYTabbedPane;
import de.javasoft.swing.WidgetUtils;
import de.javasoft.swing.plaf.jytabbedpane.IButtonFactory;
import de.javasoft.swing.plaf.jytabbedpane.TabOverviewPreviewPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class TabOverviewDialog
extends JDialog {
    private JYTabbedPane tabPane;
    private IButtonFactory buttonFactory;
    private TabOverviewPanel overviewPanel;
    private PreviewThread previewThread;
    private PropertyChangeListener lafSwitchListener;

    public TabOverviewDialog(JYTabbedPane jYTabbedPane, IButtonFactory iButtonFactory) {
        super(SwingUtilities.getWindowAncestor(jYTabbedPane) instanceof Frame ? (Frame)SwingUtilities.getWindowAncestor(jYTabbedPane) : (Dialog)SwingUtilities.getWindowAncestor(jYTabbedPane));
        this.tabPane = jYTabbedPane;
        this.buttonFactory = iButtonFactory;
        this.setLayout(new BorderLayout());
        Rectangle rectangle = this.getPreviewDialogScreenBounds(jYTabbedPane);
        this.installOverviewPanel(rectangle);
        this.applyComponentOrientation(jYTabbedPane.getComponentOrientation());
        this.setTitle(UIManager.getString("JYTabbedPane.tabOverviewDialog.title"));
        this.setDefaultCloseOperation(2);
        this.setLocation(rectangle.x, rectangle.y);
        this.setSize(rectangle.width, rectangle.height);
        this.setResizable(false);
        this.installListener();
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "CloseTabOverview");
        this.getRootPane().getActionMap().put("CloseTabOverview", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                TabOverviewDialog.this.dispose();
            }
        });
    }

    private void installListener() {
        final Window window = SwingUtilities.getWindowAncestor(this.tabPane);
        final WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                TabOverviewDialog.this.dispose();
            }
        };
        window.addWindowListener(windowAdapter);
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("activeWindow".equals(propertyChangeEvent.getPropertyName()) && TabOverviewDialog.this == propertyChangeEvent.getOldValue()) {
                    TabOverviewDialog.this.dispose();
                }
            }
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(propertyChangeListener);
        this.lafSwitchListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("lookAndFeel".equals(propertyChangeEvent.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SwingUtilities.updateComponentTreeUI(TabOverviewDialog.this);
                        }
                    });
                }
            }
        };
        UIManager.addPropertyChangeListener(this.lafSwitchListener);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                if (TabOverviewDialog.this.previewThread != null) {
                    TabOverviewDialog.this.previewThread.interrupt();
                }
                window.removeWindowListener(windowAdapter);
                KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(propertyChangeListener);
                UIManager.removePropertyChangeListener(TabOverviewDialog.this.lafSwitchListener);
            }
        });
    }

    Rectangle getPreviewDialogScreenBounds(JTabbedPane jTabbedPane) {
        Rectangle rectangle = jTabbedPane.getBounds();
        Point point = jTabbedPane.getLocationOnScreen();
        return new Rectangle(point.x, point.y, rectangle.width, rectangle.height);
    }

    void installOverviewPanel(Rectangle rectangle) {
        if (this.overviewPanel != null) {
            this.remove(this.overviewPanel);
        }
        int n = 24;
        if (this.getRootPane().getUI() instanceof SyntheticaRootPaneUI) {
            n = ((SyntheticaRootPaneUI)this.getRootPane().getUI()).getTitlePane().getPreferredSize().height;
        }
        Insets insets = this.getRootPane().getInsets();
        this.overviewPanel = new TabOverviewPanel(rectangle.width - insets.left - insets.right, rectangle.height - insets.top - insets.bottom - n);
        this.add((Component)this.overviewPanel, "Center");
    }

    private static interface PreviewImageProvider {
        public void init(JYTabbedPane var1);

        public void provide(JYTabbedPane var1, int var2, BufferedImage var3, int var4, int var5);
    }

    private class PreviewThread
    extends Thread {
        private int tabPreviewIndex;
        private PreviewImageProvider provider;
        private boolean processing;

        public PreviewThread(int n, PreviewImageProvider previewImageProvider) {
            this.tabPreviewIndex = n;
            this.provider = previewImageProvider;
            this.setName("JYTabbedPane-TabPreview");
            this.setDaemon(true);
        }

        public void run() {
            while (!this.isInterrupted()) {
                try {
                    int n;
                    if (!this.processing) {
                        this.processing = true;
                        this.provider.init(TabOverviewDialog.this.tabPane);
                        if (this.tabPreviewIndex >= 0) {
                            this.setPreviewImage(TabOverviewDialog.this.tabPane, this.tabPreviewIndex, this.getPreviewImageWidth(), this.getPreviewImageHeight(), true);
                        } else {
                            n = TabOverviewDialog.this.tabPane.getTabCount();
                            int n2 = 0;
                            while (n2 < n) {
                                this.setPreviewImage(TabOverviewDialog.this.tabPane, n2, this.getPreviewImageWidth(), this.getPreviewImageHeight(), n - 1 == n2);
                                ++n2;
                            }
                        }
                    }
                    if ((n = SyntheticaLookAndFeel.getInt("JYTabbedPane.tabOverview.refreshTime", TabOverviewDialog.this.tabPane, -1)) <= 0) break;
                    Thread.sleep(Math.max(100, n));
                }
                catch (InterruptedException interruptedException) {
                    this.interrupt();
                }
            }
        }

        private int getPreviewImageWidth() {
            return Math.max(0, TabOverviewDialog.this.overviewPanel.previewWidth - ((TabOverviewPanel)((TabOverviewDialog)TabOverviewDialog.this).overviewPanel).previewPanelInsets.left - ((TabOverviewPanel)((TabOverviewDialog)TabOverviewDialog.this).overviewPanel).previewPanelInsets.right - ((TabOverviewPanel)((TabOverviewDialog)TabOverviewDialog.this).overviewPanel).tabOverviewGridInsets.left - ((TabOverviewPanel)((TabOverviewDialog)TabOverviewDialog.this).overviewPanel).tabOverviewGridInsets.right);
        }

        private int getPreviewImageHeight() {
            return Math.max(0, TabOverviewDialog.this.overviewPanel.previewHeight - ((TabOverviewPanel)((TabOverviewDialog)TabOverviewDialog.this).overviewPanel).previewPanelInsets.top - ((TabOverviewPanel)((TabOverviewDialog)TabOverviewDialog.this).overviewPanel).previewPanelInsets.bottom - ((TabOverviewPanel)((TabOverviewDialog)TabOverviewDialog.this).overviewPanel).tabOverviewGridInsets.top - ((TabOverviewPanel)((TabOverviewDialog)TabOverviewDialog.this).overviewPanel).tabOverviewGridInsets.bottom);
        }

        private void setPreviewImage(final JYTabbedPane jYTabbedPane, final int n, final int n2, final int n3, final boolean bl) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (n < jYTabbedPane.getTabCount()) {
                        boolean bl2 = SyntheticaLookAndFeel.getBoolean("JYTabbedPane.tabOverview.centerThumbnails", jYTabbedPane, true);
                        BufferedImage bufferedImage = WidgetUtils.createPreviewImage(jYTabbedPane.getComponentAt(n), 0, 0, n2, n3, bl2);
                        PreviewThread.this.provider.provide(jYTabbedPane, n, bufferedImage, n2, n3);
                        PreviewThread.this.processing = !bl;
                    }
                }
            });
        }
    }

    private class TabOverviewPanel
    extends JPanel {
        private TabOverviewPreviewPanel[] previewPanels;
        private Insets overviewPanelInsets;
        private Insets previewPanelInsets;
        private Insets tabOverviewGridInsets;
        private int previewWidth;
        private int previewHeight;

        public TabOverviewPanel(final int n, final int n2) {
            this.setName("JYTabbedPane.TabOverviewPanel");
            this.overviewPanelInsets = SyntheticaLookAndFeel.getInsets("JYTabbedPane.tabOverviewPanel.insets", (Component)TabOverviewDialog.this.tabPane, new Insets(1, 1, 1, 1));
            this.setBorder(new EmptyBorder(this.overviewPanelInsets));
            this.previewPanelInsets = TabOverviewPreviewPanel.getPreviewPanelInsets(TabOverviewDialog.this.tabPane);
            this.tabOverviewGridInsets = SyntheticaLookAndFeel.getInsets("JYTabbedPane.tabOverview.gridInsets", (Component)TabOverviewDialog.this.tabPane, new Insets(1, 1, 1, 1));
            PreviewImageProvider previewImageProvider = new PreviewImageProvider(){

                public void init(final JYTabbedPane jYTabbedPane) {
                    final int n3 = jYTabbedPane.getTabCount();
                    final int n22 = TabOverviewPanel.this.calcColumns(n3);
                    TabOverviewPanel.this.initPreviewSize(n, n2, n22);
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            GridBagConstraints gridBagConstraints = new GridBagConstraints();
                            gridBagConstraints.weightx = 0.0;
                            gridBagConstraints.weighty = 0.0;
                            gridBagConstraints.insets = TabOverviewPanel.this.tabOverviewGridInsets;
                            gridBagConstraints.anchor = 23;
                            if (TabOverviewPanel.this.previewPanels == null || TabOverviewPanel.this.previewPanels.length != n3) {
                                TabOverviewPanel.this.removeAll();
                                TabOverviewPanel.this.previewPanels = new TabOverviewPreviewPanel[n3];
                                int n = 0;
                                while (n < n3) {
                                    TabOverviewPreviewPanel tabOverviewPreviewPanel = new TabOverviewPreviewPanel(jYTabbedPane, n, TabOverviewDialog.this.buttonFactory);
                                    tabOverviewPreviewPanel.setPreferredSize(new Dimension(TabOverviewPanel.this.previewWidth, TabOverviewPanel.this.previewHeight));
                                    tabOverviewPreviewPanel.setMinimumSize(new Dimension(TabOverviewPanel.this.previewWidth, TabOverviewPanel.this.previewHeight));
                                    ((TabOverviewPanel)(this).TabOverviewPanel.this).previewPanels[n] = tabOverviewPreviewPanel;
                                    gridBagConstraints.gridx = n % n22;
                                    gridBagConstraints.gridy = n / n22;
                                    TabOverviewPanel.this.add((Component)tabOverviewPreviewPanel, gridBagConstraints);
                                    ++n;
                                }
                                ++gridBagConstraints.gridy;
                                gridBagConstraints.fill = 3;
                                gridBagConstraints.weighty = 1.0;
                                Box box = Box.createVerticalBox();
                                TabOverviewPanel.this.add((Component)box, gridBagConstraints);
                                TabOverviewPanel.this.repaint();
                            }
                        }
                    });
                }

                public void provide(JYTabbedPane jYTabbedPane, int n4, BufferedImage bufferedImage, int n22, int n3) {
                    TabOverviewPanel.this.previewPanels[n4].setPreviewImage(bufferedImage, n22, n3);
                }
            };
            this.setLayout(new GridBagLayout());
            previewImageProvider.init(TabOverviewDialog.this.tabPane);
            TabOverviewDialog.this.previewThread = new PreviewThread(-1, previewImageProvider);
            TabOverviewDialog.this.previewThread.start();
        }

        private int calcColumns(int n) {
            int n2 = (int)Math.sqrt(n);
            if (n2 * n2 < n) {
                ++n2;
            }
            return n2;
        }

        private void initPreviewSize(int n, int n2, int n3) {
            this.previewWidth = n3 == 0 ? 0 : (n - this.overviewPanelInsets.left - this.overviewPanelInsets.right) / n3;
            this.previewHeight = n3 == 0 ? 0 : (n2 - this.overviewPanelInsets.top - this.overviewPanelInsets.bottom) / n3;
        }
    }
}

