/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.swing.jydocking.DockingPath;
import java.awt.Point;
import java.io.Serializable;

public class DockingState
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -6782228304231760001L;
    private String dockableID;
    private String relativeParentID;
    private String region = "UNKNOWN";
    private float splitRatio = -1.0f;
    private int placement = -1;
    private boolean maximized;
    private String floatingGroupID;
    private int centerX = -1;
    private int centerY = -1;
    private DockingPath dockingPath;
    private boolean active;
    private boolean selected;

    public DockingState(String string) {
        this.dockableID = string;
    }

    public String getDockableID() {
        return this.dockableID;
    }

    public void setRelativeParentID(String string) {
        this.relativeParentID = string;
    }

    public String getRelativeParentID() {
        return this.relativeParentID;
    }

    public void setRegion(String string) {
        this.region = string;
    }

    public String getRegion() {
        return this.region;
    }

    public void setSplitRatio(float f) {
        this.splitRatio = f;
    }

    public float getSplitRatio() {
        return this.splitRatio;
    }

    public void setFloatingGroupID(String string) {
        this.floatingGroupID = string;
        if (string != null) {
            this.placement = -1;
        }
    }

    public String getFloatingGroupID() {
        return this.floatingGroupID;
    }

    public boolean isFloating() {
        return this.floatingGroupID != null;
    }

    public void setPlacement(int n) {
        this.placement = n;
        if (n != -1) {
            this.floatingGroupID = null;
        }
    }

    public int getPlacement() {
        return this.placement;
    }

    public boolean isMinimized() {
        return this.placement != -1;
    }

    public void setMaximized(boolean bl) {
        this.maximized = bl;
    }

    public boolean getMaximized() {
        return this.maximized;
    }

    public boolean isMaximized() {
        return this.maximized;
    }

    public void setCenterX(int n) {
        this.centerX = n;
    }

    public int getCenterX() {
        return this.centerX;
    }

    public void setCenterY(int n) {
        this.centerY = n;
    }

    public int getCenterY() {
        return this.centerY;
    }

    public void setCenter(Point point) {
        this.centerX = point == null ? 0 : point.x;
        this.centerY = point == null ? 0 : point.y;
    }

    public Point getCenterPoint() {
        if (this.centerX == -1 || this.centerY == -1) {
            return null;
        }
        return new Point(this.centerX, this.centerY);
    }

    public boolean hasCenterPoint() {
        return this.centerX != -1 && this.centerY != -1;
    }

    public DockingPath getPath() {
        return this.dockingPath;
    }

    public void setPath(DockingPath dockingPath) {
        this.dockingPath = dockingPath;
    }

    public boolean hasDockingPath() {
        return this.dockingPath != null;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public Object clone() {
        DockingState dockingState = new DockingState(this.dockableID);
        dockingState.relativeParentID = this.relativeParentID;
        dockingState.region = this.region;
        dockingState.splitRatio = this.splitRatio;
        dockingState.floatingGroupID = this.floatingGroupID;
        dockingState.maximized = this.maximized;
        dockingState.placement = this.placement;
        dockingState.dockingPath = this.dockingPath == null ? null : (DockingPath)this.dockingPath.clone();
        dockingState.centerX = this.centerX;
        dockingState.centerY = this.centerY;
        dockingState.active = this.active;
        dockingState.selected = this.selected;
        return dockingState;
    }

    public String toString() {
        return "DockingState[id=" + this.dockableID + "; center=[" + this.centerX + "%," + this.centerY + "%]" + "; parent=" + this.relativeParentID + "; region=" + this.region + "; ratio=" + this.splitRatio + "; float=" + this.floatingGroupID + "; minimization=" + this.placement + "; maximized=" + this.maximized + "; active=" + this.active + "; selected=" + this.selected + "; ]";
    }
}

