/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.kv;

import com.vertica.core.VConnection;
import com.vertica.jdbc.kv.KVErrors;
import com.vertica.jdbc.kv.OutputColumn;
import com.vertica.jdbc.kv.ProjectionMetadata;
import com.vertica.jdbc.kv.RoutableConnection;
import com.vertica.jdbc.kv.RoutableConnectionPool;
import com.vertica.jdbc.kv.SQLWarningChainer;
import com.vertica.jdbc.kv.TableMetadata;
import com.vertica.jdbc.kv.TableMetadataCache;
import com.vertica.util.TypeUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CachedTableMetadata
implements TableMetadata {
    String key;
    String schema;
    String table;
    SQLWarningChainer warnings;
    TableMetadataCache tmc;

    public CachedTableMetadata(TableMetadataCache tableMetadataCache, String string, String string2, SQLWarningChainer sQLWarningChainer) throws SQLException {
        string = string == null ? "" : string.trim();
        this.key = tableMetadataCache.makeKey(string, string2);
        this.tmc = tableMetadataCache;
        this.schema = string;
        this.table = string2;
        this.warnings = sQLWarningChainer;
        this.get(this.key, string, string2);
    }

    private RawTableMetadata get(String string, String string2, String string3) throws SQLException {
        RawTableMetadata rawTableMetadata = new RawTableMetadata(this.tmc.pool, string2, string3);
        RawTableMetadata rawTableMetadata2 = null;
        rawTableMetadata2 = (RawTableMetadata)this.tmc.cache.putIfAbsent(string, rawTableMetadata);
        try {
            if (rawTableMetadata2 == null) {
                rawTableMetadata.initialize(this.warnings);
                return rawTableMetadata;
            }
            rawTableMetadata2.initialize(this.warnings);
            long l = (long)((VConnection)this.tmc.pool.parentConn.getConnection()).getMetadataCacheLifetime() * 1000L;
            if (System.currentTimeMillis() - rawTableMetadata2.createTime.get() > l) {
                this.tmc.cache.remove(string, rawTableMetadata2);
                return this.get(string, string2, string3);
            }
            return rawTableMetadata2;
        }
        catch (SQLException sQLException) {
            this.tmc.cache.remove(rawTableMetadata2 == null ? rawTableMetadata : rawTableMetadata2);
            throw sQLException;
        }
    }

    @Override
    public boolean isFlexTable() throws SQLException {
        return this.get(this.key, this.schema, this.table).isFlexTable();
    }

    @Override
    public boolean containsColumn(String string) throws SQLException {
        return this.get(this.key, this.schema, this.table).containsColumn(string);
    }

    @Override
    public boolean isValuesTypeCompatible(String string, Object object) throws SQLException {
        return this.get(this.key, this.schema, this.table).isValuesTypeCompatible(string, object);
    }

    @Override
    public int getColumnType(String string) throws SQLException {
        return this.get(this.key, this.schema, this.table).getColumnType(string);
    }

    @Override
    public int getColumnTypeMod(String string) throws SQLException {
        return this.get(this.key, this.schema, this.table).getColumnTypeMod(string);
    }

    @Override
    public List<ProjectionMetadata.ProjectionRanking> getProjectionsFor(Set<String> set, List<OutputColumn> list) throws SQLException {
        return this.get(this.key, this.schema, this.table).getProjectionsFor(set, list);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RawTableMetadata
    implements TableMetadata {
        private static final Pattern projPattern = Pattern.compile("([\\w\\-_\\.]+) \\[Segmented: (\\w+)\\] \\[Seg Cols: ([\\w_\\-\",\\. ]*)\\] \\[K: ([\\d+])\\] \\[([\\w_\\- ,\\.]+)\\] \\[Safe: Yes\\] \\[UptoDate: Yes\\] \\[Node: ([\\w\\-_,\\.]*)]");
        private static final List<OutputColumn> flexTableOutputCols = new ArrayList<OutputColumn>(0);
        final RoutableConnectionPool pool;
        final String schema;
        final String table;
        AtomicLong createTime;
        ReentrantLock initLock;
        volatile SQLException loadEx;
        final Map<String, ProjectionMetadata> projections;
        final Set<String> tableColNames;
        final List<OutputColumn> tableColList;
        final Map<String, Integer> columnTypes;
        final Map<String, Integer> columnTypeMods;
        boolean isFlexTable;
        boolean tableIsProjection = false;

        public RawTableMetadata(RoutableConnectionPool routableConnectionPool, String string, String string2) {
            this.pool = routableConnectionPool;
            this.schema = string;
            this.table = string2;
            this.projections = new HashMap<String, ProjectionMetadata>();
            this.tableColNames = new HashSet<String>();
            this.tableColList = new ArrayList<OutputColumn>();
            this.columnTypes = new HashMap<String, Integer>();
            this.columnTypeMods = new HashMap<String, Integer>();
            this.createTime = new AtomicLong(0L);
            this.initLock = new ReentrantLock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void initialize(SQLWarningChainer sQLWarningChainer) throws SQLException {
            if (this.createTime.get() == 0L) {
                this.initLock.lock();
                try {
                    if (this.createTime.get() == 0L) {
                        this.loadMetadata(sQLWarningChainer);
                    } else if (this.loadEx != null) {
                        throw this.loadEx;
                    }
                    Object var3_2 = null;
                    this.initLock.unlock();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.initLock.unlock();
                    throw throwable;
                }
            }
        }

        @Override
        public boolean containsColumn(String string) throws SQLException {
            return this.tableColNames.contains(string);
        }

        @Override
        public boolean isValuesTypeCompatible(String string, Object object) throws SQLException {
            int n = this.columnTypes.get(string);
            if (n == 1111 || n == 3 || n == -2 || n == -3 || n == -4) {
                return false;
            }
            if (object == null) {
                return true;
            }
            switch (n) {
                case -7: 
                case 16: {
                    return object instanceof Boolean;
                }
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    return object instanceof Number;
                }
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    return object instanceof String;
                }
                case 91: 
                case 92: 
                case 93: {
                    return object instanceof Date || object instanceof Calendar;
                }
                case -4: 
                case -3: 
                case -2: {
                    return object instanceof byte[];
                }
                case -11: {
                    return object instanceof UUID;
                }
            }
            return false;
        }

        @Override
        public int getColumnType(String string) throws SQLException {
            return this.columnTypes.get(string);
        }

        @Override
        public int getColumnTypeMod(String string) throws SQLException {
            return this.columnTypeMods.get(string);
        }

        @Override
        public List<ProjectionMetadata.ProjectionRanking> getProjectionsFor(Set<String> set, List<OutputColumn> list) throws SQLException {
            ArrayList<ProjectionMetadata.ProjectionRanking> arrayList = new ArrayList<ProjectionMetadata.ProjectionRanking>(this.projections.size());
            for (ProjectionMetadata projectionMetadata : this.projections.values()) {
                List<OutputColumn> list2 = list.size() == 0 ? this.tableColList : list;
                list2 = this.isFlexTable ? flexTableOutputCols : list2;
                if (!projectionMetadata.canServiceQuery(set, list2)) continue;
                int n = projectionMetadata.calculateRank(set);
                arrayList.add(new ProjectionMetadata.ProjectionRanking(n, projectionMetadata));
            }
            Collections.sort(arrayList);
            return arrayList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void loadMetadata(SQLWarningChainer sQLWarningChainer) throws SQLException {
            if (this.pool.log.isEnabled()) {
                this.pool.log.logDebug("Getting metadata for table " + this.schema + "." + this.table);
            }
            this.projections.clear();
            this.tableColNames.clear();
            this.tableColList.clear();
            this.columnTypes.clear();
            this.columnTypeMods.clear();
            RoutableConnection routableConnection = this.pool.getAnyConnection();
            try {
                try {
                    int n;
                    String[] stringArray;
                    int n2;
                    CharSequence charSequence;
                    ResultSet resultSet;
                    Connection connection = routableConnection.conn;
                    Statement statement = connection.createStatement();
                    String string = "quote_ident('" + this.table + "')";
                    if (!this.schema.equals("")) {
                        string = "quote_ident('" + this.schema + "') || '.' || " + string;
                    }
                    if (!(resultSet = statement.executeQuery("select get_kv_projection_metadata(" + string + ")")).next()) {
                        throw KVErrors.NoCompatibleProjections.makeException(this.schema + "." + this.table);
                    }
                    String string2 = resultSet.getString(1);
                    if (string2 != null && string2.trim().equals("")) {
                        throw KVErrors.NoCompatibleProjections.makeException(this.schema + "." + this.table);
                    }
                    resultSet.close();
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    Matcher matcher = projPattern.matcher(string2);
                    while (matcher.find()) {
                        charSequence = matcher.group(1);
                        n2 = ((String)charSequence).indexOf(46);
                        String string3 = ((String)charSequence).substring(0, n2);
                        String string4 = ((String)charSequence).substring(n2 + 1);
                        if (string4.equals(this.table)) {
                            this.tableIsProjection = true;
                        }
                        boolean bl = "Yes".equals(matcher.group(2));
                        ProjectionMetadata projectionMetadata = new ProjectionMetadata(this.schema, this.table, string4, bl);
                        if (!"0".equals(matcher.group(4))) {
                            projectionMetadata.buddies = matcher.group(5).split(", ");
                        }
                        if (bl) {
                            resultSet = statement.executeQuery("select vs_segments.offset from vs_segments where vs_segments.proj = (select oid from vs_projections where name ='" + string4 + "' and schemaname ='" + (String)string3 + "')");
                            if (resultSet.next()) {
                                projectionMetadata.offset = (int)resultSet.getLong(1);
                            }
                            resultSet.close();
                            String string5 = matcher.group(3);
                            hashMap.put(projectionMetadata.name, string5);
                            resultSet = statement.executeQuery("select get_projection_segments('" + (String)charSequence + "');");
                            resultSet.next();
                            if ("".equals(resultSet.getString(1).trim())) continue;
                            String[] stringArray2 = resultSet.getString(1).split("\n");
                            resultSet.close();
                            String[] stringArray3 = stringArray2[0].split("\\|");
                            stringArray = stringArray2[1].split("\\|");
                            String[] stringArray4 = stringArray2[2].split("\\|");
                            for (n = 0; n < stringArray3.length; ++n) {
                                long l = Long.parseLong(stringArray4[n]);
                                long l2 = Long.parseLong(stringArray[n]);
                                projectionMetadata.addSegment(stringArray3[n], l, l2);
                            }
                        } else {
                            String[] stringArray5;
                            for (String string6 : stringArray5 = matcher.group(6).split(",")) {
                                projectionMetadata.addSegment(string6, 0L, Long.MAX_VALUE);
                            }
                        }
                        this.projections.put(projectionMetadata.name, projectionMetadata);
                    }
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append("select distinct lower(pr.name) as projection_name, pc.name as projection_column_name, tc.column_name, tc.ordinal_position, co.ordinal_position as projection_ordinal_position, co.sort_position, pc.typeoid as data_type_id, pc.typemod from v_internal.vs_projection_columns as pc join v_internal.vs_projection_column_order as co on (co.column_id = pc.oid) join v_internal.vs_projections as pr on (pc.proj = pr.oid and pr.schemaname ilike '");
                    if (!this.schema.equals("")) {
                        ((StringBuilder)charSequence).append(this.schema);
                    } else {
                        ((StringBuilder)charSequence).append("public");
                    }
                    ((StringBuilder)charSequence).append("' ) left join v_catalog.columns as tc on (tc.table_id = co.table_id and tc.ordinal_position =  co.table_position) where pc.name <> 'epoch' and lower(pr.name) in (");
                    if (this.projections.isEmpty()) {
                        throw KVErrors.NoCompatibleProjections.makeException(this.schema + "." + this.table);
                    }
                    n2 = 0;
                    for (String string7 : this.projections.keySet()) {
                        ((StringBuilder)charSequence).append("'");
                        ((StringBuilder)charSequence).append(string7);
                        ((StringBuilder)charSequence).append("'");
                        if (n2 < this.projections.size() - 1) {
                            ((StringBuilder)charSequence).append(",");
                        }
                        ++n2;
                    }
                    ((StringBuilder)charSequence).append(") order by projection_name, projection_ordinal_position");
                    resultSet = statement.executeQuery(((StringBuilder)charSequence).toString());
                    boolean bl = this.projections.containsKey(this.table);
                    Object var13_18 = null;
                    while (resultSet.next()) {
                        String string8;
                        void var15_28;
                        String string9 = resultSet.getString("projection_name");
                        if (!this.projections.containsKey(string9)) continue;
                        ProjectionMetadata projectionMetadata = this.projections.get(string9);
                        String string10 = resultSet.getString("column_name");
                        String string11 = resultSet.getString("projection_column_name").toLowerCase();
                        if (string10 == null) {
                            String string12 = "";
                        }
                        String string13 = var15_28.toLowerCase();
                        int n3 = resultSet.getInt("sort_position") + 1;
                        if (resultSet.wasNull()) {
                            n3 = Integer.MAX_VALUE;
                        }
                        int n4 = Integer.MAX_VALUE;
                        stringArray = (String[])hashMap.get(projectionMetadata.name);
                        if (stringArray != null) {
                            String[] stringArray6 = stringArray.split(", ");
                            for (n = 0; n < stringArray6.length; ++n) {
                                String string14 = stringArray6[n];
                                if (!string14.equalsIgnoreCase(string13)) continue;
                                n4 = n + 1;
                                break;
                            }
                        }
                        String string3 = string8 = bl ? string11 : string13;
                        if (string8 != null && string8 != "" && this.tableColNames.add(string8)) {
                            this.tableColList.add(new OutputColumn(string8, false));
                        }
                        n = resultSet.getInt("data_type_id");
                        int n5 = resultSet.getInt("typemod");
                        try {
                            int n6 = TypeUtils.getSQLTypeFromOID(n, -1);
                            this.columnTypes.put(string8, n6);
                            this.columnTypeMods.put(string8, n5);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            this.columnTypes.put(string8, 1111);
                            this.columnTypeMods.put(string8, -1);
                        }
                        projectionMetadata.addColumn(string8, string11, n4, n3);
                    }
                    for (ProjectionMetadata projectionMetadata : this.projections.values()) {
                        projectionMetadata.markComplete();
                        if (!this.pool.log.isEnabled()) continue;
                        this.pool.log.logDebug("Metadata for projection " + this.schema + "." + projectionMetadata.name + " updated");
                    }
                    this.isFlexTable = this.tableColNames.contains("__raw__");
                    connection.rollback();
                    this.createTime.set(System.currentTimeMillis());
                }
                catch (SQLException sQLException) {
                    this.pool.log.logError("Exception when loading metadata from node " + routableConnection.node, sQLException);
                    if (sQLException instanceof SQLNonTransientException) {
                        throw sQLException;
                    }
                    this.pool.log.logInfo("Retrying metadata query on healthy connection");
                    sQLWarningChainer.add(KVErrors.ConnectionFailedMetadataRetried.makeWarning(routableConnection.node));
                    this.pool.destroyConnection(routableConnection);
                    routableConnection = null;
                    this.loadMetadata(sQLWarningChainer);
                    Object var27_60 = null;
                    if (routableConnection == null) return;
                    this.pool.returnConnection(routableConnection);
                    return;
                }
                Object var27_59 = null;
                if (routableConnection == null) return;
            }
            catch (Throwable throwable) {
                Object var27_61 = null;
                if (routableConnection == null) throw throwable;
                this.pool.returnConnection(routableConnection);
                throw throwable;
            }
            this.pool.returnConnection(routableConnection);
        }

        @Override
        public boolean isFlexTable() throws SQLException {
            return this.isFlexTable;
        }
    }
}

