/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.install4j.api.Util;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.console.ConsoleImpl;
import java.io.File;
import java.util.ResourceBundle;

public class GUIProgressInterface
implements ProgressInterface {
    @Override
    public void setStatusMessage(String message) {
    }

    @Override
    public void setDetailMessage(String message) {
    }

    @Override
    public void setPercentCompleted(int value) {
    }

    @Override
    public int getPercentCompleted() {
        return 0;
    }

    @Override
    public void setSecondaryPercentCompleted(int value) {
    }

    @Override
    public void setIndeterminateProgress(boolean indeterminateProgress) {
    }

    @Override
    public void showFailure(String message) {
        Util.showMessage(message, 0);
    }

    @Override
    public int askOverwrite(File file) throws UserCanceledException {
        String message = file.getPath() + "\n\n" + this.getMessages().getString("FileExists");
        int result = Util.showOptionDialog(message, new String[]{this.getMessages().getString("ButtonYes"), this.getMessages().getString("ButtonYesToAll"), this.getMessages().getString("ButtonNo"), this.getMessages().getString("ButtonNoToAll")}, 3);
        switch (result) {
            case 0: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 4;
            }
        }
        return 1;
    }

    @Override
    public int askRetry(File file) throws UserCanceledException {
        String message = Messages.format(this.getMessages().getString("AskRetryInstallFile"), file.getPath());
        if (ConsoleImpl.isRetryAllowNo()) {
            int result = Util.showOptionDialog(message, new String[]{this.getMessages().getString("ButtonYes"), this.getMessages().getString("ButtonNo"), this.getMessages().getString("ButtonCancel")}, 3);
            switch (result) {
                case 0: {
                    return 2;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 3;
                }
            }
        } else {
            int result = Util.showOptionDialog(message, new String[]{this.getMessages().getString("ButtonYes"), this.getMessages().getString("ButtonCancel")}, 3);
            switch (result) {
                case 0: {
                    return 2;
                }
                case 1: {
                    return 3;
                }
            }
        }
        return 3;
    }

    @Override
    public boolean askContinue(File file) throws UserCanceledException {
        int result = Util.showOptionDialog(Messages.format(this.getMessages().getString("AskContinue"), file.getPath()), new String[]{this.getMessages().getString("ButtonOK"), this.getMessages().getString("ButtonCancel")}, 3);
        return result == 0;
    }

    protected ResourceBundle getMessages() {
        return Messages.getMessages();
    }
}

