/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.column;

import com.jidesoft.thirdparty.prefuse.data.DataReadOnlyException;
import com.jidesoft.thirdparty.prefuse.data.DataTypeException;
import com.jidesoft.thirdparty.prefuse.data.column.AbstractColumn;
import java.util.Arrays;

public class LongColumn
extends AbstractColumn {
    private long[] \u0108;
    private int \u0107;

    public LongColumn() {
        this(0, 10, 0L);
    }

    public LongColumn(int n2) {
        this(n2, n2, 0L);
    }

    public LongColumn(int n2, int n3, long l2) {
        super(Long.TYPE, new Long(l2));
        if (n3 < n2) {
            throw new IllegalArgumentException("Capacity value can not be less than the row count.");
        }
        this.\u0108 = new long[n3];
        Arrays.fill(this.\u0108, l2);
        this.\u0107 = n2;
    }

    @Override
    public int getRowCount() {
        return this.\u0107;
    }

    @Override
    public void setMaximumRow(int n2) {
        if (n2 > this.\u0108.length) {
            int n3 = Math.max(3 * this.\u0108.length / 2 + 1, n2);
            long[] lArray = new long[n3];
            System.arraycopy(this.\u0108, 0, lArray, 0, this.\u0107);
            Arrays.fill(lArray, this.\u0107, n3, (Long)this.m_defaultValue);
            this.\u0108 = lArray;
        }
        this.\u0107 = n2;
    }

    @Override
    public Object get(int n2) {
        return new Long(this.getLong(n2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void set(Object object, int n2) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (object == null) throw new DataTypeException("Column does not accept null values");
        if (object instanceof Number) {
            this.setLong(((Number)object).longValue(), n2);
            return;
        } else {
            if (!(object instanceof String)) throw new DataTypeException(object.getClass());
            this.setString((String)object, n2);
        }
    }

    @Override
    public long getLong(int n2) throws DataTypeException {
        if (n2 < 0 || n2 > this.\u0107) {
            throw new IllegalArgumentException("Row index out of bounds: " + n2);
        }
        return this.\u0108[n2];
    }

    @Override
    public void setLong(long l2, int n2) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (n2 < 0 || n2 >= this.\u0107) {
            throw new IllegalArgumentException("Row index out of bounds: " + n2);
        }
        long l3 = this.\u0108[n2];
        if (l3 == l2) {
            return;
        }
        this.\u0108[n2] = l2;
        this.fireColumnEvent(n2, l3);
    }

    @Override
    public int getInt(int n2) throws DataTypeException {
        return (int)this.getLong(n2);
    }

    @Override
    public float getFloat(int n2) throws DataTypeException {
        return this.getLong(n2);
    }

    @Override
    public double getDouble(int n2) throws DataTypeException {
        return this.getLong(n2);
    }
}

