/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.axis;

import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.annotation.AutoPositionedLabel;
import com.jidesoft.chart.axis.AxisPlacement;
import com.jidesoft.chart.axis.AxisQuantity;
import com.jidesoft.chart.axis.DefaultNumericTickCalculator;
import com.jidesoft.chart.axis.Tick;
import com.jidesoft.chart.axis.TickCalculator;
import com.jidesoft.chart.model.IdentityTransform;
import com.jidesoft.chart.model.InvertibleTransform;
import com.jidesoft.chart.render.AxisRenderer;
import com.jidesoft.chart.render.DefaultAxisRenderer;
import com.jidesoft.chart.xml.XmlColorAdapter;
import com.jidesoft.chart.xml.XmlFontAdapter;
import com.jidesoft.range.AbstractRange;
import com.jidesoft.range.CategoryRange;
import com.jidesoft.range.NumericRange;
import com.jidesoft.range.Range;
import com.jidesoft.range.TimeRange;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

public class Axis
implements PropertyChangeListener {
    private static final AxisPlacement \u0113 = AxisPlacement.LEADING;
    public static final double MIN_RESOLUTION = 1.0E-10;
    public static final String PROPERTY_TICKS = "ticks";
    public static final String PROPERTY_TICK_FONT = "tickFont";
    public static final String PROPERTY_TICK_LENGTH = "tickLength";
    public static final String PROPERTY_MINOR_TICK_LENGTH = "minorTickLength";
    public static final String PROPERTY_RANGE = "range";
    public static final String PROPERTY_UPDATE_OTHER_AXES = "updateOtherAxes";
    public static final String PROPERTY_LABEL = "label";
    public static final String PROPERTY_TICK_LABEL_COLOR = "tickLabelColor";
    public static final String PROPERTY_TICK_CALCULATOR = "tickCalculator";
    public static final String PROPERTY_AXIS_COLOR = "axisColor";
    public static final String PROPERTY_TICK_COLOR = "tickColor";
    public static final String PROPERTY_MINOR_TICK_COLOR = "minorTickColor";
    public static final String PROPERTY_STROKE = "axisStroke";
    private Range<?> \u0104 = new NumericRange(0.0, 1.0);
    private Range<?> \u010e = this.\u0104;
    private TickCalculator \u0101 = new DefaultNumericTickCalculator();
    private AutoPositionedLabel \u0118 = null;
    private PropertyChangeSupport \u0114 = new PropertyChangeSupport(this);
    private AxisPlacement \u0117;
    private boolean \u011a = true;
    private Font \u011b = null;
    private AxisRenderer \u0111 = new DefaultAxisRenderer();
    private Tick[] \u0116;
    private boolean \u010d = true;
    private boolean \u0115 = true;
    private Integer \u0103 = null;
    private int \u0112 = 4;
    private int \u011c = 2;
    private double \u010b = 0.0;
    private int \u0102 = 2;
    private Color \u0110 = Color.darkGray;
    private Color \u010c = null;
    private Color \u0107 = null;
    private Color \u010a = null;
    private Stroke \u0119;
    private Range<Double> \u0109 = null;
    private boolean \u0105 = false;
    private double \u0108;
    private InvertibleTransform<Double> \u0106 = new IdentityTransform<Double>();

    public Axis() {
        this.setPlacement(\u0113);
    }

    public Axis(String string) {
        this(new AutoPositionedLabel(string));
    }

    public Axis(AutoPositionedLabel autoPositionedLabel) {
        this();
        this.setLabel(autoPositionedLabel);
    }

    public Axis(double d2, double d3) {
        this(new NumericRange(d2, d3));
    }

    public Axis(Range<?> range) {
        if (range == null) {
            throw new IllegalArgumentException("Cannot set a range of null!");
        }
        this.setRange(range);
        this.setPlacement(\u0113);
    }

    public Axis(Range<?> range, String string) {
        if (range == null) {
            throw new IllegalArgumentException("Cannot set a range of null!");
        }
        this.setRange(range);
        this.setLabel(new AutoPositionedLabel(string));
        this.setPlacement(\u0113);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.\u0114.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.\u0114.removePropertyChangeListener(propertyChangeListener);
    }

    @XmlTransient
    public TickCalculator getTickCalculator() {
        return this.\u0101;
    }

    public void setTickCalculator(TickCalculator tickCalculator) {
        TickCalculator tickCalculator2 = this.\u0101;
        if (tickCalculator2 != null) {
            tickCalculator2.removePropertyChangeListener(this);
        }
        this.\u0101 = tickCalculator;
        if (tickCalculator != null) {
            tickCalculator.addPropertyChangeListener(this);
        }
        this.\u0116 = null;
        this.\u0114.firePropertyChange(PROPERTY_TICK_CALCULATOR, tickCalculator2, tickCalculator);
    }

    @XmlTransient
    public AxisRenderer getAxisRenderer() {
        return this.\u0111;
    }

    public double getTickLabelRotation() {
        return this.\u010b;
    }

    public void setTickLabelRotation(double d2) {
        this.\u010b = d2;
    }

    public int getTickLabelOffset() {
        return this.\u0102;
    }

    public void setTickLabelOffset(int n2) {
        this.\u0102 = n2;
    }

    public int getTickLength() {
        return this.\u0112;
    }

    public void setTickLength(int n2) {
        int n3 = this.\u0112;
        this.\u0112 = n2;
        this.\u0114.firePropertyChange(PROPERTY_TICK_LENGTH, n3, n2);
    }

    public int getMinorTickLength() {
        return this.\u011c;
    }

    public void setMinorTickLength(int n2) {
        int n3 = this.\u011c;
        this.\u011c = n2;
        this.\u0114.firePropertyChange(PROPERTY_MINOR_TICK_LENGTH, n3, n2);
    }

    @XmlJavaTypeAdapter(value=XmlColorAdapter.class)
    public Color getTickColor() {
        return this.\u010c;
    }

    public void setTickColor(Color color) {
        Color color2 = this.\u010c;
        this.\u010c = color;
        this.\u0114.firePropertyChange(PROPERTY_TICK_COLOR, color2, color);
    }

    @XmlJavaTypeAdapter(value=XmlColorAdapter.class)
    public Color getMinorTickColor() {
        return this.\u0107;
    }

    public void setMinorTickColor(Color color) {
        Color color2 = this.\u0107;
        this.\u0107 = color;
        this.\u0114.firePropertyChange(PROPERTY_MINOR_TICK_COLOR, color2, color);
    }

    @XmlJavaTypeAdapter(value=XmlColorAdapter.class)
    public Color getTickLabelColor() {
        return this.\u010a;
    }

    public void setTickLabelColor(Color color) {
        Color color2 = this.\u010a;
        this.\u010a = color;
        this.\u0114.firePropertyChange(PROPERTY_TICK_LABEL_COLOR, color2, color);
    }

    @XmlJavaTypeAdapter(value=XmlFontAdapter.class)
    public Font getTickFont() {
        return this.\u011b;
    }

    public void setTickFont(Font font) {
        Font font2 = this.\u011b;
        this.\u011b = font;
        this.\u0114.firePropertyChange(PROPERTY_TICK_FONT, font2, font);
    }

    public boolean isVisible() {
        return this.\u010d;
    }

    public void setVisible(boolean bl) {
        this.\u010d = bl;
    }

    public boolean isLabelVisible() {
        return this.\u0115;
    }

    public void setLabelVisible(boolean bl) {
        this.\u0115 = bl;
    }

    public Integer getLabelWidth() {
        return this.\u0103;
    }

    public void setLabelWidth(Integer n2) {
        this.\u0103 = n2;
    }

    public int labelWidth(Graphics graphics, Font font, Orientation orientation, Tick[] tickArray) {
        Font font2;
        int n2;
        int n3 = n2 = this.isVisible() && this.isTicksVisible() ? this.getTickLabelOffset() : 0;
        if (this.\u0103 != null) {
            return this.\u0103;
        }
        if (graphics == null) {
            throw new IllegalArgumentException("Graphics instance cannot be null");
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(font == null ? graphics.getFont() : font);
        Font font3 = font2 = this.\u0118 == null ? graphics.getFont() : this.\u0118.getFont();
        if (font2 == null) {
            font2 = graphics.getFont();
        }
        if (orientation == Orientation.vertical) {
            int n4 = 0;
            for (Tick tick : tickArray) {
                int n5;
                assert (tick != null) : "Ticks cannot be null!";
                String string = tick.getLabel();
                int n6 = n5 = string == null ? 0 : fontMetrics.stringWidth(string);
                if (n5 <= n4) continue;
                n4 = n5;
            }
            int n7 = this.getLabel() == null ? 0 : this.getLabel().size((Graphics)graphics, (Font)font2).height;
            double d2 = this.getTickLabelRotation();
            int n8 = n2 + fontMetrics.getDescent() + (int)Math.ceil(Math.abs((double)(n4 + 1) * Math.cos(d2)) + Math.abs((double)fontMetrics.getHeight() * Math.sin(d2))) + n7;
            if (n8 < 2 * fontMetrics.getHeight()) {
                return 2 * fontMetrics.getHeight();
            }
            return n8;
        }
        if (orientation == Orientation.horizontal) {
            int n9 = this.getLabel() == null ? 0 : this.getLabel().size((Graphics)graphics, (Font)font2).height;
            double d3 = this.getTickLabelRotation();
            if (d3 == 0.0) {
                int n10 = fontMetrics.getHeight();
                return n2 + fontMetrics.getDescent() + n10 + n9;
            }
            int n11 = 0;
            for (Tick tick : tickArray) {
                int n12;
                String string = tick.getLabel();
                int n13 = n12 = string == null ? 0 : fontMetrics.stringWidth(string);
                if (n12 <= n11) continue;
                n11 = n12;
            }
            return n2 + fontMetrics.getDescent() + (int)Math.ceil(Math.abs((double)(n11 + 1) * Math.sin(d3)) + Math.abs((double)fontMetrics.getHeight() * Math.cos(d3))) + n9;
        }
        throw new IllegalArgumentException("Unexpected value: " + (Object)((Object)orientation));
    }

    public int labelWidth(Graphics graphics, Font font, Orientation orientation) {
        if (!this.\u010d) {
            return 0;
        }
        return this.labelWidth(graphics, font, orientation, this.getTicks());
    }

    public void setAxisRenderer(AxisRenderer axisRenderer) {
        AxisRenderer axisRenderer2 = this.\u0111;
        this.\u0111 = axisRenderer;
        this.\u0114.firePropertyChange("axisRenderer", axisRenderer2, axisRenderer);
    }

    public void setRange(double d2, double d3) {
        if (d2 <= d3) {
            this.setRange(new NumericRange(d2, d3));
        } else {
            this.setRange(new NumericRange(d3, d2));
        }
    }

    public void setRange(Range<?> range) {
        this.setRange(range, true);
    }

    public void setRange(Range<?> range, boolean bl) {
        this.setRange(range, bl, true);
    }

    public void setRange(Range<?> numericRange, boolean bl, boolean bl2) {
        double d2;
        double d3;
        if (numericRange == null) {
            throw new IllegalArgumentException("Cannot set a range of null!");
        }
        if (((Object)numericRange).equals(this.\u0104)) {
            return;
        }
        if (this.\u0104 != null) {
            this.\u0104.removePropertyChangeListener(this);
        }
        if (this.\u0106 == null) {
            d3 = numericRange.minimum();
            d2 = numericRange.maximum();
        } else {
            d3 = this.\u0106.inverseTransform(numericRange.minimum());
            d2 = this.\u0106.inverseTransform(numericRange.maximum());
            this.\u010e = new NumericRange(Math.min(d3, d2), Math.max(d3, d2));
        }
        if (this.\u0109 != null) {
            double d4 = d3 < this.\u0109.minimum() ? this.\u0109.minimum() : d3;
            double d5 = d2 > this.\u0109.maximum() ? this.\u0109.maximum() : d2;
            numericRange = new NumericRange(d4, d5);
        }
        Range<?> range = this.\u0104;
        this.\u0104 = numericRange;
        this.\u0116 = null;
        this.\u0104.addPropertyChangeListener(this);
        if (bl2) {
            this.\u0114.firePropertyChange(PROPERTY_RANGE, range, numericRange);
        }
        if (bl) {
            this.\u0114.firePropertyChange(PROPERTY_UPDATE_OTHER_AXES, range, numericRange);
        }
    }

    @XmlTransient
    public Range<Double> getDomain() {
        return this.\u0109;
    }

    public void setDomain(Range<Double> range) {
        this.\u0109 = range;
    }

    public AxisQuantity getQuantity() {
        return AxisQuantity.NUMBER;
    }

    @XmlTransient
    public Range<?> getRange() {
        return this.\u0104;
    }

    public Range<?> getOutputRange() {
        if (this.\u0106 == null || this.\u0106 instanceof IdentityTransform) {
            return this.\u0104;
        }
        double d2 = this.\u0106.transform(this.minimum());
        double d3 = this.\u0106.transform(this.maximum());
        double d4 = Math.min(d2, d3);
        double d5 = Math.max(d2, d3);
        if (this.getQuantity() == AxisQuantity.TIME) {
            return new TimeRange((long)d4, (long)d5);
        }
        if (this.getQuantity() == AxisQuantity.CATEGORY) {
            return new CategoryRange<Object>(d4, d5);
        }
        return new NumericRange(d4, d5);
    }

    @XmlTransient
    public InvertibleTransform<Double> getAxisTransform() {
        return this.\u0106;
    }

    public void setAxisTransform(InvertibleTransform<Double> invertibleTransform) {
        this.\u0106 = invertibleTransform;
    }

    @XmlTransient
    public AutoPositionedLabel getLabel() {
        return this.\u0118;
    }

    public void setLabel(String string) {
        if (string == null) {
            this.setLabel((AutoPositionedLabel)null);
        } else {
            AutoPositionedLabel autoPositionedLabel = new AutoPositionedLabel(string);
            this.setLabel(autoPositionedLabel);
        }
    }

    public void setLabel(AutoPositionedLabel autoPositionedLabel) {
        AutoPositionedLabel autoPositionedLabel2 = this.\u0118;
        this.\u0118 = autoPositionedLabel;
        this.\u0114.firePropertyChange(PROPERTY_LABEL, autoPositionedLabel2, autoPositionedLabel);
    }

    public double maximum() {
        return this.\u0104.maximum();
    }

    public double minimum() {
        return this.\u0104.minimum();
    }

    public double midPoint() {
        return (this.\u0104.maximum() + this.\u0104.minimum()) / 2.0;
    }

    public AxisPlacement getPlacement() {
        return this.\u0117;
    }

    public void setPlacement(AxisPlacement axisPlacement) {
        this.\u0117 = axisPlacement;
    }

    public double getFloatingPosition() {
        return this.\u0108;
    }

    public void setFloatingPosition(double d2) {
        this.\u0108 = d2;
    }

    @XmlJavaTypeAdapter(value=XmlColorAdapter.class)
    public Color getAxisColor() {
        return this.\u0110;
    }

    public void setAxisColor(Color color) {
        Color color2 = this.\u0110;
        this.\u0110 = color;
        this.\u0114.firePropertyChange(PROPERTY_AXIS_COLOR, color2, color);
    }

    @XmlTransient
    public Stroke getStroke() {
        return this.\u0119;
    }

    public void setStroke(Stroke stroke) {
        Stroke stroke2 = this.\u0119;
        this.\u0119 = stroke;
        this.\u0114.firePropertyChange(PROPERTY_STROKE, stroke2, this.\u0119);
    }

    @XmlTransient
    public Tick[] getTicks() {
        if (this.\u0116 == null) {
            this.updateTicks();
        }
        return this.\u0116;
    }

    protected void updateTicks() {
        Tick[] tickArray = this.\u0116;
        this.\u0116 = this.\u0101.calculateTicks(this.getRange());
        this.\u0114.firePropertyChange(PROPERTY_TICKS, tickArray, this.\u0116);
    }

    public boolean isTicksVisible() {
        return this.\u011a;
    }

    public void setTicksVisible(boolean bl) {
        this.\u011a = bl;
    }

    public boolean isFlipped() {
        return this.\u0105;
    }

    public void setFlipped(boolean bl) {
        this.\u0105 = bl;
    }

    public static Range<?> zoom(Axis axis, double d2) {
        AbstractRange abstractRange;
        TimeRange timeRange = axis.getOutputRange();
        double d3 = (timeRange.minimum() + timeRange.maximum()) / 2.0;
        double d4 = timeRange.maximum() - timeRange.minimum();
        double d5 = d4 * d2;
        if (axis.getQuantity() == AxisQuantity.TIME) {
            long l2 = (long)(d3 - d5 / 2.0);
            long l3 = (long)(d3 + d5 / 2.0);
            if (Axis.\u0101(l2, l3) && d2 > 1.0) {
                --l2;
                ++l3;
            }
            abstractRange = new TimeRange(l2, l3);
        } else if (axis.getQuantity() == AxisQuantity.CATEGORY) {
            abstractRange = timeRange;
            double d6 = d5 / 2.0;
            double d7 = d3 - d6;
            double d8 = d3 + d6;
            if (Axis.\u0101(d7, d8) && d2 > 1.0) {
                d7 -= 1.0E-10;
                d8 += 1.0E-10;
            }
            ((CategoryRange)abstractRange).setMinimum(d7);
            ((CategoryRange)abstractRange).setMaximum(d8);
        } else {
            InvertibleTransform<Double> invertibleTransform = axis.getAxisTransform();
            double d9 = d3 - d5 / 2.0;
            double d10 = d3 + d5 / 2.0;
            if (Axis.\u0101(d9, d10) && d2 > 1.0) {
                d9 -= 1.0E-10;
                d10 += 1.0E-10;
            }
            abstractRange = invertibleTransform == null || invertibleTransform instanceof IdentityTransform ? new NumericRange(d9, d10) : new NumericRange(invertibleTransform.inverseTransform(d9), invertibleTransform.inverseTransform(d10));
        }
        return abstractRange;
    }

    private static boolean \u0101(double d2, double d3) {
        return Math.abs(d3 - d2) < 1.0E-10;
    }

    public static Range<?> zoomFromPosition(Axis axis, double d2, double d3) {
        AbstractRange abstractRange;
        TimeRange timeRange = axis.getOutputRange();
        double d4 = axis.minimum();
        double d5 = axis.maximum();
        if (axis.getQuantity() == AxisQuantity.TIME) {
            long l2 = (long)(d3 - d2 * (d3 - d4));
            long l3 = (long)(d3 + d2 * (d5 - d3));
            if (Axis.\u0101(l2, l3) && d2 > 1.0) {
                --l2;
                ++l3;
            }
            abstractRange = new TimeRange(l2, l3);
        } else if (axis.getQuantity() == AxisQuantity.CATEGORY) {
            abstractRange = timeRange;
            double d6 = d3 - d2 * (d3 - d4);
            double d7 = d3 + d2 * (d5 - d3);
            if (Axis.\u0101(d6, d7) && d2 > 1.0) {
                d6 -= 1.0E-10;
                d7 += 1.0E-10;
            }
            ((CategoryRange)abstractRange).setMinimum(d6);
            ((CategoryRange)abstractRange).setMaximum(d7);
        } else {
            InvertibleTransform<Double> invertibleTransform;
            double d8 = d3 - d2 * (d3 - d4);
            double d9 = d3 + d2 * (d5 - d3);
            if (Axis.\u0101(d8, d9) && d2 > 1.0) {
                d8 -= 1.0E-10;
                d9 += 1.0E-10;
            }
            abstractRange = (invertibleTransform = axis.getAxisTransform()) == null || invertibleTransform instanceof IdentityTransform ? new NumericRange(d8, d9) : new NumericRange(invertibleTransform.inverseTransform(d8), invertibleTransform.inverseTransform(d9));
        }
        return abstractRange;
    }

    public void render(Graphics graphics, int n2, int n3, int n4, Orientation orientation) {
        AxisRenderer axisRenderer;
        if (n4 <= 0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color = graphics2D.getColor();
        graphics2D.setColor(this.\u0110);
        Stroke stroke = graphics2D.getStroke();
        if (this.\u0119 != null) {
            graphics2D.setStroke(this.\u0119);
        }
        if ((axisRenderer = this.getAxisRenderer()) != null) {
            axisRenderer.renderAxis(graphics2D, n2, n3, n4, orientation);
        }
        graphics2D.setColor(color);
        graphics2D.setStroke(stroke);
    }

    public String toString() {
        return String.format("#<Axis label='%s' range=%s>", this.getLabel(), this.getRange());
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.\u0116 = null;
        this.\u0114.firePropertyChange(propertyChangeEvent);
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

