/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.Drawable;
import com.jidesoft.chart.Frontable;
import com.jidesoft.chart.LabelPlacement;
import com.jidesoft.chart.Orientation;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JViewport;

public class LineMarker
implements Drawable,
Frontable {
    public static final String PROPERTY_VISIBLE = "Visible";
    public static final String PROPERTY_CHART = "Chart";
    public static final String PROPERTY_COLOR = "Color";
    public static final String PROPERTY_ORIENTATION = "Orientation";
    public static final String PROPERTY_POSITION = "Position";
    public static final String PROPERTY_STROKE = "Stroke";
    public static final String PROPERTY_LABEL = "Label";
    public static final String PROPERTY_LABEL_PLACEMENT = "Label Placement";
    public static final String PROPERTY_LABEL_COLOR = "Label Color";
    public static final String PROPERTY_LABEL_FONT = "Label Font";
    public static final String PROPERTY_AT_FRONT = "At Front";
    protected final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private Stroke \u0188 = new BasicStroke(1.0f);
    private Chart \u018b;
    private Color \u018c = new Color(255, 0, 0, 128);
    private double \u018e;
    private Orientation \u0184 = Orientation.vertical;
    private boolean \u0183 = true;
    private boolean \u018a = false;
    private String \u0189;
    private LabelPlacement \u0182;
    private Color \u018d;
    private Font \u0187;
    private static final int \u0186 = 4;
    private RenderingHints \u0185 = null;

    public LineMarker() {
    }

    public LineMarker(Chart chart) {
        this.\u018b = chart;
    }

    public LineMarker(Chart chart, Orientation orientation, double d2, Color color) {
        this.\u018b = chart;
        this.setOrientation(orientation);
        this.setPosition(d2);
        this.setColor(color);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public String getLabel() {
        return this.\u0189;
    }

    public void setLabel(String string) {
        String string2 = this.\u0189;
        this.\u0189 = string;
        this.support.firePropertyChange(PROPERTY_LABEL, string2, string);
    }

    public LabelPlacement getLabelPlacement() {
        return this.\u0182;
    }

    public void setLabelPlacement(LabelPlacement labelPlacement) {
        LabelPlacement labelPlacement2 = this.\u0182;
        this.\u0182 = labelPlacement;
        this.support.firePropertyChange(PROPERTY_LABEL_PLACEMENT, (Object)labelPlacement2, (Object)labelPlacement);
    }

    public Color getLabelColor() {
        return this.\u018d;
    }

    public void setLabelColor(Color color) {
        Color color2 = this.\u018d;
        this.\u018d = color;
        this.support.firePropertyChange(PROPERTY_LABEL_COLOR, color2, color);
    }

    public Font getLabelFont() {
        return this.\u0187;
    }

    public void setLabelFont(Font font) {
        Font font2 = this.\u0187;
        this.\u0187 = font;
        this.support.firePropertyChange(PROPERTY_LABEL_FONT, font2, font);
    }

    public Chart getChart() {
        return this.\u018b;
    }

    public void setChart(Chart chart) {
        Chart chart2 = this.\u018b;
        this.\u018b = chart;
        if (chart != null) {
            chart.repaint();
        }
        this.support.firePropertyChange(PROPERTY_CHART, chart2, chart);
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        if (this.\u0185 == null) {
            this.\u0185 = new RenderingHints(key, object);
        } else {
            this.\u0185.put(key, object);
        }
    }

    public boolean isVisible() {
        return this.\u0183;
    }

    public void setVisible(boolean bl) {
        boolean bl2 = this.\u0183;
        this.\u0183 = bl;
        if (this.\u018b != null) {
            this.\u018b.repaint();
        }
        this.support.firePropertyChange(PROPERTY_VISIBLE, bl2, bl);
    }

    public Color getColor() {
        return this.\u018c;
    }

    public void setColor(Color color) {
        Color color2 = this.\u018c;
        this.\u018c = color;
        if (this.\u018b != null) {
            this.\u018b.repaint();
        }
        this.support.firePropertyChange(PROPERTY_COLOR, color2, color);
    }

    public Stroke getStroke() {
        return this.\u0188;
    }

    public void setStroke(Stroke stroke) {
        Stroke stroke2 = this.\u0188;
        this.\u0188 = stroke;
        if (this.\u018b != null) {
            this.\u018b.repaint();
        }
        this.support.firePropertyChange(PROPERTY_STROKE, stroke2, stroke);
    }

    public Orientation getOrientation() {
        return this.\u0184;
    }

    public void setOrientation(Orientation orientation) {
        Orientation orientation2 = this.\u0184;
        this.\u0184 = orientation;
        if (this.\u018b != null) {
            this.\u018b.repaint();
        }
        this.support.firePropertyChange(PROPERTY_ORIENTATION, (Object)orientation2, (Object)orientation);
    }

    public double getPosition() {
        return this.\u018e;
    }

    public void setPosition(double d2) {
        double d3 = this.\u018e;
        this.\u018e = d2;
        if (this.\u018b != null) {
            this.\u018b.repaint();
        }
        this.support.firePropertyChange(PROPERTY_POSITION, d3, d2);
    }

    @Override
    public void draw(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        if (this.\u0183) {
            Object object;
            Object object2;
            if (this.\u0185 != null) {
                object2 = this.\u0185.entrySet().iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    RenderingHints.Key key = (RenderingHints.Key)object.getKey();
                    graphics2D.setRenderingHint(key, object.getValue());
                }
            }
            graphics2D.setStroke(this.\u0188);
            if (this.\u0184 == Orientation.vertical) {
                object2 = this.\u018b.calculatePixelPoint(new Point2D.Double(this.\u018e, 0.0));
                if (object2 != null) {
                    ((Point)object2).y = this.\u018b.getYStart();
                    object = new Point(((Point)object2).x, this.\u018b.getYEnd());
                    graphics2D.setColor(this.\u018c);
                    graphics2D.drawLine(((Point)object2).x, ((Point)object2).y, ((Point)object).x, ((Point)object).y);
                    if (this.\u0189 != null) {
                        this.\u0102(graphics2D, this.\u0189, ((Point)object2).x, ((Point)object2).y, ((Point)object).x, ((Point)object).y);
                    }
                }
            } else if (this.\u0184 == Orientation.horizontal && (object2 = this.\u018b.calculatePixelPoint(new Point2D.Double(0.0, this.\u018e))) != null) {
                ((Point)object2).x = this.\u018b.getXStart();
                object = new Point(this.\u018b.getXEnd(), ((Point)object2).y);
                graphics2D.setColor(this.\u018c);
                graphics2D.drawLine(((Point)object2).x, ((Point)object2).y, ((Point)object).x, ((Point)object).y);
                if (this.\u0189 != null) {
                    this.\u0102(graphics2D, this.\u0189, ((Point)object2).x, ((Point)object2).y, ((Point)object).x, ((Point)object).y);
                }
            }
        }
        graphics2D.dispose();
    }

    private void \u0102(Graphics2D graphics2D, String string, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        if (this.\u0187 != null) {
            graphics2D.setFont(this.\u0187);
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n8 = fontMetrics.stringWidth(string);
        int n9 = fontMetrics.getHeight();
        int n10 = Math.min(n2, n4);
        int n11 = Math.max(n2, n4);
        int n12 = Math.max(n3, n5);
        int n13 = Math.min(n3, n5);
        Rectangle rectangle = null;
        Container container = this.\u018b.getParent();
        if (container != null && container instanceof JViewport) {
            JViewport jViewport = (JViewport)container;
            rectangle = jViewport.getViewRect();
        }
        if (this.\u0184 == Orientation.vertical) {
            n7 = n10;
            if (this.\u0182 == LabelPlacement.WEST || this.\u0182 == LabelPlacement.NORTH_WEST || this.\u0182 == LabelPlacement.SOUTH_WEST) {
                n7 -= n8 + 4;
                if (rectangle != null) {
                    n7 += rectangle.x;
                }
            } else if (this.\u0182 == LabelPlacement.EAST || this.\u0182 == LabelPlacement.NORTH_EAST || this.\u0182 == LabelPlacement.SOUTH_EAST) {
                n7 += 4;
                if (rectangle != null) {
                    n7 = n7 - this.\u018b.getChartWidth() + rectangle.x + rectangle.width;
                }
            } else {
                n7 -= n8 / 2;
                if (rectangle != null) {
                    n7 += rectangle.x;
                }
            }
            if (this.\u0182 == LabelPlacement.NORTH || this.\u0182 == LabelPlacement.NORTH_WEST || this.\u0182 == LabelPlacement.NORTH_EAST) {
                n6 = n13 + n9;
                if (rectangle != null) {
                    n6 += rectangle.y;
                }
            } else if (this.\u0182 == LabelPlacement.SOUTH || this.\u0182 == LabelPlacement.SOUTH_EAST || this.\u0182 == LabelPlacement.SOUTH_WEST) {
                n6 = n12 - 4;
                if (rectangle != null) {
                    n6 = n6 + this.\u018b.getChartHeight() + rectangle.y + rectangle.height;
                }
            } else {
                n6 = (n12 + n13) / 2 + n9 / 2;
                if (rectangle != null) {
                    n6 += rectangle.y;
                }
            }
        } else {
            if (this.\u0182 == LabelPlacement.WEST || this.\u0182 == LabelPlacement.NORTH_WEST || this.\u0182 == LabelPlacement.SOUTH_WEST) {
                n7 = n10 + 4;
                if (rectangle != null) {
                    n7 += rectangle.x;
                }
            } else if (this.\u0182 == LabelPlacement.EAST || this.\u0182 == LabelPlacement.NORTH_EAST || this.\u0182 == LabelPlacement.SOUTH_EAST) {
                n7 = n11 - n8 - 4;
                if (rectangle != null) {
                    n7 = n7 - this.\u018b.getChartWidth() + rectangle.x + rectangle.width;
                }
            } else {
                n7 = (n10 + n11) / 2 - n8 / 2;
                if (rectangle != null) {
                    n7 += rectangle.x;
                }
            }
            if (this.\u0182 == LabelPlacement.NORTH || this.\u0182 == LabelPlacement.NORTH_WEST || this.\u0182 == LabelPlacement.NORTH_EAST) {
                n6 = n12 - 4;
                if (rectangle != null) {
                    n6 += rectangle.y;
                }
            } else if (this.\u0182 == LabelPlacement.SOUTH || this.\u0182 == LabelPlacement.SOUTH_EAST || this.\u0182 == LabelPlacement.SOUTH_WEST) {
                n6 = n12 + n9;
                if (rectangle != null) {
                    n6 = n6 + this.\u018b.getChartHeight() + rectangle.y + rectangle.height;
                }
            } else {
                n6 = n12 + fontMetrics.getAscent() / 2 - 1;
                if (rectangle != null) {
                    n6 += rectangle.y;
                }
            }
        }
        if (this.\u018d != null) {
            graphics2D.setColor(this.\u018d);
        }
        graphics2D.drawString(string, n7, n6);
    }

    @Override
    public boolean isAtFront() {
        return this.\u018a;
    }

    @Override
    public void setAtFront(boolean bl) {
        boolean bl2 = this.\u018a;
        this.\u018a = bl;
        this.support.firePropertyChange(PROPERTY_AT_FRONT, bl2, bl);
    }
}

