/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine;

import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.dataengine.PGReplacer;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.EscapeTypes;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PGEscaper {
    private static final int RETYPE_NAME = 1;
    private static final int RETYPE_VALUE = 2;
    private static final int RETYPE_LIMIT = 3;
    private static final int RETYPE_OFFSET = 4;
    private static final int RETYPE_FNAME = 5;
    private static final int RETYPE_ARGIND = 6;
    private static final int RETYPE_LAST = 6;
    private static final int LIKEESCAPE_PATTERN = 2;
    private static final String WS = " \\s* ";
    private static final String QWORD = "\\[ [^\\]]* \\] ";
    private static final String QNUM = "\\? | \\d+";
    private static final String CCB = "[}]";
    private static final String ARGIND = "[(] |[}]";
    private static final String CONVERT = "convert";
    private static final String LIKE = "like";
    private static final String ESCAPE = "escape";
    private static final int flags = 14;
    private static final Pattern s_re_scan = Pattern.compile("(?:           \" [^\"]* \" | (?<! \\b E ) \" [^\"]*   (?<!\\\\{1})\" |      \\b E   ' (?: \\\\.  |  [^'] )* ' | (?<! \\b E ) ' [^']*   (?<!\\\\{1})' |(?<!\\\\{1})'[^']*(?<!\\\\{1})'?|  \\[ [^\\]]* \\] | -- [^\\n]*   $| /[*]  (?: [^/] | (?<= [^*]) / )*  \\*/| (?! \\b ( CONVERT \\( | LIKE \\b) ) [^$,{?}()] | [^$,{?}()] ){0,1000}", 14);
    private static final Pattern s_re_type = Pattern.compile(" \\s* (  (?:    (?: d | escape | guid | interval | ts | t ) \\s*     ( (?: - \\s* )?      ' [^']* '      [-().,:/\\s\\w]*    )  ) \\s* [}]| (?:limit \\s* (\\? | \\d+) (?:  \\s*  offset  \\s*  (\\? | \\d+) )? ) \\s* [}]| oj | (?: call | fn | [?] \\s* = \\s* call ) \\s*   ( [\\w.]+   | \" [^\"]* \"    | \\[ [^\\]]* \\]  (?:  \\s* [.] \\s* \\[ [^\\]]* \\]  )*  ) \\s*   ( [(] |[}] )) \\s* ", 14);
    private static final Pattern s_re_likeEscape = Pattern.compile("(LIKE(\\s)*((?:'[^']*')+|\\?|(?:(\\s)+\"[^\"]*\")+))((?:(\\s)+ESCAPE(\\s)+((?:'[^']*')+|\\?|(?:(\\s)+\"[^\"]*\")+))|(\\s)*\\{(\\s)*ESCAPE(\\s)+((?:'[^']*')+|\\?|(?:(\\s)+\"[^\"]*\")+)(\\s)*\\})", 14);
    private static final Pattern s_re_unloadType = Pattern.compile(" \\s* (  (?:    (?: d | escape | guid | interval | ts | t ) \\s*     ( (?: - \\s* )?      (\\\\)*' [^']* (\\\\)*'      [-().,:/\\s\\w]*    )  ) \\s* [}]| (?:limit \\s* (\\? | \\d+) (?:  \\s*  offset  \\s*  (\\? | \\d+) )? ) \\s* [}]| oj | (?: call | fn | [?] \\s* = \\s* call ) \\s*   ( [\\w.]+ |\"[^\"]*\"  | \\[ [^\\]]* \\]  (?:  \\s* [.] \\s* \\[ [^\\]]* \\]  )*  ) \\s*   ( [(] |[}] )) \\s* ", 14);
    private static final Pattern s_re_unloadQuery = Pattern.compile("(?:(?<!--|/\\*|#|\\w)(unload)(.*)(\\s)*\\(')(.*)(?:'\\))");
    private static final Pattern s_re_unloadScan = Pattern.compile("(?:\"[^\"]*\"|\\bE'(?:\\\\.|[^'])*'|(?<!\\bE)\\\\'[^']*\\\\'|\\[ [^\\]]* \\] |--[^\\n]*$|/[*](?:[^/]|(?<= [^*])/)*\\*/|(?!\\b(CONVERT\\(|LIKE\\b))[^$,{?}()]|[^$,{?}()])*", 14);
    private static final Pattern s_re_escapeQuote = Pattern.compile("(?<!\\\\)(\\\\{1}')|(?<!\\\\)(\\\\{1}\")", 14);
    private static final Pattern s_re_parameters = Pattern.compile("(?<!')\\?|\\\\{1}'\\?", 14);
    private static final Pattern s_re_queryAsParameter = Pattern.compile("(?:(([^{])(\\s)*([^f][^n])(\\s)*(\\w*\\(')))(.*'\\))", 14);
    public static final Pattern s_re_comment = Pattern.compile("(?:-- [^\\n]*   $| /[*]  (?: [^/] | (?<= [^*]) / )*  \\*/)", 14);
    private static final Pattern s_re_commentDash = Pattern.compile("(?:-- [^\\n]*   $)", 14);
    private static final Pattern s_re_commentStar = Pattern.compile("(?: /[*] ((?<= [^*]) / )*  \\*/)", 14);
    private static final Pattern s_re_commentStar2 = Pattern.compile("(?: /[*]  (?: [^/] )*  \\\\*/)", 14);
    private static final Pattern s_re_stringDoubleBracket = Pattern.compile("(?: \" [^\"]* \" | \\\\[ [^\\\\]]* \\\\] )", 14);
    private static final Pattern s_re_stringCstyle = Pattern.compile("(?: \\b E   ' (?: \\\\.  |  [^'] )* '   )", 14);
    private static final Pattern s_re_stringSingle = Pattern.compile("(?:  (?<! \\b E ) ' [^']* (?<!\\\\{1})' )", 14);
    private static final Pattern s_re_unloadStringDouble = Pattern.compile("(?: \" [^\"]* \" | (?<! \\b E ) \" [^\"]*  (?<!\\\\{1})\" | \\\\[ [^\\\\]]* \\\\] )", 14);
    private static final Pattern s_re_unloadStringcstyle = Pattern.compile("(?:  \\b E   ' (?: \\\\.  |  [^'] )* ' )", 14);
    private static final Pattern s_re_unloadStringSingle = Pattern.compile("(?:    (?<! \\b E ) \\\\'[^']* (?<!\\\\{2})' |(?<!\\\\{2})'[^']*(?<!\\\\{2})'  )", 14);
    private static final Pattern s_re_inlineFunc = Pattern.compile("(?:(\\b ( CONVERT \\( | LIKE \\b) ) [^$,{?}()] )", 14);
    private static final Pattern s_re_sign = Pattern.compile("(?:[^$,{?}()] )*", 14);
    private PGReplacer m_re_replacer = new PGReplacer();
    private static final String s_replaceEscapedQuote = "\u2122\u00a8\u203a\u203a\u2122\u00a8\u203a\u203a\u2122\u00a8\u203a\u203a\u2122\u00a8\u203a\u203a\u2122\u00a8\u203a\u203a";
    private static final String s_create = "CREATE";
    private static final String s_alter = "ALTER";
    private static final String s_drop = "DROP";
    private static final String s_truncate = "TRUNCATE";
    private static final String s_comment = "COMMENT";
    private static final String s_vacuum = "VACUUM";
    private static final String s_delete = "DELETE";
    private static final String s_insert = "INSERT";
    private static final String s_update = "UPDATE";
    private static final String s_copy = "COPY";
    private static final String s_grant = "GRANT";
    private static final String s_revoke = "REVOKE";
    private static final Pattern s_selectInto = Pattern.compile("select[^'\"]*(([^']*'[^']*'[^']*)|([^\"]*\"[^\"]*\"[^\"]*))*[^'\"]*into", 2);
    private String m_query;
    private Matcher typeMatcher;
    private Matcher likeMatcher;
    private Matcher parameterMatcher;
    private Matcher commentMatcherDash;
    private Matcher commentMatcherStar;
    private Matcher commentMatcherStar2;
    private Matcher stringMatcherDoubleBracket;
    private Matcher stringMatcherCstyle;
    private Matcher stringMatcherSingle;
    private Matcher inlineFuncMatcher;
    private Matcher signMatcher;
    private boolean m_queryAsParameterFlag;
    private ArrayList<Integer> m_escapedQuotesEncoded;
    private ArrayList<Integer> listOfmatchesStrDouBracket;
    private ArrayList<Integer> listOfmatchesStrCstyle;
    private ArrayList<Integer> listOfmatchesStrSingle;

    public boolean isUnloadStatement() {
        return this.m_queryAsParameterFlag;
    }

    public boolean isUnloadStatement(String string) {
        Matcher matcher = s_re_unloadQuery.matcher(string.toLowerCase());
        if (matcher.find()) {
            this.m_queryAsParameterFlag = true;
        }
        return this.m_queryAsParameterFlag;
    }

    public int parameterCounter() {
        return this.m_re_replacer.getNumParams();
    }

    public int parameterCounter(String string) {
        try {
            this.apply(string);
        }
        catch (ErrorException errorException) {
            return -1;
        }
        return this.m_re_replacer.getNumParams();
    }

    public void checkReadOnly(String string) throws ErrorException {
        if (PGEscaper.isQueryDML(string) || PGEscaper.isQueryDDL(string) || PGEscaper.isQueryDCL(string)) {
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_READ_ONLY_CONSTRAINT_ERROR);
        }
    }

    public static boolean isQueryDML(String string) {
        String string2 = string.toUpperCase();
        return string2.startsWith(s_delete) || string2.startsWith(s_insert) || string2.startsWith(s_update) || string2.startsWith(s_copy) || s_selectInto.matcher(string).find();
    }

    public static boolean isQueryDDL(String string) {
        String string2 = string.toUpperCase();
        return string2.startsWith(s_create) || string2.startsWith(s_drop) || string2.startsWith(s_alter) || string2.startsWith(s_truncate) || string2.startsWith(s_comment) || string2.startsWith(s_vacuum);
    }

    public static boolean isQueryDCL(String string) {
        String string2 = string.toUpperCase();
        return string2.startsWith(s_grant) || string2.startsWith(s_revoke);
    }

    public String apply(String string) throws ErrorException {
        int n;
        Matcher matcher;
        if (null == string || string.isEmpty()) {
            return string;
        }
        assert (this.m_re_replacer != null);
        this.m_re_replacer.resetReplacer();
        StringBuilder stringBuilder = new StringBuilder();
        this.m_query = string;
        this.typeMatcher = null;
        this.likeMatcher = null;
        this.parameterMatcher = null;
        this.commentMatcherDash = null;
        this.commentMatcherStar = null;
        this.commentMatcherStar2 = null;
        this.stringMatcherDoubleBracket = null;
        this.stringMatcherCstyle = null;
        this.stringMatcherSingle = null;
        this.signMatcher = null;
        this.inlineFuncMatcher = null;
        Matcher matcher2 = s_re_escapeQuote.matcher(string);
        StringBuilder stringBuilder2 = new StringBuilder(string);
        this.m_escapedQuotesEncoded = new ArrayList();
        while (matcher2.find()) {
            int n2 = matcher2.start();
            this.m_escapedQuotesEncoded.add(stringBuilder2.substring(n2, n2 + 2).contains("'") ? 0 : 1);
            stringBuilder2.delete(n2, n2 + 2);
            stringBuilder2.insert(n2, s_replaceEscapedQuote);
            matcher2 = s_re_escapeQuote.matcher(stringBuilder2);
        }
        if (!this.m_escapedQuotesEncoded.isEmpty()) {
            this.m_query = stringBuilder2.toString();
        }
        if ((matcher = s_re_unloadQuery.matcher(this.m_query.toLowerCase())).find()) {
            this.m_queryAsParameterFlag = true;
            this.m_re_replacer.isUnloadQuery(this.m_queryAsParameterFlag);
            n = matcher.start() + matcher.group().indexOf("('") + 2;
            stringBuilder.append(this.m_query.substring(0, n));
            this.m_query = string.substring(n);
            this.stringMatcherDoubleBracket = s_re_unloadStringDouble.matcher(this.m_query);
            this.stringMatcherCstyle = s_re_unloadStringSingle.matcher(this.m_query);
            this.stringMatcherSingle = s_re_unloadStringcstyle.matcher(this.m_query);
            this.typeMatcher = s_re_unloadType.matcher(this.m_query.toLowerCase());
        } else {
            this.m_queryAsParameterFlag = false;
            this.typeMatcher = s_re_type.matcher(this.m_query.toLowerCase());
            this.stringMatcherDoubleBracket = s_re_stringDoubleBracket.matcher(this.m_query);
            this.stringMatcherCstyle = s_re_stringSingle.matcher(this.m_query);
            this.stringMatcherSingle = s_re_stringCstyle.matcher(this.m_query);
        }
        this.likeMatcher = s_re_likeEscape.matcher(string.toUpperCase());
        this.parameterMatcher = s_re_parameters.matcher(this.m_query);
        this.signMatcher = s_re_sign.matcher(this.m_query);
        this.inlineFuncMatcher = s_re_inlineFunc.matcher(this.m_query.toUpperCase());
        this.commentMatcherDash = s_re_commentDash.matcher(this.m_query);
        this.commentMatcherStar = s_re_commentStar.matcher(this.m_query);
        this.commentMatcherStar2 = s_re_commentStar2.matcher(this.m_query);
        this.listOfmatchesStrDouBracket = new ArrayList();
        this.listOfmatchesStrCstyle = new ArrayList();
        this.listOfmatchesStrSingle = new ArrayList();
        n = this.apply(0, 0, stringBuilder);
        if (!this.m_escapedQuotesEncoded.isEmpty()) {
            stringBuilder = new StringBuilder(this.putEscapedQuotesBack(stringBuilder.toString()));
        }
        return stringBuilder.toString();
    }

    public int scan(String string, int n, String string2) {
        if (string == null || string.isEmpty()) {
            return 0;
        }
        this.m_query = string;
        Matcher matcher = s_re_scan.matcher(this.m_query);
        n = this.scan(n, string2, matcher);
        return n;
    }

    /*
     * Unable to fully structure code
     */
    private int apply(int var1_1, int var2_2, StringBuilder var3_3) throws ErrorException {
        if (!PGEscaper.$assertionsDisabled && this.m_re_replacer == null) {
            throw new AssertionError();
        }
        if (!PGEscaper.$assertionsDisabled && this.stringMatcherDoubleBracket == null) {
            throw new AssertionError();
        }
        if (!PGEscaper.$assertionsDisabled && this.commentMatcherDash == null) {
            throw new AssertionError();
        }
        if (!PGEscaper.$assertionsDisabled && this.inlineFuncMatcher == null) {
            throw new AssertionError();
        }
        if (!PGEscaper.$assertionsDisabled && this.signMatcher == null) {
            throw new AssertionError();
        }
        if (!PGEscaper.$assertionsDisabled && this.typeMatcher == null) {
            throw new AssertionError();
        }
        if (!PGEscaper.$assertionsDisabled && this.m_query == null) {
            throw new AssertionError();
        }
        var4_4 = "?{";
        var5_5 = EscapeTypes.UNKNOWN;
        var6_6 = -1;
        var7_7 = 0;
        var8_8 = 0;
        var9_9 = new StringBuilder();
        var10_10 = new ArrayList<StringBuilder>();
        while (true) {
            block59: {
                block58: {
                    var11_11 = this.scan(var1_1, var4_4, this.commentMatcherDash);
                    var12_12 = this.scan(var1_1, var4_4, this.commentMatcherStar);
                    var13_13 = this.scan(var1_1, var4_4, this.commentMatcherStar2);
                    var14_14 = Math.min(var11_11, Math.min(var12_12, var13_13));
                    var11_11 = this.scan(var1_1, var4_4, this.stringMatcherDoubleBracket);
                    var12_12 = this.scan(var1_1, var4_4, this.stringMatcherCstyle);
                    var13_13 = this.scan(var1_1, var4_4, this.stringMatcherSingle);
                    var15_15 = Math.min(var11_11, Math.min(var12_12, var13_13));
                    var16_16 = this.scan(var1_1, var4_4, this.inlineFuncMatcher);
                    var17_17 = this.scan(var1_1, var4_4, this.signMatcher);
                    var8_8 = Math.min(var14_14, Math.min(var15_15, Math.min(var16_16, var17_17)));
                    var18_18 = "?{".equals(var4_4) != false ? var3_3 : ("}".equals(var4_4) != false ? var9_9 : (StringBuilder)var10_10.get(var10_10.size() - 1));
                    if (var8_8 > var1_1) {
                        var18_18.append(this.m_query.substring(var1_1, var8_8));
                    }
                    if (var8_8 >= this.m_query.length()) break;
                    if (!Character.isLetter(this.m_query.charAt(var8_8))) break block58;
                    if (var4_4.equals(",)(}?{")) {
                        if (!PGEscaper.$assertionsDisabled && var7_7 <= 0) {
                            throw new AssertionError();
                        }
                        try {
                            var8_8 = this.apply(var8_8, var2_2, var18_18);
                        }
                        catch (Throwable var19_20) {
                            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_ESCAPER_ERR, this.m_query);
                        }
                    } else {
                        var19_21 = this.processChar(var8_8, var18_18, var7_7, var10_10, var3_3, var5_5, "?{", ",)(}?{", var4_4);
                        var8_8 = (Integer)var19_21[0];
                        var4_4 = (String)var19_21[1];
                        var7_7 = (Integer)var19_21[2];
                    }
                    break block59;
                }
                block2 : switch (this.m_query.charAt(var8_8++)) {
                    case '?': {
                        this.processParameterSign(var8_8, var18_18, var1_1, var10_10);
                        break;
                    }
                    case '(': {
                        ++var7_7;
                        var18_18.append('(');
                        break;
                    }
                    case ')': {
                        if (--var7_7 == 0 && ",)(}?{".equals(var4_4)) {
                            var4_4 = "}";
                            break;
                        }
                        var18_18.append(')');
                        break;
                    }
                    case ',': {
                        if (var7_7 == 1) {
                            var6_6 = var8_8;
                            var10_10.add(new StringBuilder(""));
                            break;
                        }
                        var18_18.append(',');
                        break;
                    }
                    case '}': {
                        if (!PGEscaper.$assertionsDisabled && "?{".equals(var4_4)) {
                            throw new AssertionError();
                        }
                        for (var19_22 = 1; var19_22 < var10_10.size(); ++var19_22) {
                            var20_25 = var10_10.get(var19_22);
                            while (0 != var20_25.length() && Character.isWhitespace(var20_25.charAt(0))) {
                                var20_25.deleteCharAt(0);
                            }
                        }
                        var21_27 = var3_3.length();
                        if (var21_27 > 0 && Character.isLetterOrDigit(var3_3.charAt(var21_27 - 1))) {
                            var3_3.append(" ");
                        }
                        var3_3.append((CharSequence)this.m_re_replacer.replace(var5_5, var10_10)).append((CharSequence)var9_9);
                        var10_10.clear();
                        var9_9 = new StringBuilder();
                        if (var2_2 > 0) {
                            return var8_8;
                        }
                        var4_4 = "?{";
                        break;
                    }
                    case '{': {
                        if (!"?{".equals(var4_4)) {
                            try {
                                var8_8 = this.apply(var8_8 - 1, var2_2 + 1, var10_10.get(var10_10.size() - 1));
                                break;
                            }
                            catch (Throwable var19_23) {
                                throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_ESCAPER_ERR, this.m_query);
                            }
                        }
                        if (!(PGEscaper.$assertionsDisabled || var8_8 >= 0 && var8_8 <= this.m_query.length())) {
                            throw new AssertionError();
                        }
                        if (!this.typeMatcher.find(var8_8) || var8_8 != this.typeMatcher.start()) {
                            var3_3.append(this.m_query.substring(var8_8 - 1, ++var8_8));
                            break;
                        }
                        var8_8 = this.m_queryAsParameterFlag != false ? this.typeMatcher.start(0) : this.typeMatcher.start(1);
                        switch (Character.toLowerCase(this.m_query.charAt(var8_8))) {
                            case 'd': {
                                var5_5 = EscapeTypes.DATE;
                                break;
                            }
                            case 'e': {
                                var5_5 = EscapeTypes.ESCAPE;
                                break;
                            }
                            case 'l': {
                                var5_5 = EscapeTypes.LIMIT_OFFSET;
                                break;
                            }
                            case 't': {
                                var5_5 = Character.toLowerCase(this.m_query.charAt(var8_8 + 1)) == 's' ? EscapeTypes.TIMESTAMP : EscapeTypes.TIME;
                                break;
                            }
                            case 'i': {
                                var5_5 = EscapeTypes.INTERVAL;
                                break;
                            }
                            case 'o': {
                                var5_5 = EscapeTypes.OUTERJOIN;
                                break;
                            }
                            case 'c': {
                                var5_5 = EscapeTypes.CALL;
                                break;
                            }
                            case '?': {
                                var5_5 = EscapeTypes.RESULT;
                                break;
                            }
                            case 'f': {
                                var5_5 = EscapeTypes.FN;
                                break;
                            }
                            case 'g': {
                                var5_5 = EscapeTypes.GUID;
                                break;
                            }
                        }
                        var10_10.clear();
                        switch (1.$SwitchMap$com$amazon$support$EscapeTypes[var5_5.ordinal()]) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: {
                                var10_10.add(new StringBuilder(this.m_query.substring(this.typeMatcher.start(2), this.typeMatcher.end(2))));
                                var21_27 = var3_3.length();
                                if (var21_27 > 0 && Character.isLetterOrDigit(var3_3.charAt(var21_27 - 1))) {
                                    var3_3.append(" ");
                                }
                                var3_3.append((CharSequence)this.m_re_replacer.replace(var5_5, var10_10));
                                if (var2_2 > 0) {
                                    return this.typeMatcher.end(0);
                                }
                                var10_10.clear();
                                ** GOTO lbl198
                            }
                            case 7: {
                                var10_10.add(new StringBuilder(this.m_query.substring(this.typeMatcher.start(3), this.typeMatcher.end(3))));
                                if (this.typeMatcher.start(4) != -1) {
                                    var10_10.add(new StringBuilder(this.m_query.substring(this.typeMatcher.start(4), this.typeMatcher.end(4))));
                                }
                                if (-1 != (var19_24 = this.m_re_replacer.replace(var5_5, var10_10)).indexOf("NOT IMPLEMENTED:")) {
                                    var19_24.append(" ");
                                }
                                var3_3.append((CharSequence)var19_24);
                                ** GOTO lbl198
                            }
                            case 8: {
                                var4_4 = "}?{";
                                var6_6 = this.typeMatcher.end(0);
                                var10_10.add(new StringBuilder(""));
                                ** GOTO lbl198
                            }
                            case 9: 
                            case 10: 
                            case 11: {
                                if (!this.m_queryAsParameterFlag) ** GOTO lbl189
                                for (var20_26 = this.typeMatcher.groupCount() - 1; -1 < var20_26; --var20_26) {
                                    if (null == this.typeMatcher.group(var20_26) || this.typeMatcher.group(var20_26).contains("fn")) {
                                        continue;
                                    }
                                    var10_10.add(new StringBuilder(this.m_query.substring(this.typeMatcher.start(var20_26), this.typeMatcher.end(var20_26))));
                                    var8_8 = this.typeMatcher.end(var20_26);
                                    ** GOTO lbl192
                                }
                                ** GOTO lbl192
lbl189:
                                // 1 sources

                                var10_10.add(new StringBuilder(this.m_query.substring(this.typeMatcher.start(5), this.typeMatcher.end(5))));
                                var8_8 = this.typeMatcher.start(6);
lbl192:
                                // 3 sources

                                var4_4 = ",)(}?{";
                                if (this.m_query.charAt(var8_8) == '}') break block2;
                                var7_7 = 1;
                                var6_6 = this.typeMatcher.end(0);
                                var10_10.add(new StringBuilder(""));
                            }
lbl198:
                            // 5 sources

                            default: {
                                var8_8 = this.typeMatcher.end(0);
                            }
                        }
                    }
                }
            }
            var1_1 = var8_8;
        }
        return var8_8;
    }

    private int scan(int n, String string, Matcher matcher) {
        assert (matcher != null);
        assert (string != null);
        assert (n >= 0 && n <= this.m_query.length());
        while (true) {
            int n2 = -1;
            if (!matcher.find(n)) {
                return this.m_query.length();
            }
            if (matcher.groupCount() > 0) {
                n2 = matcher.start(1);
            }
            if (-1 == n2) {
                n2 = matcher.end(0);
            }
            if (n2 == -1 || n2 >= this.m_query.length()) {
                return this.m_query.length();
            }
            char[] cArray = string.toCharArray();
            char c = this.m_query.charAt(n2);
            if (Character.isLetter(c)) {
                return n2;
            }
            for (int i = 0; i < cArray.length; ++i) {
                if (c != cArray[i]) continue;
                return n2;
            }
            n = n2 + 1;
        }
    }

    private String putEscapedQuotesBack(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        Pattern pattern = Pattern.compile(s_replaceEscapedQuote);
        String string2 = "";
        int n = 0;
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            string2 = 0 == this.m_escapedQuotesEncoded.get(n++) ? "\\'" : "\\\"";
            int n2 = matcher.start();
            int n3 = matcher.end();
            stringBuilder.delete(n2, n3);
            stringBuilder.insert(n2, string2);
            matcher = pattern.matcher(stringBuilder);
        }
        return stringBuilder.toString();
    }

    private Object[] pickTheFittestCommentMatcher(int n, boolean bl, boolean bl2, boolean bl3) {
        int n2;
        boolean bl4;
        Object[] objectArray = new Object[2];
        if (bl) {
            if (this.commentMatcherDash.end() > n && this.commentMatcherDash.start() < n) {
                objectArray[0] = this.commentMatcherDash;
                objectArray[1] = true;
                return objectArray;
            }
            bl4 = false;
            while (!bl4 && bl && -1 != this.commentMatcherDash.end(0) && this.commentMatcherDash.end(0) < n) {
                n2 = this.commentMatcherDash.end(0);
                bl = this.commentMatcherDash.find(n2);
                if (!bl || this.commentMatcherDash.start(0) >= n || this.commentMatcherDash.end(0) <= n) continue;
                bl4 = true;
                bl = false;
            }
            if (bl4) {
                objectArray[0] = this.commentMatcherDash;
                objectArray[1] = true;
                return objectArray;
            }
            objectArray[0] = this.commentMatcherDash;
            objectArray[1] = false;
        }
        if (bl2) {
            if (this.commentMatcherStar.end() > n && this.commentMatcherStar.start() < n) {
                objectArray[0] = this.commentMatcherStar;
                objectArray[1] = true;
                return objectArray;
            }
            bl4 = false;
            while (!bl4 && bl2 && -1 != this.commentMatcherStar.end(0) && this.commentMatcherStar.end(0) < n) {
                n2 = this.commentMatcherStar.end(0);
                bl2 = this.commentMatcherStar.find(n2);
                if (!bl2 || this.commentMatcherStar.start(0) >= n || this.commentMatcherStar.end(0) <= n) continue;
                bl4 = true;
                bl2 = false;
            }
            if (bl4) {
                objectArray[0] = this.commentMatcherStar;
                objectArray[1] = true;
                return objectArray;
            }
            objectArray[0] = this.commentMatcherStar;
            objectArray[1] = false;
        }
        if (bl3) {
            if (this.commentMatcherStar2.end() > n && this.commentMatcherStar2.start() < n) {
                objectArray[0] = this.commentMatcherStar2;
                objectArray[1] = true;
                return objectArray;
            }
            bl4 = false;
            while (!bl4 && bl3 && -1 != this.commentMatcherStar2.end(0) && this.commentMatcherStar2.end(0) < n) {
                n2 = this.commentMatcherStar2.end(0);
                bl3 = this.commentMatcherStar2.find(n2);
                if (!bl3 || this.commentMatcherStar2.start(0) >= n || this.commentMatcherStar2.end(0) <= n) continue;
                bl4 = true;
                bl3 = false;
            }
            if (bl4) {
                objectArray[0] = this.commentMatcherStar2;
                objectArray[1] = true;
                return objectArray;
            }
            objectArray[0] = this.commentMatcherStar2;
            objectArray[1] = false;
        }
        return objectArray;
    }

    private Object[] pickTheFittestStringMatcher(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n2;
        int n3;
        boolean bl5;
        Object[] objectArray = new Object[2];
        if (bl) {
            if (this.stringMatcherDoubleBracket.end() > n && this.stringMatcherDoubleBracket.start() < n) {
                objectArray[0] = this.stringMatcherDoubleBracket;
                objectArray[1] = true;
                return objectArray;
            }
            if (bl4) {
                bl5 = false;
                if (this.listOfmatchesStrDouBracket.isEmpty()) {
                    this.listOfmatchesStrDouBracket.add(this.stringMatcherDoubleBracket.start(0));
                    this.listOfmatchesStrDouBracket.add(this.stringMatcherDoubleBracket.end(0));
                    while (bl && -1 != this.stringMatcherDoubleBracket.end(0)) {
                        n3 = this.stringMatcherDoubleBracket.end(0);
                        bl = this.stringMatcherDoubleBracket.find(n3);
                        if (bl) {
                            this.listOfmatchesStrDouBracket.add(this.stringMatcherDoubleBracket.start(0));
                            this.listOfmatchesStrDouBracket.add(this.stringMatcherDoubleBracket.end(0));
                        }
                        if (!bl || this.stringMatcherDoubleBracket.start(0) >= n || this.stringMatcherDoubleBracket.end(0) <= n) continue;
                        bl5 = true;
                    }
                } else {
                    n3 = 0;
                    for (n2 = 0; n2 < this.listOfmatchesStrDouBracket.size() / 2; ++n2) {
                        if (this.listOfmatchesStrDouBracket.get(n3) < n && this.listOfmatchesStrDouBracket.get(n3 + 1) > n) {
                            bl5 = true;
                            break;
                        }
                        n3 += 2;
                    }
                }
                if (bl5) {
                    objectArray[0] = this.stringMatcherDoubleBracket;
                    objectArray[1] = true;
                    return objectArray;
                }
            }
            objectArray[0] = this.stringMatcherDoubleBracket;
            objectArray[1] = false;
        }
        if (bl2) {
            if (this.stringMatcherCstyle.end() > n && this.stringMatcherCstyle.start() < n) {
                objectArray[0] = this.stringMatcherCstyle;
                objectArray[1] = true;
                return objectArray;
            }
            if (bl4) {
                bl5 = false;
                if (this.listOfmatchesStrCstyle.isEmpty()) {
                    this.listOfmatchesStrCstyle.add(this.stringMatcherCstyle.start());
                    this.listOfmatchesStrCstyle.add(this.stringMatcherCstyle.end());
                    while (bl2 && -1 != this.stringMatcherCstyle.end(0)) {
                        n3 = this.stringMatcherCstyle.end(0);
                        bl2 = this.stringMatcherCstyle.find(n3);
                        if (bl2) {
                            this.listOfmatchesStrCstyle.add(this.stringMatcherCstyle.start(0));
                            this.listOfmatchesStrCstyle.add(this.stringMatcherCstyle.end(0));
                        }
                        if (!bl2 || this.stringMatcherCstyle.start(0) >= n || this.stringMatcherCstyle.end(0) <= n) continue;
                        bl5 = true;
                    }
                } else {
                    n3 = 0;
                    for (n2 = 0; n2 < this.listOfmatchesStrCstyle.size() / 2; ++n2) {
                        if (this.listOfmatchesStrCstyle.get(n3) < n && this.listOfmatchesStrCstyle.get(n3 + 1) > n) {
                            bl5 = true;
                            break;
                        }
                        n3 += 2;
                    }
                }
                if (bl5) {
                    objectArray[0] = this.stringMatcherCstyle;
                    objectArray[1] = true;
                    return objectArray;
                }
            }
            objectArray[0] = this.stringMatcherCstyle;
            objectArray[1] = false;
        }
        if (bl3) {
            if (this.stringMatcherSingle.end() > n && this.stringMatcherSingle.start() < n) {
                objectArray[0] = this.stringMatcherSingle;
                objectArray[1] = true;
                return objectArray;
            }
            if (bl4) {
                bl5 = false;
                if (this.listOfmatchesStrSingle.isEmpty()) {
                    this.listOfmatchesStrSingle.add(this.stringMatcherSingle.start(0));
                    this.listOfmatchesStrSingle.add(this.stringMatcherSingle.end(0));
                    while (bl3 && -1 != this.stringMatcherSingle.end(0)) {
                        n3 = this.stringMatcherSingle.end(0);
                        bl3 = this.stringMatcherSingle.find(n3);
                        if (bl3) {
                            this.listOfmatchesStrSingle.add(this.stringMatcherSingle.start(0));
                            this.listOfmatchesStrSingle.add(this.stringMatcherSingle.end(0));
                        }
                        if (!bl3 || this.stringMatcherSingle.start(0) >= n || this.stringMatcherSingle.end(0) <= n) continue;
                        bl5 = true;
                    }
                } else {
                    n3 = 0;
                    for (n2 = 0; n2 < this.listOfmatchesStrSingle.size() / 2; ++n2) {
                        if (this.listOfmatchesStrSingle.get(n3) < n && this.listOfmatchesStrSingle.get(n3 + 1) > n) {
                            bl5 = true;
                            break;
                        }
                        n3 += 2;
                    }
                }
                if (bl5) {
                    objectArray[0] = this.stringMatcherSingle;
                    objectArray[1] = true;
                    return objectArray;
                }
            }
            objectArray[0] = this.stringMatcherSingle;
            objectArray[1] = false;
        }
        return objectArray;
    }

    private Object[] processChar(int n, StringBuilder stringBuilder, int n2, ArrayList<StringBuilder> arrayList, StringBuilder stringBuilder2, EscapeTypes escapeTypes, String string, String string2, String string3) {
        Object[] objectArray = new Object[3];
        if ('L' != this.m_query.charAt(n) && 'l' != this.m_query.charAt(n) && this.m_query.length() - n > 6 && this.m_query.substring(n, n + 6).equalsIgnoreCase(CONVERT)) {
            int n3;
            assert (n2 == 0);
            escapeTypes = EscapeTypes.FN;
            int n4 = n3 = this.m_query.indexOf("(", n);
            while (Character.isSpaceChar(this.m_query.charAt(n4 - 1))) {
                --n4;
            }
            arrayList.clear();
            arrayList.add(new StringBuilder(this.m_query.substring(n, n4)));
            n = n3 + 1;
            n2 = 1;
            string3 = string2;
        } else if (this.m_query.length() - n > 6 && this.m_query.substring(n, n + 4).equalsIgnoreCase(LIKE) && !this.likeMatcher.find(n)) {
            stringBuilder2.append(LIKE.toUpperCase());
            n += 4;
        } else if (this.m_query.length() - n > 10 && this.m_query.substring(n, n + 4).equalsIgnoreCase(LIKE) && this.m_query.toLowerCase().contains(ESCAPE)) {
            String string4;
            escapeTypes = EscapeTypes.LIKE_ESCAPE;
            int n5 = 2;
            while (null == this.likeMatcher.group(n5)) {
                ++n5;
            }
            stringBuilder2.append(this.m_query.substring(n, this.likeMatcher.start(n5)));
            stringBuilder2.append(" ");
            arrayList.clear();
            String string5 = this.likeMatcher.group(n5);
            int n6 = n5 + 1;
            while (2 > string5.length()) {
                int n7 = this.likeMatcher.start(n6);
                int n8 = this.likeMatcher.end(n6);
                if (-1 != n7 && -1 != n8) {
                    string5 = this.m_query.substring(this.likeMatcher.start(n6), this.likeMatcher.end(n6++));
                    if (string5.equals("?")) {
                        string5 = this.m_re_replacer.replace(EscapeTypes.PARAM, arrayList).toString();
                    }
                    if (n6 != this.likeMatcher.groupCount()) continue;
                    objectArray[0] = this.m_query.length();
                    return objectArray;
                }
                ++n6;
            }
            int n9 = -1;
            while (-1 == n9) {
                n9 = this.likeMatcher.start(n6);
                if (null == this.likeMatcher.group(n6) || 2 > this.likeMatcher.group(n6).length() || this.likeMatcher.group(n6).toUpperCase().contains(ESCAPE.toUpperCase())) {
                    n9 = -1;
                }
                if (++n6 != this.likeMatcher.groupCount()) continue;
                objectArray[0] = this.m_query.length();
                return objectArray;
            }
            if ((string4 = this.m_query.substring(this.likeMatcher.start(--n6), this.likeMatcher.end(n6))).equals("?")) {
                string4 = this.m_re_replacer.replace(EscapeTypes.PARAM, arrayList).toString();
            }
            arrayList.add(new StringBuilder(string5));
            arrayList.add(new StringBuilder(string4));
            stringBuilder2.append(this.m_re_replacer.replace(escapeTypes, arrayList).toString());
            string3 = string;
            n = this.likeMatcher.end(0);
        } else {
            int n10 = this.m_query.indexOf(" ", n) + 1;
            if (n10 > n) {
                stringBuilder.append(this.m_query.substring(n, n10));
                n = n10;
            } else {
                stringBuilder.append(this.m_query.substring(n++, n));
            }
        }
        objectArray[0] = n;
        objectArray[1] = string3;
        objectArray[2] = n2;
        return objectArray;
    }

    private void processParameterSign(int n, StringBuilder stringBuilder, int n2, ArrayList<StringBuilder> arrayList) {
        if (-1 < n - 3 && this.parameterMatcher.find(n - 3)) {
            boolean bl;
            boolean bl2;
            boolean bl3 = this.stringMatcherDoubleBracket.find(0);
            boolean bl4 = this.stringMatcherCstyle.find(0);
            boolean bl5 = this.stringMatcherSingle.find(0);
            boolean bl6 = bl3 || bl4 || bl5;
            Matcher matcher = null;
            boolean bl7 = false;
            Object[] objectArray = null;
            if (bl6) {
                objectArray = this.pickTheFittestStringMatcher(n - 1, bl3, bl4, bl5, true);
                matcher = (Matcher)objectArray[0];
                bl7 = (Boolean)objectArray[1];
            }
            if (bl7) {
                stringBuilder.append('?');
                return;
            }
            bl3 = this.stringMatcherDoubleBracket.find(n2);
            bl4 = this.stringMatcherCstyle.find(n2);
            bl5 = this.stringMatcherSingle.find(n2);
            boolean bl8 = bl2 = bl3 || bl4 || bl5;
            if (bl2) {
                objectArray = this.pickTheFittestStringMatcher(n - 1, bl3, bl4, bl5, false);
                matcher = (Matcher)objectArray[0];
                bl7 = (Boolean)objectArray[1];
            }
            Matcher matcher2 = null;
            boolean bl9 = this.commentMatcherDash.find(n2);
            boolean bl10 = this.commentMatcherStar.find(n2);
            boolean bl11 = this.commentMatcherStar2.find(n2);
            boolean bl12 = bl = bl9 || bl10 || bl11;
            if (bl) {
                objectArray = this.pickTheFittestCommentMatcher(n - 1, bl9, bl10, bl11);
                matcher2 = (Matcher)objectArray[0];
                bl = (Boolean)objectArray[1];
            }
            if (bl2 || bl) {
                if (bl2 && (matcher.start(0) > n - 1 || matcher.end(0) < n - 1)) {
                    if (!bl || bl && (matcher2.start(0) > n - 1 || matcher2.end(0) < n - 1)) {
                        stringBuilder.append((CharSequence)this.m_re_replacer.replace(EscapeTypes.PARAM, arrayList));
                    } else {
                        stringBuilder.append('?');
                    }
                } else if (bl2) {
                    stringBuilder.append('?');
                } else if (bl) {
                    while (bl && matcher2.end(0) < n - 1) {
                        int n3 = matcher2.end(0) + 1;
                        bl = matcher2.find(n3);
                    }
                    if (bl && (matcher2.start(0) > n - 1 || matcher2.end(0) < n - 1) || !bl) {
                        stringBuilder.append((CharSequence)this.m_re_replacer.replace(EscapeTypes.PARAM, arrayList));
                    } else {
                        stringBuilder.append('?');
                    }
                } else {
                    stringBuilder.append('?');
                }
            } else {
                stringBuilder.append((CharSequence)this.m_re_replacer.replace(EscapeTypes.PARAM, arrayList));
            }
        } else if (0 > n - 3) {
            stringBuilder.append((CharSequence)this.m_re_replacer.replace(EscapeTypes.PARAM, arrayList));
        } else {
            stringBuilder.append('?');
        }
    }
}

