/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import oracle.xml.parser.schema.XSDDataValue;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.builtIns.FNUtil;

class FNAdjustTimezone
extends OXMLFunction {
    int funcFlag;
    String fnName;
    OXMLSequenceType argType;

    FNAdjustTimezone(int n) {
        this.funcFlag = n;
        switch (n) {
            case 0: {
                this.fnName = "adjust-dateTime-to-timezone";
                this.argType = OXMLSequenceType.getConstantType(2, 7);
                break;
            }
            case 1: {
                this.fnName = "adjust-date-to-timezone";
                this.argType = OXMLSequenceType.getConstantType(2, 9);
                break;
            }
            case 2: {
                this.fnName = "adjust-time-to-timezone";
                this.argType = OXMLSequenceType.getConstantType(2, 8);
                break;
            }
            case 3: {
                this.fnName = "adjust-dateTime-to-timezone";
                this.argType = OXMLSequenceType.getConstantType(2, 7);
                break;
            }
            case 4: {
                this.fnName = "adjust-date-to-timezone";
                this.argType = OXMLSequenceType.getConstantType(2, 9);
                break;
            }
            case 5: {
                this.fnName = "adjust-time-to-timezone";
                this.argType = OXMLSequenceType.getConstantType(2, 8);
            }
        }
    }

    @Override
    public String getFunctionName() {
        return this.fnName;
    }

    @Override
    public int getNumberArgs() {
        return this.funcFlag > 2 ? 1 : 2;
    }

    @Override
    public OXMLSequenceType getReturnType() {
        return this.argType;
    }

    @Override
    public OXMLSequenceType getArgType(int n) {
        if (n == 0) {
            return this.argType;
        }
        if (n == 1 && this.funcFlag > 2) {
            return OXMLSequenceType.getConstantType(2, 21);
        }
        return null;
    }

    @Override
    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence) throws XQException {
        if (this.funcFlag > 2) {
            throw new XQException("FORT0001");
        }
        OXMLSequence oXMLSequence2 = oXMLFunctionContext.createSequence();
        OXMLItem oXMLItem = FNUtil.getEmptyOrSingleItem(oXMLSequence);
        if (oXMLItem != null) {
            GregorianCalendar gregorianCalendar = (GregorianCalendar)oXMLItem.getCalendar().clone();
            OXMLItem oXMLItem2 = oXMLFunctionContext.createItem();
            int n = gregorianCalendar.get(15);
            TimeZone timeZone = oXMLFunctionContext.getImplicitTimezone();
            if (timeZone != null) {
                int n2 = timeZone.getRawOffset();
                if (!oXMLItem.hasTimeZone()) {
                    gregorianCalendar.add(14, -1 * n2);
                }
                gregorianCalendar.setTimeZone(new SimpleTimeZone(n2, ""));
                gregorianCalendar.getTime();
                gregorianCalendar.get(11);
                gregorianCalendar = XSDDataValue.normalizeCalendar(gregorianCalendar, oXMLItem.getPrimitiveType());
                oXMLItem2.setCalendar(this.argType, true, gregorianCalendar);
            } else {
                if (oXMLItem.hasTimeZone()) {
                    gregorianCalendar.add(14, n);
                }
                gregorianCalendar.setTimeZone(XSDDataValue.UTC);
                gregorianCalendar.getTime();
                gregorianCalendar.get(11);
                gregorianCalendar = XSDDataValue.normalizeCalendar(gregorianCalendar, oXMLItem.getPrimitiveType());
                oXMLItem2.setCalendar(this.argType, false, gregorianCalendar);
            }
            oXMLSequence2.appendItem(oXMLItem2);
        }
        return oXMLSequence2;
    }

    @Override
    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2) throws XQException {
        if (this.funcFlag < 3) {
            throw new XQException("FORT0001");
        }
        OXMLSequence oXMLSequence3 = oXMLFunctionContext.createSequence();
        OXMLItem oXMLItem = FNUtil.getEmptyOrSingleItem(oXMLSequence);
        if (oXMLItem != null) {
            GregorianCalendar gregorianCalendar = (GregorianCalendar)oXMLItem.getCalendar().clone();
            OXMLItem oXMLItem2 = oXMLFunctionContext.createItem();
            OXMLItem oXMLItem3 = FNUtil.getEmptyOrSingleItem(oXMLSequence2);
            if (oXMLItem3 != null) {
                int n;
                double d = oXMLItem3.getDayTimeDuration();
                if (d != (double)(n = (int)d)) {
                    throw new XQException("FODT0003");
                }
                int n2 = n * 1000;
                if (n2 > 50400000 || n2 < -50400000) {
                    throw new XQException("FODT0003");
                }
                if (!oXMLItem.hasTimeZone()) {
                    gregorianCalendar.add(14, -1 * n2);
                }
                gregorianCalendar.setTimeZone(new SimpleTimeZone(n2, ""));
                gregorianCalendar.getTime();
                gregorianCalendar.get(11);
                gregorianCalendar = XSDDataValue.normalizeCalendar(gregorianCalendar, oXMLItem.getPrimitiveType());
                oXMLItem2.setCalendar(this.argType, true, gregorianCalendar);
            } else {
                int n = 0;
                if (oXMLItem.hasTimeZone()) {
                    n = ((SimpleTimeZone)gregorianCalendar.getTimeZone()).getRawOffset();
                    gregorianCalendar.add(14, n);
                }
                gregorianCalendar.setTimeZone(XSDDataValue.UTC);
                gregorianCalendar.getTime();
                gregorianCalendar.get(11);
                gregorianCalendar = XSDDataValue.normalizeCalendar(gregorianCalendar, oXMLItem.getPrimitiveType());
                oXMLItem2.setCalendar(this.argType, false, gregorianCalendar);
            }
            oXMLSequence3.appendItem(oXMLItem2);
        }
        return oXMLSequence3;
    }

    @Override
    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence[] oXMLSequenceArray) throws XQException {
        if (oXMLSequenceArray.length == 1) {
            return this.invoke(oXMLFunctionContext, oXMLSequenceArray[0]);
        }
        if (oXMLSequenceArray.length == 2) {
            return this.invoke(oXMLFunctionContext, oXMLSequenceArray[0], oXMLSequenceArray[1]);
        }
        throw new XQException("FORT0001");
    }
}

