/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.swing.IFormattedField;
import de.javasoft.swing.JYTextField;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;

public class JYPasswordField
extends JYTextField
implements IFormattedField {
    private static final long serialVersionUID = -5857342396303844897L;
    private char echoChar;
    private boolean echoCharSet = false;

    public JYPasswordField() {
    }

    public JYPasswordField(String string) {
        super(string);
    }

    public JYPasswordField(int n) {
        super(n);
    }

    public JYPasswordField(String string, int n) {
        super(string, n);
    }

    public void updateUI() {
        if (!this.echoCharSet) {
            this.echoChar = (char)SyntheticaLookAndFeel.getInt("JYPasswordField.echoChar", this, 42);
        }
        super.updateUI();
    }

    public char getEchoChar() {
        return this.echoChar;
    }

    public void setEchoChar(char c) {
        this.echoChar = c;
        this.echoCharSet = true;
        this.repaint();
        this.revalidate();
    }

    public boolean echoCharIsSet() {
        return this.echoChar != '\u0000';
    }

    public void cut() {
        if (this.getClientProperty("JYPasswordField.cutCopyAllowed") != Boolean.TRUE) {
            UIManager.getLookAndFeel().provideErrorFeedback(this);
        } else {
            super.cut();
        }
    }

    public void copy() {
        if (this.getClientProperty("JYPasswordField.cutCopyAllowed") != Boolean.TRUE) {
            UIManager.getLookAndFeel().provideErrorFeedback(this);
        } else {
            super.copy();
        }
    }

    public char[] getPassword() {
        Document document = this.getDocument();
        Segment segment = new Segment();
        try {
            document.getText(0, document.getLength(), segment);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        char[] cArray = new char[segment.count];
        System.arraycopy(segment.array, segment.offset, cArray, 0, segment.count);
        return cArray;
    }

    protected String paramString() {
        return String.valueOf(super.paramString()) + ",echoChar=" + this.echoChar;
    }
}

