/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import org.icepdf.core.pobjects.ImageStream;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.graphics.GraphicsState;
import org.icepdf.core.pobjects.graphics.ImageStreamReference;
import org.icepdf.core.pobjects.graphics.MipMappedImageReference;
import org.icepdf.core.pobjects.graphics.ScaledImageReference;
import org.icepdf.core.pobjects.graphics.SmoothScaledImageReference;
import org.icepdf.core.util.Defs;

public class ImageReferenceFactory {
    private static ImageReference scaleType;

    private ImageReferenceFactory() {
    }

    public static ImageReference getScaleType() {
        return scaleType;
    }

    public static void setScaleType(ImageReference scaleType) {
        ImageReferenceFactory.scaleType = scaleType;
    }

    public static org.icepdf.core.pobjects.graphics.ImageReference getImageReference(ImageStream imageStream, Resources resources, GraphicsState graphicsState, Integer imageIndex, Page page) {
        switch (scaleType) {
            case SCALED: {
                return new ScaledImageReference(imageStream, graphicsState, resources, imageIndex, page);
            }
            case SMOOTH_SCALED: {
                return new SmoothScaledImageReference(imageStream, graphicsState, resources, imageIndex, page);
            }
            case MIP_MAP: {
                return new MipMappedImageReference(imageStream, graphicsState, resources, imageIndex, page);
            }
        }
        return new ImageStreamReference(imageStream, graphicsState, resources, imageIndex, page);
    }

    static {
        String imageReferencetype = Defs.sysProperty("org.icepdf.core.imageReference", "default");
        scaleType = "scaled".equals(imageReferencetype) ? ImageReference.SCALED : ("mipmap".equals(imageReferencetype) ? ImageReference.MIP_MAP : ("smoothScaled".equals(imageReferencetype) ? ImageReference.SMOOTH_SCALED : ImageReference.DEFAULT));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImageReference {
        DEFAULT,
        SCALED,
        MIP_MAP,
        SMOOTH_SCALED;

    }
}

