/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.swing.jydocking.Dockbar;
import de.javasoft.swing.jydocking.DockbarLabel;
import de.javasoft.swing.jydocking.DockbarManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;

class StatusDockbar
extends Dockbar {
    private static final long serialVersionUID = -2752314768495082584L;
    private JPanel labelPanel = new JPanel();
    private JComponent statusBarComponent;

    public StatusDockbar(DockbarManager dockbarManager, int n) {
        super(dockbarManager, n);
        this.setLayout(new BorderLayout());
        this.setPlacement(n);
        super.add(this.labelPanel);
    }

    public void setStatusBarComponent(JComponent jComponent) {
        this.statusBarComponent = jComponent;
        this.add((Component)this.statusBarComponent, "South");
    }

    public JComponent getStatusBarComponent() {
        return this.statusBarComponent;
    }

    public Component add(Component component) {
        return this.labelPanel.add(component);
    }

    public void remove(Component component) {
        this.labelPanel.remove(component);
    }

    private void setPlacement(int n) {
        int n2 = this.placement;
        this.placement = n;
        int n3 = n == 1 || n == 3 ? 2 : 3;
        this.labelPanel.setLayout(new BoxLayout(this.labelPanel, n3));
        this.firePropertyChange("placement", n2, n);
    }

    public Dimension getPreferredSize() {
        if (this.statusBarComponent == null || this.statusBarComponent.getComponentCount() == 0) {
            Dimension dimension = new Dimension();
            if (this.dockbarLabels.size() > 0) {
                dimension = super.getPreferredSize();
            }
            return dimension;
        }
        if (this.labelPanel.getComponentCount() == 0) {
            return this.statusBarComponent.getPreferredSize();
        }
        DockbarLabel dockbarLabel = (DockbarLabel)this.labelPanel.getComponent(0);
        return new Dimension(dockbarLabel.getPreferredSize().width + this.statusBarComponent.getPreferredSize().width, dockbarLabel.getPreferredSize().height + this.statusBarComponent.getPreferredSize().height);
    }

    public void updateUI() {
        super.updateUI();
        if (DockbarManager.getCurrent() != null) {
            DockbarManager.getCurrent().revalidate();
            this.repaint();
        }
    }
}

