/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.swing.HorizontalLayout;
import de.javasoft.swing.IUIPropertySupport;
import de.javasoft.swing.WidgetUtils;
import de.javasoft.swing.XMenuItem;
import de.javasoft.swing.XMenuSeparator;
import de.javasoft.swing.plaf.UIValue;
import de.javasoft.swing.plaf.XMenuUI;
import de.javasoft.swing.plaf.addons.XMenuAddon;
import de.javasoft.swing.plaf.basic.BasicXMenuUI;
import de.javasoft.synthetica.addons.SyntheticaAddons;
import de.javasoft.synthetica.addons.SyntheticaAddonsUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.plaf.ComponentAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMenu
extends JMenu
implements JXCollapsiblePane.CollapsiblePaneContainer,
IUIPropertySupport {
    public static final String uiClassID = "XMenuUI";
    private JXCollapsiblePane collapsePane;
    private UIValue<Boolean> animationEnabled;

    static {
        SyntheticaAddons.contribute((ComponentAddon)new XMenuAddon());
    }

    public XMenu() {
        this.init();
    }

    public XMenu(String string) {
        super(string);
        this.init();
    }

    public XMenu(Action action) {
        super(action);
        this.init();
    }

    private void init() {
        this.collapsePane = this.createCollapsiblePane();
        this.getContentPane().setLayout(new HorizontalLayout(SyntheticaLookAndFeel.getInt("XMenu.itemGap", this, 0)));
        this.getContentPane().setName("XMenu.contentPane");
        this.updateContentPaneBorder();
        super.addImpl((Component)this.collapsePane, "Center", -1);
        this.setName("XMenu");
    }

    protected JXCollapsiblePane createCollapsiblePane() {
        JXCollapsiblePane jXCollapsiblePane = new JXCollapsiblePane(JXCollapsiblePane.Direction.RIGHT);
        jXCollapsiblePane.setContentPane((Container)new JXPanel());
        jXCollapsiblePane.setName("XMenu.collapsePane");
        jXCollapsiblePane.setCollapsed(true);
        jXCollapsiblePane.setAnimated(this.getAnimationEnabled().booleanValue());
        jXCollapsiblePane.setOpaque(SyntheticaLookAndFeel.getBoolean("XMenu.collapsePane.opaque", this, false));
        return jXCollapsiblePane;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI(LookAndFeelAddons.getUI((JComponent)this, XMenuUI.class));
        this.updateContentPaneBorder();
        if (this.collapsePane != null) {
            SyntheticaAddonsUtilities.updateChildrenUI((JComponent)this.collapsePane);
        }
    }

    private void updateContentPaneBorder() {
        JComponent jComponent = this.getContentPane();
        if (jComponent != null) {
            jComponent.setBorder(this.createContentPaneBorder());
        }
    }

    protected Border createContentPaneBorder() {
        return ((BasicXMenuUI)this.getUI()).createContentPaneBorder();
    }

    public JComponent getContentPane() {
        return this.collapsePane == null ? null : (JComponent)this.collapsePane.getContentPane();
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        this.getContentPane().add(component, object, n);
        this.revalidate();
    }

    @Override
    public JMenuItem add(JMenuItem jMenuItem) {
        this.addImpl(jMenuItem, null, -1);
        return jMenuItem;
    }

    @Override
    public JMenuItem add(String string) {
        return this.add(new JMenuItem(string));
    }

    @Override
    public JMenuItem add(Action action) {
        JMenuItem jMenuItem = this.createActionComponent(action);
        jMenuItem.setAction(action);
        this.add(jMenuItem);
        return jMenuItem;
    }

    @Override
    protected JMenuItem createActionComponent(Action action) {
        XMenuItem xMenuItem = new XMenuItem(){

            protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
                PropertyChangeListener propertyChangeListener = XMenu.this.createActionChangeListener(this);
                if (propertyChangeListener == null) {
                    propertyChangeListener = super.createActionPropertyChangeListener(action);
                }
                return propertyChangeListener;
            }
        };
        xMenuItem.setHorizontalTextPosition(11);
        xMenuItem.setVerticalTextPosition(0);
        return xMenuItem;
    }

    @Override
    public void addSeparator() {
        this.addImpl(new XMenuSeparator(1), null, -1);
    }

    @Override
    public void menuSelectionChanged(boolean bl) {
        super.menuSelectionChanged(bl);
    }

    @Override
    public JPopupMenu getPopupMenu() {
        return super.getPopupMenu();
    }

    @Override
    public void setPopupMenuVisible(boolean bl) {
        super.setPopupMenuVisible(false);
    }

    @Override
    public void remove(Component component) {
        if (this.getContentPane() != null) {
            this.getContentPane().remove(component);
        }
    }

    @Override
    public void remove(int n) {
        if (this.getContentPane() != null) {
            this.getContentPane().remove(n);
        }
    }

    @Override
    public void removeAll() {
        if (this.getContentPane() != null) {
            this.getContentPane().removeAll();
        }
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
        if (this.getContentPane() != null) {
            this.getContentPane().setLayout(layoutManager);
        }
    }

    @Override
    public LayoutManager getLayout() {
        return this.getContentPane() != null ? this.getContentPane().getLayout() : null;
    }

    public void setMenuLayout(LayoutManager layoutManager) {
        if (layoutManager instanceof BorderLayout) {
            super.setLayout(layoutManager);
        }
    }

    public LayoutManager getMenuLayout() {
        return super.getLayout();
    }

    public void setCollapsed(boolean bl) {
        boolean bl2 = this.isCollapsed();
        this.collapsePane.setCollapsed(bl);
        this.firePropertyChange("collapsed", bl2, this.isCollapsed());
    }

    public boolean isCollapsed() {
        return this.collapsePane.isCollapsed();
    }

    public void setMenuButton(AbstractButton abstractButton) {
        AbstractButton abstractButton2 = this.getMenuButton();
        if (abstractButton2 != null) {
            Component[] componentArray = this.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component component = componentArray[n2];
                if (component == abstractButton2) break;
                ++n2;
            }
        }
        if (abstractButton != null) {
            super.addImpl(abstractButton, "Before", -1);
        }
        this.revalidate();
        this.repaint();
    }

    public AbstractButton getMenuButton() {
        return this.getMenuLayout() instanceof BorderLayout ? (AbstractButton)((BorderLayout)super.getLayout()).getLayoutComponent("Before") : null;
    }

    public Container getValidatingContainer() {
        return this.getParent();
    }

    @Override
    public void firePropertyChange(String string, Object object, Object object2) {
        super.firePropertyChange(string, object, object2);
    }

    public void setAnimationEnabled(Boolean bl) {
        this.setAnimationEnabled(bl, false);
    }

    public void setAnimationEnabled(Boolean bl, boolean bl2) {
        WidgetUtils.setUIProperty(this, "animationEnabled", this.animationEnabled, this.getAnimationEnabled(), bl, bl2, false, false);
        if (this.collapsePane != null) {
            this.collapsePane.setAnimated(this.getAnimationEnabled().booleanValue());
        }
    }

    public boolean animationEnabledIsUIResource() {
        return this.getAnimationEnabledUIValue().isUIResource();
    }

    public Boolean getAnimationEnabled() {
        return this.getAnimationEnabledUIValue().get();
    }

    private UIValue<Boolean> getAnimationEnabledUIValue() {
        if (this.animationEnabled == null) {
            this.animationEnabled = new UIValue();
        }
        return this.animationEnabled;
    }
}

