/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.DebugLog;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXAInputStream;
import com.exasol.jdbc.EXAResult;
import com.exasol.jdbc.EXAResultSet;
import com.exasol.jdbc.ExceptionFactory;
import java.io.IOException;
import java.sql.SQLException;

public class EXASQLException
extends EXAResult {
    private String code;
    private String message;

    public EXASQLException(EXAInputStream eXAInputStream, DebugLog debugLog) throws IOException {
        super("EXASQLException", debugLog);
        this.message = eXAInputStream.readString();
        byte[] byArray = new byte[5];
        eXAInputStream.read(byArray);
        this.code = new String(byArray);
        if (debugLog != null) {
            debugLog.log("created EXASQLException [" + this.code + "]: " + this.message);
        }
    }

    public EXASQLException(String string, String string2, DebugLog debugLog) throws IOException {
        super("EXASQLException", debugLog);
        this.message = string2;
        this.code = string;
        if (debugLog != null) {
            debugLog.log("created EXASQLException [" + this.code + "]: " + this.message);
        }
    }

    public String getSQLCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public SQLException getSQLException() {
        return ExceptionFactory.createSQLException(this.getMessage(), this.getSQLCode(), this.connection);
    }

    protected SQLException getSQLExceptionIntern(EXAConnection eXAConnection) {
        this.connection = eXAConnection;
        return ExceptionFactory.createSQLException(this.getMessage(), this.getSQLCode(), this.connection);
    }

    public EXAResultSet toResultSet() {
        String[] stringArray = new String[]{this.message};
        return this.connection.dialectFactory.createResultSet("Exception", stringArray, this.debug);
    }
}

