/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import com.nuodb.jdbc.Conversions;
import com.nuodb.jdbc.EncodedDataStream;
import com.nuodb.jdbc.SQLContext;
import com.nuodb.jdbc.Value;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public class ValueTimestamp
extends Value {
    Timestamp value;

    public ValueTimestamp() {
    }

    public ValueTimestamp(Timestamp val) {
        this.value = val;
    }

    public ValueTimestamp(Object val) {
        if (val instanceof Timestamp) {
            this.value = (Timestamp)val;
        } else if (val instanceof Date) {
            this.value = new Timestamp(((Date)val).getTime());
        } else {
            throw new IllegalArgumentException("Unable to convert: " + val.getClass().getName() + " into a Timestamp");
        }
    }

    @Override
    void encodeValue(EncodedDataStream dataStream) throws SQLException {
        dataStream.encodeTimestamp(this.value);
    }

    @Override
    int getType() {
        return 10;
    }

    @Override
    String getString() throws SQLException {
        throw new SQLException("Timestamp requires a TimeZone");
    }

    @Override
    String getString(SQLContext context) {
        if (this.value.getNanos() % 1000000000 == 0) {
            return this.getSimpleTimestamp(context.getTimeZone()).format(this.value);
        }
        return this.value.toString();
    }

    @Override
    java.sql.Date getDate() {
        return new java.sql.Date(this.value.getTime());
    }

    @Override
    Timestamp getTimestamp() {
        return this.value;
    }

    @Override
    Time getTime() throws SQLException {
        return new Time(this.value.getTime());
    }

    @Override
    java.sql.Date getDate(SQLContext context) throws SQLException {
        return this.getDate();
    }

    @Override
    Time getTime(SQLContext context) throws SQLException {
        return this.getTime();
    }

    @Override
    Timestamp getTimestamp(SQLContext context) throws SQLException {
        return this.getTimestamp();
    }

    @Override
    BigDecimal getBigDecimal() throws SQLException {
        return this.getBigDecimalFromDateType(this.value.getTime(), this.value.getNanos());
    }

    @Override
    Object getObject() {
        return this.getTimestamp();
    }

    @Override
    public byte[] getBytes() {
        return Conversions.toBytes(this.value.getTime());
    }
}

