/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.wizard;

import com.install4j.runtime.installer.frontend.GUIHelper;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import javax.swing.JFrame;

public abstract class CustomFrame
extends JFrame {
    private static final boolean INTEGRATION_TEST = Boolean.getBoolean("install4j.installerIntegrationTest");

    protected abstract int getFrameHeight();

    protected abstract int getFrameWidth();

    protected Rectangle getNewFrameBounds() {
        int frameWidth = this.getFrameWidth();
        int frameHeight = this.getFrameHeight();
        if (frameWidth == -1) {
            frameWidth = this.getWidth();
        }
        if (frameHeight == -1) {
            frameHeight = this.getHeight();
        }
        return this.getNewFrameBounds(frameWidth, frameHeight);
    }

    protected Rectangle getNewFrameBounds(int frameWidth, int frameHeight) {
        GraphicsDevice screenDevice = this.getScreenDevice();
        Rectangle screenBounds = screenDevice.getDefaultConfiguration().getBounds();
        int newX = screenBounds.x + (screenBounds.width - frameWidth) / 2;
        int newY = screenBounds.y + (screenBounds.height - frameHeight) / 2;
        return new Rectangle(newX, newY, frameWidth, frameHeight);
    }

    private GraphicsDevice getScreenDevice() {
        String testDisplay;
        if (INTEGRATION_TEST && (testDisplay = System.getenv().get("TEST_DISPLAY")) != null) {
            for (GraphicsDevice screenDevice : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
                if (!screenDevice.getIDstring().equals(testDisplay)) continue;
                return screenDevice;
            }
        }
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            GUIHelper.applyComponentOrientation(this);
        }
        super.setVisible(visible);
    }
}

