/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.screens.SystemScreen;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.components.DirectorySelector;
import com.install4j.runtime.installer.frontend.components.ProgramGroupSelector;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class StandardProgramGroupScreen
extends SystemScreen {
    private boolean programGroupEnabled = true;
    private String programGroupName = "";
    private boolean allUsers = true;
    private boolean unixSymlinks = true;
    private String linkDirectory = "/usr/local/bin";
    private boolean allowUserChangeEnabled = true;
    private boolean allowUserChangeAllUsers = true;
    private boolean showWarningIfExists = false;

    public StandardProgramGroupScreen() {
        InstallerVariables.registerResponseFileVariable("sys.programGroupDisabled");
        if (InstallerUtil.isWindows()) {
            InstallerVariables.registerResponseFileVariable("sys.programGroupName");
            InstallerVariables.registerResponseFileVariable("sys.programGroupAllUsers");
            InstallerVariables.registerVariableProvider("sys.programGroupDir", new InstallerVariables.VariableProvider(){

                @Override
                public Object getVariable() {
                    String programGroupName = (String)InstallerVariables.getVariable("sys.programGroupName");
                    boolean allUsers = InstallerVariables.getBooleanVariable("sys.programGroupAllUsers");
                    if (programGroupName != null) {
                        return new File(FolderInfo.getSpecialFolder(3, allUsers), programGroupName).getAbsolutePath();
                    }
                    return null;
                }

                @Override
                public void setVariable(Object value) {
                }
            });
        } else {
            InstallerVariables.registerResponseFileVariable("sys.symlinkDir");
        }
    }

    public boolean isProgramGroupEnabled() {
        return this.programGroupEnabled;
    }

    public void setProgramGroupEnabled(boolean programGroupEnabled) {
        this.programGroupEnabled = programGroupEnabled;
    }

    public String getProgramGroupName() {
        return StandardProgramGroupScreen.replaceVariables(this.programGroupName);
    }

    public void setProgramGroupName(String programGroupName) {
        this.programGroupName = programGroupName;
    }

    public boolean isAllUsers() {
        return this.allUsers;
    }

    public void setAllUsers(boolean allUsers) {
        this.allUsers = allUsers;
    }

    public String getLinkDirectory() {
        return StandardProgramGroupScreen.replaceVariables(this.linkDirectory);
    }

    public boolean isUnixSymlinks() {
        return this.unixSymlinks;
    }

    public void setUnixSymlinks(boolean unixSymlinks) {
        this.unixSymlinks = unixSymlinks;
    }

    public void setLinkDirectory(String linkDirectory) {
        this.linkDirectory = linkDirectory;
    }

    public boolean isAllowUserChangeEnabled() {
        return this.allowUserChangeEnabled;
    }

    public void setAllowUserChangeEnabled(boolean allowUserChangeEnabled) {
        this.allowUserChangeEnabled = allowUserChangeEnabled;
    }

    public boolean isAllowUserChangeAllUsers() {
        return this.allowUserChangeAllUsers;
    }

    public void setAllowUserChangeAllUsers(boolean allowUserChangeAllUsers) {
        this.allowUserChangeAllUsers = allowUserChangeAllUsers;
    }

    public boolean isShowWarningIfExists() {
        return this.showWarningIfExists;
    }

    public void setShowWarningIfExists(boolean showWarningIfExists) {
        this.showWarningIfExists = showWarningIfExists;
    }

    @Override
    protected SystemScreen.DefaultPanel createPanel() {
        if (Util.isWindowsInstaller()) {
            return new WindowsPanel();
        }
        return new UnixPanel();
    }

    @Override
    public boolean isHidden() {
        boolean hidden;
        boolean applicablePlatform = Util.isWindowsInstaller() || Util.isUnixInstaller();
        boolean noSymlinks = Util.isUnixInstaller() && !this.isUnixSymlinks();
        boolean bl = hidden = !applicablePlatform || noSymlinks;
        if (hidden) {
            this.getContext().setVariable("sys.programGroupDisabled", Boolean.TRUE);
        }
        return hidden;
    }

    @Override
    public void willActivate() {
        super.willActivate();
        this.getPanel().willActivate();
    }

    @Override
    public void activated() {
        super.activated();
        this.getPanel().activated();
    }

    @Override
    public boolean next() {
        return this.getPanel().next() && super.next();
    }

    @Override
    protected boolean checkCompleted() {
        return this.getPanel().checkCompleted() && super.checkCompleted();
    }

    @Override
    public String getTitle() {
        return Util.isWindowsInstaller() ? this.getMessage("WizardSelectProgramGroup") : this.getMessage("WizardSelectLinkDir");
    }

    @Override
    public String getSubTitle() {
        return Util.isWindowsInstaller() ? this.getMessage("SelectStartMenuFolderDesc") : Messages.format(this.getMessage("SelectLinkDirDesc"), this.getApplicationName());
    }

    @Override
    public boolean isFillVertical() {
        return Util.isWindowsInstaller();
    }

    @Override
    public boolean handleConsole(Console console) throws UserCanceledException {
        if (!super.handleConsole(console)) {
            return false;
        }
        Context context = this.getContext();
        boolean windows = InstallerUtil.isWindows();
        if (this.allowUserChangeEnabled) {
            boolean enabled = console.askYesNo(this.getMessage(windows ? "ConsoleProgramGroupCheck" : "ConsoleSymlinksCheck"), this.isProgramGroupEnabledOverridden(context));
            context.setVariable("sys.programGroupDisabled", !enabled);
            if (!enabled) {
                return true;
            }
        }
        if (windows) {
            String programGroup;
            Boolean allUsers = null;
            do {
                programGroup = console.askString(this.getMessage("SelectStartMenuFolderDesc"), this.getProgramGroupNameOverridden(context));
                if (!this.isAskChangeAllUsers()) continue;
                allUsers = console.askYesNo(this.getMessage("ProgramGroupAllUsers"), this.isAllUsersOverridden(context));
            } while (!ProgramGroupSelector.checkProgramGroup(programGroup, allUsers != null ? allUsers.booleanValue() : this.isAllUsersOverridden(context), this.showWarningIfExists, null));
            context.setVariable("sys.programGroupName", programGroup);
            if (allUsers != null) {
                context.setVariable("sys.programGroupAllUsers", allUsers);
            }
        } else {
            context.setVariable("sys.symlinkDir", console.askString(Messages.format(this.getMessage("SelectLinkDirLabel"), this.getApplicationName()), this.getLinkDirectoryOverridden(context)));
        }
        return true;
    }

    private boolean isAskChangeAllUsers() {
        return this.allowUserChangeAllUsers && (HelperCommunication.getInstance().hasElevatedHelper() || Util.hasFullAdminRights());
    }

    @Override
    public boolean handleUnattended() {
        if (!super.handleUnattended()) {
            return false;
        }
        Context context = this.getContext();
        if (this.allowUserChangeEnabled) {
            boolean enabled = this.isProgramGroupEnabledOverridden(context);
            context.setVariable("sys.programGroupDisabled", !enabled);
            if (!enabled) {
                return true;
            }
        }
        if (InstallerUtil.isWindows()) {
            context.setVariable("sys.programGroupName", this.getProgramGroupNameOverridden(context));
            context.setVariable("sys.programGroupAllUsers", this.isAllUsersOverridden(context));
        } else {
            context.setVariable("sys.symlinkDir", this.getLinkDirectoryOverridden(context));
        }
        return true;
    }

    private boolean isProgramGroupEnabledOverridden(Context context) {
        Object programGroupDisabledVariableValue = context.getVariable("sys.programGroupDisabled");
        boolean enabled = !(programGroupDisabledVariableValue instanceof Boolean) ? this.programGroupEnabled : (Boolean)programGroupDisabledVariableValue == false;
        return enabled;
    }

    private String getProgramGroupNameOverridden(Context context) {
        Object programGroupNameVariableValue = context.getVariable("sys.programGroupName");
        if (programGroupNameVariableValue == null) {
            programGroupNameVariableValue = this.getProgramGroupName();
        }
        return programGroupNameVariableValue.toString();
    }

    private boolean isAllUsersOverridden(Context context) {
        Object allUsersVariableValue = context.getVariable("sys.programGroupAllUsers");
        boolean allUsers = !(allUsersVariableValue instanceof Boolean) ? this.allUsers : (Boolean)allUsersVariableValue;
        return allUsers;
    }

    private String getLinkDirectoryOverridden(Context context) {
        Object linkDirVariableValue = context.getVariable("sys.symlinkDir");
        String linkDirectory = linkDirVariableValue == null ? this.getLinkDirectory() : linkDirVariableValue.toString();
        return linkDirectory;
    }

    private class UnixPanel
    extends SystemScreen.DefaultPanel
    implements ActionListener {
        private DirectorySelector directorySelector;
        private JCheckBox chkEnabled;

        private UnixPanel() {
            super(StandardProgramGroupScreen.this);
        }

        @Override
        public boolean next() {
            Context context = StandardProgramGroupScreen.this.getContext();
            context.setVariable("sys.symlinkDir", this.directorySelector.getSelectedFile().getPath());
            if (StandardProgramGroupScreen.this.allowUserChangeEnabled) {
                context.setVariable("sys.programGroupDisabled", !this.chkEnabled.isSelected());
            }
            return true;
        }

        @Override
        public void willActivate() {
            super.willActivate();
            Context context = StandardProgramGroupScreen.this.getContext();
            this.directorySelector.setSelectedFile(new File(StandardProgramGroupScreen.this.getLinkDirectoryOverridden(context)));
            this.chkEnabled.setSelected(StandardProgramGroupScreen.this.isProgramGroupEnabledOverridden(context));
            this.checkEnabled();
        }

        @Override
        public void activated() {
            super.activated();
            this.directorySelector.focusTextField();
        }

        @Override
        public boolean checkCompleted() {
            return (!this.chkEnabled.isSelected() || this.directorySelector.checkSelectedFile()) && super.checkCompleted();
        }

        @Override
        protected void addScreenContent(JPanel panel, GridBagConstraints gc) {
            StandardProgramGroupScreen.this.addDisplayTextArea(Messages.format(StandardProgramGroupScreen.this.getMessage("SelectLinkDirLabel"), StandardProgramGroupScreen.this.getApplicationName()), panel, gc);
            gc.insets.top = 5;
            if (StandardProgramGroupScreen.this.allowUserChangeEnabled) {
                panel.add((Component)this.chkEnabled, gc);
                ++gc.gridy;
            }
            gc.insets.bottom = 5;
            gc.weightx = 1.0;
            gc.fill = 2;
            panel.add((Component)this.directorySelector, gc);
            ++gc.gridy;
            gc.weightx = 0.0;
            gc.weighty = 0.0;
            gc.fill = 2;
            gc.anchor = 21;
            gc.weighty = 1.0;
            gc.fill = 3;
            panel.add((Component)new JPanel(), gc);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.chkEnabled) {
                this.checkEnabled();
            }
        }

        @Override
        protected void setupControls() {
            super.setupControls();
            this.directorySelector = new DirectorySelector(StandardProgramGroupScreen.this.getMessage("ReadyMemoDir").replace(':', ' ').trim(), false);
            this.directorySelector.activateNextScreenOnEnter(StandardProgramGroupScreen.this.getContext().getWizardContext());
            this.chkEnabled = new JCheckBox(StandardProgramGroupScreen.this.getMessage("SymlinksCheck"));
        }

        @Override
        protected void setupComponent() {
            super.setupComponent();
            this.checkEnabled();
        }

        @Override
        protected void setupEventHandlers() {
            super.setupEventHandlers();
            this.chkEnabled.addActionListener(this);
        }

        private void checkEnabled() {
            boolean enabled = this.chkEnabled.isSelected();
            this.directorySelector.setEnabled(enabled);
            JTextField textField = this.directorySelector.getTextField();
            if (enabled) {
                textField.selectAll();
            } else {
                textField.setSelectionStart(0);
                textField.setSelectionEnd(0);
            }
        }
    }

    private class WindowsPanel
    extends SystemScreen.DefaultPanel
    implements ActionListener {
        private ProgramGroupSelector programGroupSelector;
        private JCheckBox chkEnabled;
        private JCheckBox chkAllUsers;

        private WindowsPanel() {
            super(StandardProgramGroupScreen.this);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object source = event.getSource();
            if (source == this.chkEnabled) {
                this.checkEnabled();
            } else if (source == this.chkAllUsers) {
                this.programGroupSelector.setAllUsers(this.chkAllUsers.isSelected());
            }
        }

        @Override
        public boolean next() {
            Context context = StandardProgramGroupScreen.this.getContext();
            String selectedProgramGroup = this.programGroupSelector.getSelectedProgramGroup();
            boolean allUsers = this.chkAllUsers.isSelected();
            context.setVariable("sys.programGroupName", selectedProgramGroup);
            if (StandardProgramGroupScreen.this.allowUserChangeEnabled) {
                context.setVariable("sys.programGroupDisabled", !this.chkEnabled.isSelected());
            }
            if (StandardProgramGroupScreen.this.allowUserChangeAllUsers) {
                context.setVariable("sys.programGroupAllUsers", allUsers);
            }
            return true;
        }

        @Override
        public void willActivate() {
            super.willActivate();
            Context context = StandardProgramGroupScreen.this.getContext();
            boolean allUsers = StandardProgramGroupScreen.this.isAllUsersOverridden(context);
            this.programGroupSelector.setAllUsers(allUsers);
            this.chkAllUsers.setSelected(allUsers);
            this.programGroupSelector.setSelectedProgramGroup(StandardProgramGroupScreen.this.getProgramGroupNameOverridden(context));
            this.chkEnabled.setSelected(StandardProgramGroupScreen.this.isProgramGroupEnabledOverridden(context));
            this.checkEnabled();
        }

        @Override
        public void activated() {
            this.programGroupSelector.focusTextField();
            this.chkAllUsers.setVisible(StandardProgramGroupScreen.this.isAskChangeAllUsers());
        }

        @Override
        public boolean checkCompleted() {
            return !this.chkEnabled.isSelected() || this.programGroupSelector.checkSelectedProgramGroup();
        }

        @Override
        protected void setupControls() {
            super.setupControls();
            this.programGroupSelector = new ProgramGroupSelector(true, StandardProgramGroupScreen.this.showWarningIfExists, StandardProgramGroupScreen.this.getContext().getWizardContext());
            this.chkEnabled = new JCheckBox(StandardProgramGroupScreen.this.getMessage("ProgramGroupCheck"));
            this.chkAllUsers = new JCheckBox(StandardProgramGroupScreen.this.getMessage("ProgramGroupAllUsers"));
            this.chkAllUsers.setSelected(true);
        }

        @Override
        protected void setupComponent() {
            super.setupComponent();
            this.checkEnabled();
        }

        @Override
        protected void setupEventHandlers() {
            super.setupEventHandlers();
            this.chkEnabled.addActionListener(this);
            this.chkAllUsers.addActionListener(this);
        }

        @Override
        protected void addScreenContent(JPanel panel, GridBagConstraints gc) {
            String headerMessage = StandardProgramGroupScreen.this.getMessage("SelectStartMenuFolderLabel");
            if (headerMessage.trim().length() > 0) {
                StandardProgramGroupScreen.this.addDisplayTextArea(headerMessage, panel, gc);
            }
            gc.insets.top = 5;
            if (StandardProgramGroupScreen.this.allowUserChangeEnabled) {
                panel.add((Component)this.chkEnabled, gc);
                ++gc.gridy;
            }
            gc.weightx = 1.0;
            gc.weighty = 1.0;
            gc.fill = 1;
            panel.add((Component)this.programGroupSelector, gc);
            ++gc.gridy;
            gc.weightx = 0.0;
            gc.weighty = 0.0;
            gc.fill = 2;
            gc.anchor = 21;
            gc.insets.bottom = 5;
            panel.add((Component)this.chkAllUsers, gc);
            ++gc.gridy;
            gc.insets.top = 0;
        }

        private void checkEnabled() {
            boolean enabled = this.chkEnabled.isSelected();
            this.programGroupSelector.setEnabled(enabled);
            this.chkAllUsers.setEnabled(enabled);
        }
    }
}

