/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.misc;

import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.beans.actions.misc.OverwriteStrategy;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.helper.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;

public class LoadResponseFileAction
extends SystemInstallOrUninstallAction {
    private File file = null;
    private String[] excludedVariables;
    private OverwriteStrategy overwriteStrategy = OverwriteStrategy.NOT_COMMAND_LINE;
    private boolean registerForResponseFile = true;

    public File getFile() {
        return LoadResponseFileAction.replaceVariables(this.file);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String[] getExcludedVariables() {
        return this.excludedVariables;
    }

    public void setExcludedVariables(String[] excludedVariables) {
        this.excludedVariables = excludedVariables;
    }

    public OverwriteStrategy getOverwriteStrategy() {
        return this.overwriteStrategy;
    }

    public void setOverwriteStrategy(OverwriteStrategy overwriteStrategy) {
        this.overwriteStrategy = overwriteStrategy;
    }

    public boolean isRegisterForResponseFile() {
        return this.registerForResponseFile;
    }

    public void setRegisterForResponseFile(boolean registerForResponseFile) {
        this.registerForResponseFile = registerForResponseFile;
    }

    @Override
    public boolean execute(Context context) throws UserCanceledException {
        File responseFile = context.getDestinationFile(this.getFile());
        boolean autoResponseFile = false;
        if (responseFile == null) {
            responseFile = new File(ContextImpl.getContextInt(context).getRuntimeDirectory(), "response.varfile");
            autoResponseFile = true;
        }
        if (!responseFile.exists()) {
            Logger.getInstance().log(this, "Response file " + responseFile.getPath() + " does not exist", autoResponseFile);
            return autoResponseFile;
        }
        try {
            InstallerVariables.loadResponseFile(responseFile, true, this.excludedVariables == null ? Collections.emptyList() : Arrays.asList(this.excludedVariables), this.getOverwriteStrategy(), this.isRegisterForResponseFile());
        }
        catch (IOException e) {
            Logger.getInstance().log(e);
            return false;
        }
        return true;
    }

    @Override
    public boolean isRollbackSupported() {
        return false;
    }
}

