/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.install4j.api.context.Context;
import com.install4j.api.windows.WinUser;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.beans.actions.files.WindowsGroup;
import com.install4j.runtime.installer.AbstractRemoteCallable;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchStringAction;
import com.install4j.runtime.installer.platform.win32.ACLHandling;
import java.io.Serializable;

public abstract class AbstractAddWindowsRightsAction
extends SystemInstallOrUninstallAction {
    private WindowsGroup group = WindowsGroup.AUTHENTICATED_USERS;
    private boolean read;
    private boolean write;
    private boolean execute;
    private boolean all = true;
    private String sidOrAccountName;

    protected final String getUsedSidOrAccountName() {
        if (this.group == WindowsGroup.ORIGINAL_USER) {
            return HelperCommunication.getInstance().fetchString(ExecutionContext.UNELEVATED, new GetOriginalUserRemoteCallable());
        }
        if (this.group.getSid() != null) {
            return this.group.getSid();
        }
        return this.getSidOrAccountName();
    }

    public String getSidOrAccountName() {
        return AbstractAddWindowsRightsAction.replaceVariables(this.sidOrAccountName);
    }

    public void setSidOrAccountName(String sidOrAccountName) {
        this.sidOrAccountName = sidOrAccountName;
    }

    public WindowsGroup getGroup() {
        return this.group;
    }

    public void setGroup(WindowsGroup group) {
        this.group = group;
    }

    public boolean isRead() {
        return this.read;
    }

    public void setRead(boolean read) {
        this.read = read;
    }

    public boolean isWrite() {
        return this.write;
    }

    public void setWrite(boolean write) {
        this.write = write;
    }

    public boolean isExecute() {
        return this.execute;
    }

    public void setExecute(boolean execute) {
        this.execute = execute;
    }

    public boolean isAll() {
        return this.all;
    }

    public void setAll(boolean all) {
        this.all = all;
    }

    protected static class ACERemoteCallable
    extends AbstractRemoteCallable {
        private String objectName;
        private boolean regKey;
        private boolean read;
        private boolean write;
        private boolean execute;
        private boolean all;
        private int groupType;
        private String sidOrAccountName;

        public ACERemoteCallable(String objectName, boolean regKey, boolean read, boolean write, boolean execute, boolean all, int groupType, String sidOrAccountName) {
            this.objectName = objectName;
            this.regKey = regKey;
            this.read = read;
            this.write = write;
            this.execute = execute;
            this.all = all;
            this.groupType = groupType;
            this.sidOrAccountName = sidOrAccountName;
        }

        @Override
        public Serializable execute() {
            return Boolean.valueOf(ACLHandling.addACE(this.objectName, this.regKey, this.read, this.write, this.execute, this.all, this.groupType, this.sidOrAccountName));
        }
    }

    private static class GetOriginalUserRemoteCallable
    extends FetchStringAction {
        private GetOriginalUserRemoteCallable() {
        }

        @Override
        protected String fetchValue(Context context) throws Exception {
            return WinUser.getUserSid();
        }
    }
}

