/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.ContainerContainer;
import com.jidesoft.docking.DefaultDockingManager;
import com.jidesoft.docking.DockableHolder;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.Refocusable;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideSplitPane;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.JideFocusTracker;
import com.jidesoft.utils.SecurityUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.ref.WeakReference;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.plaf.UIResource;

public class Workspace
extends JPanel
implements DockableHolder,
Refocusable {
    private static final Logger \u0178 = Logger.getLogger(DefaultDockingManager.class.getName() + ".focus");
    private DockingManager \u0176;
    private boolean \u017a = true;
    private WeakReference<Component> \u0177;
    private WeakReference<Component> \u0179;
    private String \u017b = null;
    private boolean \u0175 = false;

    public Workspace() {
        this((DockingManager)null);
    }

    public Workspace(DockingManager dockingManager) {
        super(new BorderLayout());
        this.setDockingManager(dockingManager);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        JideFocusTracker jideFocusTracker = new JideFocusTracker(this);
        jideFocusTracker.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    Workspace.this.setLastFocusedComponent(focusEvent.getComponent());
                }
            }
        });
        this.setOpaque(false);
        this.updateUI();
    }

    public boolean isAdjustOpacityOnFly() {
        return this.\u0175;
    }

    public void setAdjustOpacityOnFly(boolean bl) {
        this.\u0175 = bl;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (!this.isOpaque() && this.isAdjustOpacityOnFly() && this.\u0102(this)) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    private boolean \u0102(Container container) {
        return container.getComponentCount() == 0 || container.getComponentCount() == 1 && container.getComponent(0) instanceof JideSplitPane && this.\u0102((Container)container.getComponent(0));
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.getBackground() == null || this.getBackground() instanceof UIResource) {
            this.setBackground(UIDefaultsLookup.getColor("Workspace.background"));
        }
    }

    public boolean isAcceptDockableFrame() {
        return this.\u017a;
    }

    public void setAcceptDockableFrame(boolean bl) {
        this.\u017a = bl;
    }

    @Override
    public boolean requestFocusInInternalWindow() {
        Component component;
        if (this.getDockingManager() == null) {
            \u0178.fine("Workspace :requestFocusInInternalWindow: returning false DockingManager == null.");
            return false;
        }
        if (this.getComponentCount() == 0) {
            return this.requestFocusInWindow();
        }
        if (this != this.getFocusedComponent() && this.isAncestorOf(component = this.getFocusedComponent()) && JideSwingUtilities.passesFocusabilityTest(component)) {
            return component.requestFocusInWindow();
        }
        component = this.getDefaultFocusComponent();
        if (this != component && this.isAncestorOf(component) && JideSwingUtilities.passesFocusabilityTest(component)) {
            return component.requestFocusInWindow();
        }
        if (!JideSwingUtilities.compositeRequestFocus(this.getComponent(0))) {
            return this.requestFocusInWindow();
        }
        return true;
    }

    public boolean requestFocusInInternalWindowNew() {
        if (this.getDockingManager() == null) {
            return false;
        }
        Component component = this.getFocusedComponent();
        boolean bl = JideSwingUtilities.passesFocusabilityTest(component);
        if (bl) {
            component.requestFocus();
            return true;
        }
        bl = JideSwingUtilities.compositeRequestFocus(this);
        return bl;
    }

    @Override
    public Component getFocusedComponent() {
        if (this.\u0179 == null) {
            return this.getDefaultFocusComponent();
        }
        return (Component)this.\u0179.get();
    }

    protected void setLastFocusedComponent(Component component) {
        if (component == this) {
            component = null;
        }
        this.\u0179 = new WeakReference<Component>(component);
    }

    @Override
    public Component getDefaultFocusComponent() {
        return this.\u0177 != null ? (Component)this.\u0177.get() : null;
    }

    @Override
    public void setDefaultFocusComponent(Component component) {
        this.\u0177 = new WeakReference<Component>(component);
    }

    @Override
    protected void addImpl(Component component, Object object, int n2) {
        if (!(component instanceof ContainerContainer)) {
            this.setAcceptDockableFrame(false);
        }
        super.addImpl(component, object, n2);
    }

    public void setDockingManager(DockingManager dockingManager) {
        this.\u0176 = dockingManager;
    }

    @Override
    public DockingManager getDockingManager() {
        return this.\u0176;
    }

    public String getLayoutConstraint() {
        if (this.\u017b == null || !"vary".equals(this.\u017b) && !"flexible".equals(this.\u017b) && !"fix".equals(this.\u017b)) {
            return SecurityUtils.getProperty("jide.workspaceConstraints", "vary");
        }
        return this.\u017b;
    }

    public void setLayoutConstraint(String string) {
        this.\u017b = string;
    }
}

