/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc.logger;

import com.nuodb.jdbc.logger.Level;
import com.nuodb.jdbc.logger.Logger;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.spi.LocationAwareLogger;

public class Slf4jLogger
implements Logger {
    private static Map<Level, Integer> LEVELS = new HashMap<Level, Integer>();
    private static final String CALLER_CLASS_NAME;
    private org.slf4j.Logger logger;
    private final String loggerName;
    private String callerClassName;
    private final boolean instanceofLAL;

    public Slf4jLogger(org.slf4j.Logger logger) {
        this(logger, CALLER_CLASS_NAME);
    }

    public Slf4jLogger(org.slf4j.Logger logger, String callerClassName) {
        this.logger = logger;
        this.loggerName = logger.getName();
        this.callerClassName = callerClassName;
        this.instanceofLAL = logger instanceof LocationAwareLogger;
    }

    @Override
    public String getName() {
        return this.loggerName;
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public boolean isLevelEnabled(Level level) {
        switch (level) {
            case TRACE: {
                return this.isTraceEnabled();
            }
            case DEBUG: {
                return this.isDebugEnabled();
            }
            case INFO: {
                return this.isInfoEnabled();
            }
            case WARN: {
                return this.isWarnEnabled();
            }
            case ERROR: {
                return this.isErrorEnabled();
            }
        }
        return false;
    }

    @Override
    public void error(String message) {
        if (!this.isErrorEnabled()) {
            return;
        }
        if (this.instanceofLAL) {
            ((LocationAwareLogger)this.logger).log(null, this.callerClassName, 40, message, null, null);
        } else {
            this.logger.error(message);
        }
    }

    @Override
    public void error(String message, Throwable failure) {
        if (!this.isErrorEnabled()) {
            return;
        }
        if (this.instanceofLAL) {
            ((LocationAwareLogger)this.logger).log(null, this.callerClassName, 40, message, null, failure);
        } else {
            this.logger.error(message);
        }
    }

    @Override
    public void warn(String message) {
        if (!this.isWarnEnabled()) {
            return;
        }
        if (this.instanceofLAL) {
            ((LocationAwareLogger)this.logger).log(null, this.callerClassName, 30, message, null, null);
        } else {
            this.logger.warn(message);
        }
    }

    @Override
    public void warn(String message, Throwable failure) {
        if (!this.isWarnEnabled()) {
            return;
        }
        if (this.instanceofLAL) {
            ((LocationAwareLogger)this.logger).log(null, this.callerClassName, 30, message, null, failure);
        } else {
            this.logger.warn(message);
        }
    }

    @Override
    public void info(String message) {
        if (!this.isInfoEnabled()) {
            return;
        }
        if (this.instanceofLAL) {
            ((LocationAwareLogger)this.logger).log(null, this.callerClassName, 20, message, null, null);
        } else {
            this.logger.info(message);
        }
    }

    @Override
    public void info(String message, Throwable failure) {
        if (!this.isInfoEnabled()) {
            return;
        }
        if (this.instanceofLAL) {
            ((LocationAwareLogger)this.logger).log(null, this.callerClassName, 20, message, null, failure);
        } else {
            this.logger.info(message);
        }
    }

    @Override
    public void debug(String message) {
        if (!this.isDebugEnabled()) {
            return;
        }
        if (this.instanceofLAL) {
            ((LocationAwareLogger)this.logger).log(null, this.callerClassName, 10, message, null, null);
        } else {
            this.logger.debug(message);
        }
    }

    @Override
    public void debug(String message, Throwable failure) {
        if (!this.isDebugEnabled()) {
            return;
        }
        if (this.instanceofLAL) {
            ((LocationAwareLogger)this.logger).log(null, this.callerClassName, 10, message, null, failure);
        } else {
            this.logger.debug(message);
        }
    }

    @Override
    public void trace(String message) {
        if (!this.isTraceEnabled()) {
            return;
        }
        if (this.instanceofLAL) {
            ((LocationAwareLogger)this.logger).log(null, this.callerClassName, 0, message, null, null);
        } else {
            this.logger.trace(message);
        }
    }

    @Override
    public void trace(String message, Throwable failure) {
        if (!this.isTraceEnabled()) {
            return;
        }
        if (this.instanceofLAL) {
            ((LocationAwareLogger)this.logger).log(null, this.callerClassName, 0, message, null, failure);
        } else {
            this.logger.trace(message);
        }
    }

    @Override
    public void log(Level level, String message, Throwable failure) {
        if (!this.isLevelEnabled(level)) {
            return;
        }
        if (this.instanceofLAL) {
            ((LocationAwareLogger)this.logger).log(null, this.callerClassName, LEVELS.get((Object)level), message, null, failure);
        } else {
            switch (level) {
                case TRACE: {
                    this.logger.trace(message, failure);
                    break;
                }
                case DEBUG: {
                    this.logger.debug(message, failure);
                    break;
                }
                case INFO: {
                    this.logger.info(message, failure);
                    break;
                }
                case WARN: {
                    this.logger.warn(message, failure);
                    break;
                }
                case ERROR: {
                    this.logger.error(message, failure);
                }
            }
        }
    }

    @Override
    public void log(Level level, String callerClassName, String message, Throwable failure) {
        if (!this.isLevelEnabled(level)) {
            return;
        }
        if (this.instanceofLAL) {
            ((LocationAwareLogger)this.logger).log(null, callerClassName, LEVELS.get((Object)level), message, null, failure);
        } else {
            switch (level) {
                case TRACE: {
                    this.logger.trace(message, failure);
                    break;
                }
                case DEBUG: {
                    this.logger.debug(message, failure);
                    break;
                }
                case INFO: {
                    this.logger.info(message, failure);
                    break;
                }
                case WARN: {
                    this.logger.warn(message, failure);
                    break;
                }
                case ERROR: {
                    this.logger.error(message, failure);
                }
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Slf4jLogger that = (Slf4jLogger)o;
        return !(this.loggerName != null ? !this.loggerName.equals(that.loggerName) : that.loggerName != null);
    }

    public int hashCode() {
        return this.loggerName != null ? this.loggerName.hashCode() : 0;
    }

    public String toString() {
        return "Slf4Logger{loggerName='" + this.loggerName + "'}";
    }

    static {
        LEVELS.put(Level.ERROR, 40);
        LEVELS.put(Level.WARN, 30);
        LEVELS.put(Level.INFO, 20);
        LEVELS.put(Level.DEBUG, 10);
        LEVELS.put(Level.TRACE, 0);
        CALLER_CLASS_NAME = Slf4jLogger.class.getName();
    }
}

