/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.net;

import com.nuodb.impl.net.CryptoInputStream;
import com.nuodb.impl.net.CryptoOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;

public class CryptoSocket
extends Socket {
    InputStream inputStream;
    OutputStream outputStream;

    public CryptoSocket() {
    }

    public CryptoSocket(String address, int port) throws IOException {
        this(CryptoSocket.generateSocketAddr(address, port), 0);
    }

    public CryptoSocket(InputStream input, OutputStream output) {
        this.inputStream = input;
        this.outputStream = output;
    }

    public CryptoSocket(InetAddress address, int port, int timeout) throws IOException {
        this(new InetSocketAddress(address, port), timeout);
    }

    public CryptoSocket(InetSocketAddress socketAddr, int timeout) throws IOException {
        try {
            this.connect(socketAddr, timeout);
        }
        catch (IOException exception) {
            throw new IOException(exception.getMessage() + ", " + socketAddr.toString());
        }
    }

    private static InetSocketAddress generateSocketAddr(String address, int port) {
        int pos = address.indexOf(58);
        if (pos == -1) {
            return new InetSocketAddress(address, port);
        }
        return new InetSocketAddress(address.substring(0, pos), (int)Integer.valueOf(address.substring(pos + 1)));
    }

    @Override
    public CryptoInputStream getInputStream() throws IOException {
        if (this.inputStream != null) {
            return new CryptoInputStream(this.inputStream);
        }
        CryptoInputStream stream = new CryptoInputStream(super.getInputStream());
        return stream;
    }

    @Override
    public CryptoOutputStream getOutputStream() throws IOException {
        if (this.outputStream != null) {
            return new CryptoOutputStream(this.outputStream);
        }
        CryptoOutputStream stream = new CryptoOutputStream(super.getOutputStream());
        return stream;
    }
}

