/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.value;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.dataengine.utilities.TypeMetadata;
import com.amazon.dsi.dataengine.utilities.TypeUtilities;
import com.amazon.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.amazon.sqlengine.executor.etree.ETDataRequest;
import com.amazon.sqlengine.executor.etree.IETNode;
import com.amazon.sqlengine.executor.etree.IETNodeVisitor;
import com.amazon.sqlengine.executor.etree.util.DataRetrievalUtil;
import com.amazon.sqlengine.executor.etree.value.ETValueExpr;
import com.amazon.support.exceptions.ErrorException;

public class ETParameter
extends ETValueExpr {
    private DataWrapper m_inputData;
    private boolean m_isOpened;
    private short m_type;

    public ETParameter(IColumn iColumn) {
        this.m_type = iColumn.getTypeMetadata().getType();
        this.m_inputData = null;
        this.m_isOpened = false;
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public void close(boolean bl) {
        this.m_isOpened = false;
    }

    @Override
    public boolean isOpen() {
        return this.m_isOpened;
    }

    public void setInputData(DataWrapper dataWrapper) {
        if (this.isOpen()) {
            throw new IllegalStateException("Changing parameter value during execution.");
        }
        if (dataWrapper.getType() != this.m_type) {
            throw new IllegalArgumentException(String.format("Incompitable type. required : %s, set : %s", TypeUtilities.sqlTypeToString(this.m_type), TypeUtilities.sqlTypeToString((short)dataWrapper.getType())));
        }
        this.m_inputData = dataWrapper;
    }

    @Override
    public int getNumChildren() {
        return 0;
    }

    @Override
    public void open() {
        this.m_isOpened = true;
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        if (this.m_inputData == null) {
            throw new IllegalStateException("Unresolved parameter.");
        }
        ISqlDataWrapper iSqlDataWrapper = eTDataRequest.getData();
        iSqlDataWrapper.setValue(this.m_inputData);
        if (iSqlDataWrapper.isNull()) {
            return false;
        }
        TypeMetadata typeMetadata = eTDataRequest.getColumn().getTypeMetadata();
        if (typeMetadata.isCharacterType()) {
            return DataRetrievalUtil.retrieveCharData(iSqlDataWrapper, eTDataRequest.getOffset(), eTDataRequest.getMaxSize(), eTDataRequest.getColumn().getColumnLength(), this.getWarningListener());
        }
        if (typeMetadata.isBinaryType()) {
            return DataRetrievalUtil.retrieveBinaryData(iSqlDataWrapper, eTDataRequest.getOffset(), eTDataRequest.getMaxSize(), eTDataRequest.getColumn().getColumnLength(), this.getWarningListener());
        }
        return false;
    }

    @Override
    protected IETNode getChild(int n) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException();
    }
}

