/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.dsiext.dataengine.metadata;

import com.amazon.dsi.dataengine.interfaces.IMetadataSource;
import com.amazon.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.amazon.dsi.dataengine.utilities.TypeUtilities;
import com.amazon.sqlengine.dsiext.dataengine.IMetadataHelper;
import com.amazon.sqlengine.dsiext.dataengine.Identifier;
import java.util.Map;

abstract class DSIExtPartiallyFilteredMetadataSource
implements IMetadataSource {
    private final String m_catalogRestriction;
    private final String m_schemaRestriction;
    private final String m_procedureOrTableRestriction;
    private final MetadataSourceColumnTag m_procedureOrTableColumnTag;
    private final IMetadataHelper m_metadataHelper;
    private final boolean m_isODBC2;

    protected DSIExtPartiallyFilteredMetadataSource(Map<MetadataSourceColumnTag, String> map, IMetadataHelper iMetadataHelper, MetadataSourceColumnTag metadataSourceColumnTag, boolean bl) {
        if (metadataSourceColumnTag != MetadataSourceColumnTag.TABLE_NAME && metadataSourceColumnTag != MetadataSourceColumnTag.PROCEDURE_NAME) {
            throw new IllegalArgumentException("Invalid procedure or table tag : " + metadataSourceColumnTag.name());
        }
        this.m_catalogRestriction = map.get((Object)MetadataSourceColumnTag.CATALOG_NAME);
        this.m_schemaRestriction = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        this.m_procedureOrTableRestriction = map.get((Object)metadataSourceColumnTag);
        this.m_procedureOrTableColumnTag = metadataSourceColumnTag;
        this.m_metadataHelper = iMetadataHelper;
        this.m_isODBC2 = bl;
    }

    protected Identifier getNextProcedureOrTable() {
        Identifier identifier;
        while ((identifier = this.getNextIdentifier()) != null) {
            if (this.m_catalogRestriction != null && !this.m_catalogRestriction.equalsIgnoreCase(identifier.getCatalog()) || this.m_schemaRestriction != null && !this.m_schemaRestriction.equalsIgnoreCase(identifier.getSchema()) || this.m_procedureOrTableRestriction != null && !this.m_procedureOrTableRestriction.equalsIgnoreCase(identifier.getName())) continue;
            return identifier;
        }
        return null;
    }

    protected final int NormalizeDateTimeTypeForODBC2(int n) {
        return TypeUtilities.NormalizeDateTimeTypeForODBC2(n, this.m_isODBC2);
    }

    private Identifier getNextIdentifier() {
        Identifier identifier = new Identifier();
        if (this.m_procedureOrTableColumnTag == MetadataSourceColumnTag.TABLE_NAME) {
            return this.m_metadataHelper.getNextTable(identifier) ? identifier : null;
        }
        return this.m_metadataHelper.getNextProcedure(identifier) ? identifier : null;
    }
}

