/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.aeprocessor.aetree.value;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.dataengine.utilities.ColumnMetadata;
import com.amazon.sqlengine.aeprocessor.aetree.IAENode;
import com.amazon.sqlengine.aeprocessor.aetree.IAENodeVisitor;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.amazon.sqlengine.dsiext.dataengine.ICoercionHandler;
import com.amazon.sqlengine.dsiext.dataengine.SqlDataEngineContext;
import com.amazon.sqlengine.parser.type.PTLiteralType;
import com.amazon.support.exceptions.ErrorException;
import java.util.AbstractList;
import java.util.Iterator;

public class AELiteral
extends AEValueExpr {
    private String m_literalStr;
    private PTLiteralType m_literalType;
    private IColumn m_metaData;
    private boolean m_isSigned;

    public AELiteral(String string, PTLiteralType pTLiteralType, SqlDataEngineContext sqlDataEngineContext) throws ErrorException {
        this(string, pTLiteralType, false, sqlDataEngineContext);
    }

    public AELiteral(String string, PTLiteralType pTLiteralType, boolean bl, SqlDataEngineContext sqlDataEngineContext) throws ErrorException {
        this.m_literalStr = pTLiteralType == PTLiteralType.CHARSTR ? string : string.trim();
        this.m_literalType = pTLiteralType;
        this.m_isSigned = bl;
        IColumn iColumn = this.getLiteralMetadata(this.m_literalStr, pTLiteralType, bl, sqlDataEngineContext);
        if ("".equals(iColumn.getName())) {
            ColumnMetadata columnMetadata = ColumnMetadata.copyOf(iColumn);
            columnMetadata.setName(null);
            iColumn = columnMetadata;
        }
        this.m_metaData = iColumn;
    }

    public AELiteral(AELiteral aELiteral) {
        super(aELiteral);
        this.m_literalStr = aELiteral.m_literalStr;
        this.m_literalType = aELiteral.m_literalType;
        this.m_isSigned = aELiteral.m_isSigned;
        this.m_metaData = ColumnMetadata.copyOf(aELiteral.m_metaData);
    }

    public String getStringValue() {
        return this.m_literalStr;
    }

    public PTLiteralType getLiteralType() {
        return this.m_literalType;
    }

    @Override
    public IColumn getColumn() {
        return this.m_metaData;
    }

    @Override
    public <T> T acceptVisitor(IAENodeVisitor<T> iAENodeVisitor) throws ErrorException {
        return iAENodeVisitor.visit(this);
    }

    @Override
    public AELiteral copy() {
        return new AELiteral(this);
    }

    public Iterator<IAENode> getChildItr() {
        AbstractList<IAENode> abstractList = new AbstractList<IAENode>(){

            @Override
            public IAENode get(int n) {
                throw new IndexOutOfBoundsException("Child index out of bound for AELiteral");
            }

            @Override
            public int size() {
                return 0;
            }
        };
        return abstractList.iterator();
    }

    @Override
    public String getLogString() {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append(this.getClass().getSimpleName() + ": " + this.m_literalStr + ": ");
        switch (this.m_literalType) {
            case TIMESTAMP: {
                stringBuilder.append("Date Time Literal");
                break;
            }
            case DATE: {
                stringBuilder.append("Date Literal");
                break;
            }
            case TIME: {
                stringBuilder.append("Time Literal");
                break;
            }
            case APPROXNUM: {
                stringBuilder.append("Approximate Numeric Literal");
                break;
            }
            case DECIMAL: {
                stringBuilder.append("Decimal Numeric Literal");
                break;
            }
            case CHARSTR: {
                stringBuilder.append("Character String Literal");
                break;
            }
            case USINT: {
                if (this.m_isSigned) {
                    stringBuilder.append("Signed Integer Literal");
                    break;
                }
                stringBuilder.append("Unsigned Integer Literal");
                break;
            }
            case DATATYPE: {
                stringBuilder.append("SQL Data Type Keyword Literal");
                break;
            }
            default: {
                stringBuilder.append(this.m_literalType.name());
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public int getNumChildren() {
        return 0;
    }

    @Override
    public boolean isEquivalent(IAENode iAENode) {
        if (iAENode == this) {
            return true;
        }
        if (!(iAENode instanceof AELiteral)) {
            return false;
        }
        AELiteral aELiteral = (AELiteral)iAENode;
        return this.m_isSigned == aELiteral.m_isSigned && this.m_literalStr.equals(aELiteral.m_literalStr) && this.m_literalType == aELiteral.m_literalType && this.m_metaData.equals(aELiteral.m_metaData);
    }

    private IColumn getLiteralMetadata(String string, PTLiteralType pTLiteralType, boolean bl, SqlDataEngineContext sqlDataEngineContext) throws ErrorException {
        ICoercionHandler iCoercionHandler = sqlDataEngineContext.getCoercionHandler();
        switch (pTLiteralType) {
            case DATATYPE: {
                return iCoercionHandler.determineLiteralColumn(string, ICoercionHandler.LiteralType.DATATYPE);
            }
            case CHARSTR: {
                return iCoercionHandler.determineLiteralColumn(string, ICoercionHandler.LiteralType.CHAR);
            }
            case USINT: {
                return iCoercionHandler.determineLiteralColumn(string, ICoercionHandler.LiteralType.UNSIGNED_INT);
            }
            case SINT: {
                return iCoercionHandler.determineLiteralColumn(string, ICoercionHandler.LiteralType.SIGNED_INT);
            }
            case APPROXNUM: {
                return iCoercionHandler.determineLiteralColumn(string, ICoercionHandler.LiteralType.APROX_NUM);
            }
            case DECIMAL: {
                return iCoercionHandler.determineLiteralColumn(string, ICoercionHandler.LiteralType.EXACT_NUM);
            }
            case DATE: {
                return iCoercionHandler.determineLiteralColumn(string, ICoercionHandler.LiteralType.DATE);
            }
            case TIME: {
                return iCoercionHandler.determineLiteralColumn(string, ICoercionHandler.LiteralType.TIME);
            }
            case TIMESTAMP: {
                return iCoercionHandler.determineLiteralColumn(string, ICoercionHandler.LiteralType.TIMESTAMP);
            }
        }
        throw new IllegalArgumentException("Unrecognized literal type.");
    }

    @Override
    public void updateColumn() throws ErrorException {
    }
}

