/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.aeprocessor.aebuilder.value;

import com.amazon.sqlengine.aeprocessor.aebuilder.AEBuilderBase;
import com.amazon.sqlengine.aeprocessor.aebuilder.AEBuilderCheck;
import com.amazon.sqlengine.aeprocessor.aebuilder.AEQueryScope;
import com.amazon.sqlengine.aeprocessor.aebuilder.value.AEScalarFnMetadataFactory;
import com.amazon.sqlengine.aeprocessor.aebuilder.value.AEValueExprBuilder;
import com.amazon.sqlengine.aeprocessor.aetree.ScalarFunctionID;
import com.amazon.sqlengine.aeprocessor.aetree.value.AECustomScalarFn;
import com.amazon.sqlengine.aeprocessor.aetree.value.AELiteral;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEScalarFn;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.amazon.sqlengine.aeprocessor.metadatautil.AECoercionColumnInfo;
import com.amazon.sqlengine.dsiext.dataengine.CustomScalarFunction;
import com.amazon.sqlengine.dsiext.dataengine.SqlDataEngine;
import com.amazon.sqlengine.dsiext.dataengine.SqlDataEngineContext;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.sqlengine.parser.parsetree.IPTNode;
import com.amazon.sqlengine.parser.parsetree.PTIdentifierNode;
import com.amazon.sqlengine.parser.parsetree.PTListNode;
import com.amazon.sqlengine.parser.parsetree.PTLiteralNode;
import com.amazon.sqlengine.parser.parsetree.PTNonterminalNode;
import com.amazon.sqlengine.parser.type.PTListType;
import com.amazon.sqlengine.parser.type.PTLiteralType;
import com.amazon.sqlengine.parser.type.PTNonterminalType;
import com.amazon.sqlengine.parser.type.PTPositionalType;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class AEScalarFnBuilder
extends AEBuilderBase<AEValueExpr> {
    private static final Map<String, Map<Integer, ScalarFunctionID>> SCALAR_FN_LOOKUP;
    private SqlDataEngine m_dataEngine;

    protected AEScalarFnBuilder(AEQueryScope aEQueryScope) {
        super(aEQueryScope);
        this.m_dataEngine = aEQueryScope.getDataEngine();
    }

    @Override
    public AEValueExpr visit(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        AEBuilderCheck.checkThat(pTNonterminalNode, AEBuilderCheck.is(AEBuilderCheck.nonTerminal(PTNonterminalType.FUNC)).withExactChildren(PTPositionalType.NAME, AEBuilderCheck.identifier(), PTPositionalType.PARAM_LIST, AEBuilderCheck.optionalList(PTListType.PARAMETER_LIST)));
        String string = ((PTIdentifierNode)pTNonterminalNode.getChild(PTPositionalType.NAME)).getIdentifier();
        IPTNode iPTNode = pTNonterminalNode.getChild(PTPositionalType.PARAM_LIST);
        PTListNode pTListNode = iPTNode.isEmptyNode() ? new PTListNode(PTListType.PARAMETER_LIST) : (PTListNode)iPTNode;
        CustomScalarFunction customScalarFunction = this.m_dataEngine.openScalarFunction(string, pTListNode.numChildren());
        if (null != customScalarFunction) {
            return this.buildCustomScalarFn(pTListNode, customScalarFunction);
        }
        Map<Integer, ScalarFunctionID> map = SCALAR_FN_LOOKUP.get(string);
        if (null == map) {
            throw SQLEngineExceptionFactory.invalidScalarFnNameException(string);
        }
        ScalarFunctionID scalarFunctionID = map.get(pTListNode.numChildren());
        if (null == scalarFunctionID) {
            throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
        }
        return this.buildScalarFn(string, scalarFunctionID, pTListNode);
    }

    private AECustomScalarFn buildCustomScalarFn(PTListNode pTListNode, CustomScalarFunction customScalarFunction) throws ErrorException {
        AEValueExprList aEValueExprList = new AEValueExprList();
        if (0 < pTListNode.numChildren()) {
            AEValueExprBuilder aEValueExprBuilder = new AEValueExprBuilder(this.getQueryScope());
            for (IPTNode iPTNode : pTListNode.getImmutableChildList()) {
                aEValueExprList.addNode(aEValueExprBuilder.build(iPTNode));
            }
        }
        return new AECustomScalarFn(customScalarFunction, aEValueExprList);
    }

    private AEScalarFn buildScalarFn(String string, ScalarFunctionID scalarFunctionID, PTListNode pTListNode) throws ErrorException {
        Object object;
        Object object3;
        Object object4;
        AEValueExprList aEValueExprList = new AEValueExprList();
        ArrayList<AECoercionColumnInfo> arrayList = new ArrayList<AECoercionColumnInfo>();
        if (ScalarFunctionID.CONVERT == scalarFunctionID || ScalarFunctionID.CAST == scalarFunctionID) {
            if (2 != pTListNode.numChildren()) {
                throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
            }
            object4 = new AEValueExprBuilder(this.getQueryScope());
            object3 = (AEValueExpr)((AEBuilderBase)object4).build(pTListNode.getChild(0));
            aEValueExprList.addNode(object3);
            arrayList.add(new AECoercionColumnInfo((AEValueExpr)object3));
            IPTNode object22 = pTListNode.getChild(1);
            if (object22 instanceof PTLiteralNode) {
                object3 = (AEValueExpr)((AEBuilderBase)object4).build(object22);
            } else if (object22 instanceof PTIdentifierNode) {
                object3 = (AEValueExpr)((AEBuilderBase)object4).build(new PTLiteralNode(PTLiteralType.CHARSTR, ((PTIdentifierNode)object22).getIdentifier()));
            } else if (object22 instanceof PTNonterminalNode && PTNonterminalType.COLUMN_REFERENCE == ((PTNonterminalNode)object22).getNonterminalType()) {
                object = (PTNonterminalNode)object22;
                object3 = (AEValueExpr)((AEBuilderBase)object4).build(new PTLiteralNode(PTLiteralType.CHARSTR, ((PTIdentifierNode)((PTNonterminalNode)object).getChild(PTPositionalType.COLUMN_NAME)).getIdentifier()));
            } else {
                throw ScalarFunctionID.CONVERT == scalarFunctionID ? SQLEngineExceptionFactory.invalidSecondArgumentToConvertException() : SQLEngineExceptionFactory.invalidSecondArgumentToCastException();
            }
            aEValueExprList.addNode(object3);
            arrayList.add(new AECoercionColumnInfo((AEValueExpr)object3));
        } else if (ScalarFunctionID.USER == scalarFunctionID || ScalarFunctionID.DATABASE == scalarFunctionID) {
            assert (0 == pTListNode.numChildren());
            object4 = this.getQueryScope().getDataEngine().getContext();
            object3 = ScalarFunctionID.USER == scalarFunctionID ? ((SqlDataEngineContext)object4).getConnProperty(139).getString() : ((SqlDataEngineContext)object4).getConnProperty(22).getString();
            AELiteral aELiteral = new AELiteral((String)object3, PTLiteralType.CHARSTR, false, (SqlDataEngineContext)object4);
            aELiteral.setParent(aEValueExprList);
            aEValueExprList.addNode(aELiteral);
            arrayList.add(new AECoercionColumnInfo(aELiteral));
        } else if (0 < pTListNode.numChildren()) {
            object4 = new AEValueExprBuilder(this.getQueryScope());
            for (IPTNode iPTNode : pTListNode.getImmutableChildList()) {
                object = (AEValueExpr)((AEBuilderBase)object4).build(iPTNode);
                aEValueExprList.addNode(object);
                arrayList.add(new AECoercionColumnInfo((AEValueExpr)object));
            }
        }
        object4 = AEScalarFnMetadataFactory.getInstance();
        object3 = ((AEScalarFnMetadataFactory)object4).createMetadata(this.m_dataEngine.getContext(), scalarFunctionID, string, arrayList);
        AEScalarFn aEScalarFn = new AEScalarFn(string, scalarFunctionID, ((AEScalarFnMetadataFactory.ScalarFnMetadata)object3).getColumnMetadata(), aEValueExprList, ((AEScalarFnMetadataFactory.ScalarFnMetadata)object3).getExpectedArgumentMetadata(), (AEScalarFnMetadataFactory)object4, this.m_dataEngine.getContext());
        arrayList.clear();
        object = aEScalarFn.getArguments().getChildItr();
        while (object.hasNext()) {
            arrayList.add(new AECoercionColumnInfo((AEValueExpr)object.next()));
        }
        ((AEScalarFnMetadataFactory)object4).validateMetadata(this.m_dataEngine.getContext(), scalarFunctionID, string, arrayList);
        return aEScalarFn;
    }

    static {
        TreeMap<String, Map<Integer, ScalarFunctionID>> treeMap = new TreeMap<String, Map<Integer, ScalarFunctionID>>(String.CASE_INSENSITIVE_ORDER);
        for (ScalarFunctionID scalarFunctionID : ScalarFunctionID.values()) {
            Map<Integer, ScalarFunctionID> map = treeMap.get(scalarFunctionID.getName());
            if (null == map) {
                map = new HashMap<Integer, ScalarFunctionID>();
                treeMap.put(scalarFunctionID.getName(), map);
            }
            map.put(scalarFunctionID.getArguments().size(), scalarFunctionID);
        }
        SCALAR_FN_LOOKUP = treeMap;
    }
}

