/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.outbound;

import com.amazon.jdbc.communications.interfaces.AbstractOutboundMessage;
import com.amazon.jdbc.utils.DataTypeUtilities;
import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.core.IPGLogger;
import java.nio.ByteBuffer;

public class Startup
extends AbstractOutboundMessage
implements PGConstants {
    private static final byte PROTOCOL_MAJOR_VERSION_3 = 3;
    private static final byte PROTOCOL_MINOR_VERSION_0 = 0;
    private static final byte[] FIELD_USER = PGDataTypeUtilities.toUTF8ByteArray("user");
    private static final byte[] FIELD_DATABASE = PGDataTypeUtilities.toUTF8ByteArray("database");
    private static final byte[] FIELD_EXTRA_FLOAT_DIGITS = PGDataTypeUtilities.toUTF8ByteArray("extra_float_digits");
    private static final byte[] FIELD_EXTRA_FLOAT_DIGITS_DEFAULT_VALUE = PGDataTypeUtilities.toUTF8ByteArray("2");
    private final byte[] user;
    private final byte[] database;

    public Startup(String user, String database, IPGLogger logger) {
        this.user = DataTypeUtilities.toUTF8ByteArray(user);
        this.database = DataTypeUtilities.toUTF8ByteArray(database);
        if (logger.isExternalLoggerEnabled()) {
            this.logMessageContent(logger);
        }
    }

    @Override
    public void serialize(ByteBuffer buffer, byte[] sizebytes) {
        byte[] protocolVersion = new byte[]{0, 3, 0, 0};
        buffer.put(sizebytes);
        buffer.put(protocolVersion);
        this.addField(buffer, FIELD_USER, this.user);
        this.addField(buffer, FIELD_DATABASE, this.database);
        this.addField(buffer, FIELD_EXTRA_FLOAT_DIGITS, FIELD_EXTRA_FLOAT_DIGITS_DEFAULT_VALUE);
        buffer.put(TERMINATOR);
    }

    @Override
    public int getSize() {
        return 8 + FIELD_USER.length + 1 + this.user.length + 1 + FIELD_DATABASE.length + 1 + this.database.length + 1 + FIELD_EXTRA_FLOAT_DIGITS.length + 1 + FIELD_EXTRA_FLOAT_DIGITS_DEFAULT_VALUE.length + 1 + 1;
    }

    public void logMessageContent(IPGLogger logger) {
        String message = "=>FE StartupMessage(user=" + this.user + ", database=" + this.database + ")";
        logger.logDebugExternal(message);
    }
}

