/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.outbound;

import com.amazon.jdbc.communications.interfaces.AbstractOutboundMessage;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.core.IPGLogger;
import java.nio.ByteBuffer;

public class Bind
extends AbstractOutboundMessage
implements PGConstants {
    private final byte[] m_portalName;
    private final byte[] m_preparedStatementName;
    private final short[] m_formatCodes;
    private final byte[][] m_parameterValues;
    private final short[] m_resultColumnFormatCodes;

    public Bind(byte[] portalName, byte[] preparedStatementName, short[] formatCodes, byte[][] parameterValues, short[] resultColumnFormatCodes, IPGLogger logger) {
        this.m_portalName = portalName;
        this.m_preparedStatementName = preparedStatementName;
        this.m_formatCodes = formatCodes;
        this.m_parameterValues = parameterValues;
        this.m_resultColumnFormatCodes = resultColumnFormatCodes;
        if (logger.isExternalLoggerEnabled()) {
            this.logMessageContent(logger);
        }
    }

    @Override
    public void serialize(ByteBuffer buffer, byte[] sizebytes) {
        buffer.put((byte)66);
        buffer.put(sizebytes);
        if (null != this.m_portalName) {
            buffer.put(this.m_portalName);
        }
        buffer.put(TERMINATOR);
        if (null != this.m_preparedStatementName) {
            buffer.put(this.m_preparedStatementName);
        }
        buffer.put(TERMINATOR);
        if (null != this.m_formatCodes) {
            buffer.putShort((short)this.m_formatCodes.length);
            for (short i : this.m_formatCodes) {
                buffer.putShort(i);
            }
        } else {
            buffer.putShort((short)0);
        }
        if (null != this.m_parameterValues) {
            buffer.putShort((short)this.m_parameterValues.length);
            for (byte[] value : this.m_parameterValues) {
                if (null != value) {
                    buffer.putInt(value.length);
                    buffer.put(value);
                    continue;
                }
                buffer.putInt(-1);
            }
        } else {
            buffer.putShort((short)0);
        }
        if (null != this.m_resultColumnFormatCodes) {
            buffer.putShort((short)this.m_resultColumnFormatCodes.length);
            for (short i : this.m_resultColumnFormatCodes) {
                buffer.putShort(i);
            }
        } else {
            buffer.putShort((short)0);
        }
    }

    @Override
    public int getSize() {
        int size = 4 + (this.m_portalName != null ? this.m_portalName.length : 0) + 1 + (this.m_preparedStatementName != null ? this.m_preparedStatementName.length : 0) + 1 + 2 + (this.m_formatCodes != null ? this.m_formatCodes.length * 2 : 0) + 2;
        if (null != this.m_parameterValues) {
            size += 4 * this.m_parameterValues.length;
            for (byte[] value : this.m_parameterValues) {
                if (null == value) continue;
                size += value.length;
            }
        }
        return size += 2 + (this.m_resultColumnFormatCodes != null ? this.m_resultColumnFormatCodes.length * 2 : 0);
    }

    public void logMessageContent(IPGLogger logger) {
        String statementName = null;
        if (null != this.m_preparedStatementName) {
            statementName = new String(this.m_preparedStatementName);
        }
        String portal = null;
        if (null != this.m_portalName) {
            portal = new String(this.m_portalName);
        }
        String message = "=>FE Bind(stmt=" + statementName + ",portal=" + portal + ")";
        logger.logDebugExternal(message);
    }
}

