/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.inbound;

import com.amazon.jdbc.communications.interfaces.AbstractInboundMessage;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.core.IPGLogger;
import java.nio.ByteBuffer;

public class FieldDescription
extends AbstractInboundMessage
implements PGConstants {
    private final byte[] m_fieldName;
    private final short m_columnAttributeNumber;
    private final int m_dataTypeObjectID;
    private final int m_dataTypeSize;
    private final int m_dataTypeModifier;
    private final short m_formatCode;
    private final String m_tableObjectIDString;
    private final String m_columnAttributeNumberString;

    public FieldDescription(ByteBuffer buffer, IPGLogger logger) {
        this.m_fieldName = this.getNullTerminatedField(buffer);
        int tableOID = buffer.getInt();
        this.m_tableObjectIDString = Integer.toString(tableOID);
        this.m_columnAttributeNumber = buffer.getShort();
        this.m_columnAttributeNumberString = Short.toString(this.m_columnAttributeNumber);
        this.m_dataTypeObjectID = buffer.getInt();
        int dataTypeSize = buffer.getShort();
        this.m_dataTypeModifier = buffer.getInt();
        this.m_formatCode = buffer.getShort();
        int typeModifier = this.getDataTypeModifier();
        if (-1 == dataTypeSize) {
            if (typeModifier > 0) {
                dataTypeSize = typeModifier;
                if (FieldDescription.isVariableLengthType(this.m_dataTypeObjectID)) {
                    dataTypeSize -= 4;
                }
            } else {
                dataTypeSize = 0;
            }
        }
        this.m_dataTypeSize = dataTypeSize;
        if (logger.isExternalLoggerEnabled()) {
            this.logMessageContent(logger);
        }
    }

    public byte[] getFieldName() {
        return this.m_fieldName;
    }

    public String getTableObjectIDString() {
        return this.m_tableObjectIDString;
    }

    public short getColumnAttributeNumber() {
        return this.m_columnAttributeNumber;
    }

    public String getColumnAttributeNumberString() {
        return this.m_columnAttributeNumberString;
    }

    public int getDataTypeObjectID() {
        return this.m_dataTypeObjectID;
    }

    public int getDataTypeSize() {
        return this.m_dataTypeSize;
    }

    public int getDataTypeModifier() {
        return this.m_dataTypeModifier;
    }

    public short getFormatCode() {
        return this.m_formatCode;
    }

    public void logMessageContent(IPGLogger logger) {
        String formatCode = this.getFormatCode() == 0 ? "T" : "B";
        String message = "\t Field(" + new String(this.getFieldName()) + "," + this.getDataTypeObjectID() + "," + this.m_dataTypeSize + "," + formatCode + ")";
        logger.logDebugExternal(message);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("\nFieldDescription: getFieldName - ");
        str.append(new String(this.getFieldName()));
        str.append("\ngetTableObjectID - ");
        str.append(this.getTableObjectIDString());
        str.append("\ngetColumnAttributeNumber - ");
        str.append(this.getColumnAttributeNumber());
        str.append("\ngetDataTypeObjectID - ");
        str.append(this.getDataTypeObjectID());
        str.append("\ngetDataTypeSize - ");
        str.append(this.getDataTypeSize());
        str.append("\ngetDataTypeModifier - ");
        str.append(this.getDataTypeModifier());
        str.append("\ngetFormatCode - ");
        str.append(this.getFormatCode());
        return str.toString();
    }

    private static boolean isVariableLengthType(int typeID) {
        return typeID == 25 || typeID == 1043 || typeID == 1562 || typeID == 1042;
    }
}

