/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client;

import com.amazon.jdbc.communications.exceptions.MessageBoundarySyncronizationLostException;
import com.amazon.jdbc.communications.interfaces.AbstractInboundDataHandler;
import com.amazon.redshift.client.FilterUtilities;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.client.messages.inbound.Authentication;
import com.amazon.redshift.client.messages.inbound.BindComplete;
import com.amazon.redshift.client.messages.inbound.CloseComplete;
import com.amazon.redshift.client.messages.inbound.CommandComplete;
import com.amazon.redshift.client.messages.inbound.DataRow;
import com.amazon.redshift.client.messages.inbound.EmptyQueryResponse;
import com.amazon.redshift.client.messages.inbound.ErrorResponse;
import com.amazon.redshift.client.messages.inbound.KeyData;
import com.amazon.redshift.client.messages.inbound.NoData;
import com.amazon.redshift.client.messages.inbound.NoticeResponse;
import com.amazon.redshift.client.messages.inbound.NotificationResponse;
import com.amazon.redshift.client.messages.inbound.ParameterDescription;
import com.amazon.redshift.client.messages.inbound.ParameterStatus;
import com.amazon.redshift.client.messages.inbound.ParseComplete;
import com.amazon.redshift.client.messages.inbound.ReadyForQuery;
import com.amazon.redshift.client.messages.inbound.RowDescription;
import com.amazon.redshift.core.IPGLogger;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class InboundDataHandler
extends AbstractInboundDataHandler
implements PGConstants {
    private static final char NULL_CHAR = '\uffff';
    public Map<String, String> m_parameterStatus;
    public KeyData m_keyData;
    private DataRow m_currentDataRow;
    private boolean m_processingDataRow;
    private char m_currentMessageType = (char)65535;
    private int m_currentMessageLength = -1;
    private ErrorResponse m_currentErrorResponse;
    private PGMessagingContext m_currentMessagingContext;
    private char m_lastMessageLogged = (char)88;
    private StringBuilder m_messageTypeLogging;
    private IWarningListener m_connectionWarningListener;
    protected IPGLogger m_log;

    public InboundDataHandler(IPGLogger logger, int nRowMode, int filterLevel) {
        super(logger, nRowMode, filterLevel);
        this.m_log = logger;
        this.m_parameterStatus = new HashMap<String, String>();
    }

    @Override
    public void closeOperation() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        super.closeOperation();
    }

    @Override
    protected boolean validateCurrentPipeline() {
        boolean validated = super.validateCurrentPipeline();
        if (null != this.m_currentPipeline && this.m_currentPipeline instanceof PGMessagingContext) {
            this.m_currentMessagingContext = (PGMessagingContext)this.m_currentPipeline;
        }
        return validated;
    }

    private void logMessageType() {
        if ('\uffff' != this.m_currentMessageType) {
            if (this.m_lastMessageLogged != this.m_currentMessageType) {
                if (null != this.m_messageTypeLogging) {
                    LogUtilities.logDebug(this.m_messageTypeLogging.toString(), (ILogger)this.m_log);
                    this.m_messageTypeLogging = null;
                }
                this.m_messageTypeLogging = new StringBuilder();
                this.m_messageTypeLogging.append("Message Type: ");
                this.m_messageTypeLogging.append(this.m_currentMessageType);
            } else {
                this.m_messageTypeLogging.append(this.m_currentMessageType);
            }
        } else if (null != this.m_messageTypeLogging) {
            LogUtilities.logDebug("Finally:" + this.m_messageTypeLogging.toString(), (ILogger)this.m_log);
            this.m_messageTypeLogging = null;
        }
        this.m_lastMessageLogged = this.m_currentMessageType;
    }

    @Override
    public void read(ByteBuffer readBuffer) throws ErrorException {
        if (this.m_log.isEnabled()) {
            LogUtilities.logInfo("Deserializing # of bytes: " + readBuffer.remaining(), (ILogger)this.m_log);
        }
        try {
            StringBuilder str;
            if (this.m_processingDataRow) {
                this.m_currentDataRow.read(readBuffer);
                if (this.m_log.isEnabled()) {
                    str = new StringBuilder();
                    str.append("Adding to Data row #");
                    str.append(this.m_currentMessagingContext.m_dataRowCount);
                    str.append(", # of columns: ");
                    str.append(this.m_currentDataRow.getNumberOfColumns());
                    LogUtilities.logDebug(str.toString(), (ILogger)this.m_log);
                }
                if (this.m_currentDataRow.isRowComplete()) {
                    ++this.m_currentMessagingContext.m_dataRowCount;
                    this.addToPipeline(this.m_currentDataRow, false);
                    this.m_processingDataRow = false;
                    this.m_currentDataRow = null;
                }
            }
            while (readBuffer.hasRemaining() && readBuffer.remaining() > 5) {
                if ('\uffff' == this.m_currentMessageType) {
                    this.m_currentMessageType = (char)readBuffer.get();
                    if (this.m_log.isEnabled()) {
                        this.logMessageType();
                    }
                }
                if (-1 == this.m_currentMessageLength) {
                    this.m_currentMessageLength = readBuffer.getInt();
                    if (this.m_log.isEnabled()) {
                        LogUtilities.logDebug("Message Length: " + this.m_currentMessageLength, (ILogger)this.m_log);
                    }
                }
                if ('D' == this.m_currentMessageType && DataRow.getUniqueMessageSize() > readBuffer.remaining() || 'D' != this.m_currentMessageType && this.m_currentMessageLength - 4 > readBuffer.remaining()) {
                    if (this.m_log.isEnabled()) {
                        str = new StringBuilder();
                        str.append("Next message spanning into the next buffer read, currently have ");
                        str.append(readBuffer.remaining());
                        str.append(" bytes. Message type: ");
                        str.append(this.m_currentMessageType);
                        str.append(", total messages in pipeline:");
                        str.append(this.m_currentPipeline.m_totalMessageCount);
                        str.append(", length expected: ");
                        str.append(this.m_currentMessageLength);
                        LogUtilities.logDebug(str.toString(), (ILogger)this.m_log);
                    }
                    return;
                }
                switch (this.m_currentMessageType) {
                    case 'D': {
                        this.m_currentDataRow = new DataRow(readBuffer, this.m_log, this.m_currentMessageLength);
                        if (this.m_log.isEnabled()) {
                            str = new StringBuilder();
                            str.append("Data row #");
                            str.append(this.m_currentMessagingContext.m_dataRowCount);
                            str.append(", # of columns: ");
                            str.append(this.m_currentDataRow.getNumberOfColumns());
                            str.append(", complete:");
                            str.append(this.m_currentDataRow.isRowComplete());
                            LogUtilities.logDebug(str.toString(), (ILogger)this.m_log);
                        }
                        if (this.m_currentDataRow.isRowComplete()) {
                            ++this.m_currentMessagingContext.m_dataRowCount;
                            this.addToPipeline(this.m_currentDataRow, false);
                            this.m_currentDataRow = null;
                            break;
                        }
                        this.m_processingDataRow = true;
                        break;
                    }
                    case 'S': {
                        ParameterStatus status = new ParameterStatus(readBuffer, this.m_log);
                        this.m_parameterStatus.put(status.getName(), status.getValue());
                        if (!this.m_log.isEnabled()) break;
                        LogUtilities.logInfo(status.toString(), (ILogger)this.m_log);
                        break;
                    }
                    case 'E': {
                        this.m_currentErrorResponse = new ErrorResponse(readBuffer, this.m_currentMessageLength, this.m_log);
                        if (this.m_log.isEnabled()) {
                            LogUtilities.logError(this.m_currentErrorResponse.toString(), (ILogger)this.m_log);
                        }
                        if (0 == this.m_currentErrorResponse.getTranslateSeverity().compareTo(ErrorResponse.Severity.FATAL) || 0 == this.m_currentErrorResponse.getTranslateSeverity().compareTo(ErrorResponse.Severity.PANIC)) {
                            throw this.m_currentErrorResponse.toErrorException();
                        }
                        if (!FilterUtilities.checkFilterLevel(this.m_currentErrorResponse.getSeverity(), this.m_filterLevel)) break;
                        this.addToPipeline(this.m_currentErrorResponse, true);
                        break;
                    }
                    case 'N': {
                        NoticeResponse notice = new NoticeResponse(readBuffer, this.m_currentMessageLength, this.m_log);
                        if (!FilterUtilities.checkFilterLevel(notice.getSeverity(), this.m_filterLevel)) break;
                        this.addToPipeline(notice, true);
                        if (!this.m_log.isEnabled()) break;
                        LogUtilities.logError(notice.toString(), (ILogger)this.m_log);
                        break;
                    }
                    case 'A': {
                        NotificationResponse notification = new NotificationResponse(readBuffer, this.m_log);
                        this.m_connectionWarningListener.postWarning(notification.toWarning());
                        if (!this.m_log.isEnabled()) break;
                        LogUtilities.logError(notification.toString(), (ILogger)this.m_log);
                        break;
                    }
                    case '1': {
                        this.addToPipeline(new ParseComplete(readBuffer, this.m_log), false);
                        break;
                    }
                    case '2': {
                        this.addToPipeline(new BindComplete(readBuffer, this.m_log), false);
                        break;
                    }
                    case 't': {
                        this.addToPipeline(new ParameterDescription(readBuffer, this.m_log), false);
                        break;
                    }
                    case 'T': {
                        this.addToPipeline(new RowDescription(readBuffer, this.m_log), false);
                        break;
                    }
                    case 'n': {
                        this.addToPipeline(new NoData(readBuffer, this.m_log), false);
                        break;
                    }
                    case 's': {
                        break;
                    }
                    case 'I': {
                        this.addToPipeline(new EmptyQueryResponse(this.m_log), false);
                        this.handleCommandComplete();
                        break;
                    }
                    case 'C': {
                        CommandComplete commandComplete = new CommandComplete(readBuffer, this.m_currentMessageLength, this.m_log);
                        this.addToPipeline(commandComplete, false);
                        this.handleCommandComplete();
                        break;
                    }
                    case '3': {
                        CloseComplete closeComplete = new CloseComplete(readBuffer, this.m_log);
                        this.addToPipeline(closeComplete, false);
                        this.m_currentMessagingContext.m_closeCompleteFromWire = true;
                        this.evaluateContainerRemoval(PGMessagingContext.CloseMode.CloseComplete);
                        break;
                    }
                    case 'Z': {
                        ReadyForQuery readyForQuery = new ReadyForQuery(readBuffer, this.m_log);
                        if (null == readyForQuery) break;
                        if (this.m_log.isEnabled()) {
                            if (readyForQuery.isIdle()) {
                                LogUtilities.logDebug("Ready for query - idle.", (ILogger)this.m_log);
                            } else if (readyForQuery.isTransactionBlock()) {
                                LogUtilities.logDebug("Ready for query - in transaction block.", (ILogger)this.m_log);
                            } else if (readyForQuery.isFailedTransactionBlock()) {
                                LogUtilities.logFatal("Ready for query - in a failed transaction block.", (ILogger)this.m_log);
                            }
                        }
                        if (!this.validateCurrentPipeline()) {
                            LogUtilities.logError("Unable to get pipeline", (ILogger)this.m_log);
                        }
                        if (PGMessagingContext.CloseMode.ReadyForQuery != this.m_currentMessagingContext.getCloseMode() && !this.m_currentMessagingContext.m_finalCommandInBatch) {
                            while (!this.m_currentMessagingContext.m_finalCommandInBatch) {
                                PGMessagingContext.CloseMode logCloseModeHolder = this.m_currentMessagingContext.getCloseMode();
                                if (null != this.m_currentErrorResponse) {
                                    this.addToPipeline(this.m_currentErrorResponse, false);
                                }
                                this.addToPipeline(readyForQuery, false);
                                this.removeCurrentContainer();
                                if (this.validateCurrentPipeline()) continue;
                                LogUtilities.logError("Previous pipeline was closeMode of " + (Object)((Object)logCloseModeHolder) + ", another is not available", (ILogger)this.m_log);
                            }
                            if (null != this.m_currentErrorResponse) {
                                this.addToPipeline(this.m_currentErrorResponse, false);
                            }
                        }
                        this.m_currentErrorResponse = null;
                        this.addToPipeline(readyForQuery, false);
                        this.removeCurrentContainer();
                        break;
                    }
                    case 'R': {
                        this.addToPipeline(new Authentication(readBuffer, this.m_log), false);
                        break;
                    }
                    case 'K': {
                        this.m_keyData = new KeyData(readBuffer, this.m_log);
                        break;
                    }
                    default: {
                        if (this.m_log.isEnabled()) {
                            str = new StringBuilder();
                            str.append("Message boundary syncronization lost (unrecognized message type)");
                            str.append(". Terminate. Found message type:" + this.m_currentMessageType);
                            str.append(":ReadBuffer.remaining:" + readBuffer.remaining());
                            str.append(":ReadBuffer.pos:" + readBuffer.position());
                            str.append(":ReadBuffer.limit:" + readBuffer.limit());
                            LogUtilities.logError(str.toString(), (ILogger)this.m_log);
                        }
                        throw new MessageBoundarySyncronizationLostException();
                    }
                }
                this.m_currentMessageType = (char)65535;
                this.m_currentMessageLength = -1;
            }
        }
        catch (Throwable ex) {
            LogUtilities.logFatal("InboundDataHandler caught throwable: " + ex.getMessage(), (ILogger)this.m_log);
            if (ex instanceof ErrorException) {
                throw (ErrorException)ex;
            }
            ErrorException err = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name());
            err.initCause(ex);
            throw err;
        }
        finally {
            if (this.m_log.isEnabled()) {
                this.logMessageType();
            }
            readBuffer.compact();
        }
    }

    private void handleCommandComplete() {
        this.m_currentMessagingContext.m_commandCompleteFromWire = true;
        if (this.m_currentMessagingContext.m_multipleParameterSetsMode) {
            ++this.m_currentMessagingContext.m_batchCommandCompleteToPipelineCount;
        }
        this.evaluateContainerRemoval(PGMessagingContext.CloseMode.CommandComplete);
    }

    @Override
    public void removeCurrentContainer() {
        this.m_currentPipeline = null;
        this.m_currentMessagingContext = null;
        super.removeCurrentContainer();
    }

    private void evaluateContainerRemoval(PGMessagingContext.CloseMode attemptCloseMode) {
        if (this.m_currentMessagingContext.m_finalCommandInBatch) {
            if (this.m_currentMessagingContext.m_multipleParameterSetsMode) {
                if (this.m_currentMessagingContext.m_batchCommandCompleteToPipelineCount == this.m_currentMessagingContext.m_batchCount) {
                    return;
                }
            } else {
                return;
            }
        }
        if (this.m_currentMessagingContext.getCloseMode() == attemptCloseMode) {
            this.removeCurrentContainer();
        }
    }

    public void registerWarningListener(IWarningListener listener) {
        this.m_connectionWarningListener = listener;
    }

    @Override
    public boolean isOpenOperation() {
        if (null == this.m_currentMessagingContext) {
            return false;
        }
        return this.m_currentMessagingContext.hasOpenOperation();
    }
}

