/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.communications.interfaces;

import java.nio.ByteBuffer;

public abstract class AbstractOutboundMessage {
    public static byte TERMINATOR = 0;

    public abstract int getSize();

    public abstract void serialize(ByteBuffer var1, byte[] var2);

    public void serialize(ByteBuffer buffer) {
        int size = this.getSize();
        if (buffer.capacity() < size) {
            // empty if block
        }
        this.serialize(buffer, this.toBytes(size));
    }

    protected byte[] toBytes(int value) {
        byte[] bytes = new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
        return bytes;
    }

    protected void addField(ByteBuffer buffer, byte[] fieldName, byte[] value) {
        buffer.put(fieldName);
        buffer.put(TERMINATOR);
        buffer.put(value);
        buffer.put(TERMINATOR);
    }
}

