/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dsi.core.impl;

import com.amazon.dsi.core.impl.DSIDriver;
import com.amazon.dsi.core.impl.DSIDriverSingleton;
import com.amazon.dsi.utilities.DSIMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.LogLevel;
import com.amazon.support.SettingReader;
import com.amazon.support.exceptions.ErrorException;
import com.amazon.support.exceptions.ExceptionType;
import com.amazon.support.exceptions.ExceptionUtilities;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class DSILogger
implements ILogger {
    public static final String LOG_PRINT_WRITER_KEY = "LogPrintWriter";
    private static final String LOG_FILE_EXTENSION = ".log";
    private LogLevel m_level = LogLevel.OFF;
    private String m_fileName;
    private Locale m_locale;
    private String m_package = "";
    private PrintWriter m_logWriter = null;
    private final List<String> m_logCreationErrors = new ArrayList<String>();

    public DSILogger(String string) {
        this.prepareSettings(string);
        this.setLocale(ExceptionUtilities.createLocale(SettingReader.readSetting("DriverLocale")));
    }

    public synchronized String getFileName() {
        int n;
        if (null != this.m_fileName && -1 != (n = this.m_fileName.lastIndexOf(File.separator))) {
            return this.m_fileName.substring(n + 1);
        }
        return this.m_fileName;
    }

    @Override
    public synchronized Locale getLocale() {
        return this.m_locale;
    }

    @Override
    public synchronized LogLevel getLogLevel() {
        return this.m_level;
    }

    @Override
    public synchronized boolean isEnabled() {
        return this.m_level != LogLevel.OFF;
    }

    @Override
    public void logDebug(String string, String string2, String string3, ErrorException errorException) {
        this.logDebug(string, string2, string3, this.getExceptionMessage(errorException));
    }

    @Override
    public void logDebug(String string, String string2, String string3, String string4) {
        String string5 = this.formatLogLine(LogLevel.DEBUG, string, string2, string3, string4);
        if (null != string5) {
            this.writeLogLine(string5);
        }
    }

    @Override
    public void logError(String string, String string2, String string3, ErrorException errorException) {
        this.logError(string, string2, string3, this.getExceptionMessage(errorException));
    }

    @Override
    public void logError(String string, String string2, String string3, String string4) {
        String string5 = this.formatLogLine(LogLevel.ERROR, string, string2, string3, string4);
        if (null != string5) {
            this.writeLogLine(string5);
        }
    }

    @Override
    public void logFatal(String string, String string2, String string3, String string4) {
        String string5 = this.formatLogLine(LogLevel.FATAL, string, string2, string3, string4);
        if (null != string5) {
            this.writeLogLine(string5);
        }
    }

    @Override
    public void logFunctionEntrance(String string, String string2, String string3) {
        String string4 = this.formatLogLine(LogLevel.TRACE, string, string2, string3, "+++++ enter +++++");
        if (null != string4) {
            this.writeLogLine(string4);
        }
    }

    @Override
    public void logInfo(String string, String string2, String string3, String string4) {
        String string5 = this.formatLogLine(LogLevel.INFO, string, string2, string3, string4);
        if (null != string5) {
            this.writeLogLine(string5);
        }
    }

    @Override
    public void logTrace(String string, String string2, String string3, String string4) {
        String string5 = this.formatLogLine(LogLevel.TRACE, string, string2, string3, string4);
        if (null != string5) {
            this.writeLogLine(string5);
            Throwable throwable = new Throwable();
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 1; i < stackTraceElementArray.length; ++i) {
                stringBuffer.append("   at ");
                stringBuffer.append(stackTraceElementArray[i].toString());
                stringBuffer.append("\n");
            }
            this.writeLogLine(stringBuffer.toString());
        }
    }

    @Override
    public void logWarning(String string, String string2, String string3, String string4) {
        String string5 = this.formatLogLine(LogLevel.WARNING, string, string2, string3, string4);
        if (null != string5) {
            this.writeLogLine(string5);
        }
    }

    public synchronized void prepareSettings(String string) {
        String string2 = "";
        string2 = SettingReader.readSetting("LogPath");
        string2 = this.resolveDirectory(string2);
        if (!string.contains(".")) {
            string = string + LOG_FILE_EXTENSION;
        }
        this.m_fileName = string2 + string;
        this.m_package = SettingReader.readSetting("LogNamespace");
        if (this.m_package == null) {
            this.m_package = "";
        }
        String string3 = SettingReader.readSetting("LogLevel");
        this.setLogLevel(LogLevel.getLogLevel(string3));
    }

    @Override
    public synchronized void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    @Override
    public synchronized void setLogLevel(LogLevel logLevel) {
        this.m_level = logLevel;
        if (LogLevel.OFF != logLevel) {
            this.prepareLogWriter();
        }
    }

    public synchronized void setLogPackage(String string) {
        this.m_package = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formatLogLine(LogLevel logLevel, String string, String string2, String string3, String string4) {
        Object object = this;
        synchronized (object) {
            if (null == this.m_logWriter) {
                return null;
            }
        }
        object = null;
        if (this.isInLevel(logLevel) && this.isInPackage(string)) {
            StringBuffer stringBuffer = new StringBuffer();
            SimpleDateFormat simpleDateFormat = null;
            simpleDateFormat = new SimpleDateFormat("MMM dd HH:mm:ss.SSS");
            simpleDateFormat.format(new Date(), stringBuffer, new FieldPosition(0));
            stringBuffer.append(" ");
            switch (logLevel) {
                case FATAL: {
                    stringBuffer.append("FATAL");
                    break;
                }
                case ERROR: {
                    stringBuffer.append("ERROR");
                    break;
                }
                case WARNING: {
                    stringBuffer.append("WARN ");
                    break;
                }
                case INFO: {
                    stringBuffer.append("INFO ");
                    break;
                }
                case DEBUG: {
                    stringBuffer.append("DEBUG");
                    break;
                }
                case TRACE: {
                    stringBuffer.append("TRACE");
                    break;
                }
                default: {
                    stringBuffer.append("LEVEL");
                }
            }
            stringBuffer.append(" ");
            stringBuffer.append(Thread.currentThread().getId()).append(" ");
            stringBuffer.append(string);
            stringBuffer.append(".");
            stringBuffer.append(string2);
            stringBuffer.append(".");
            stringBuffer.append(string3);
            stringBuffer.append(": ");
            stringBuffer.append(string4);
            object = stringBuffer.toString();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getExceptionMessage(ErrorException errorException) {
        Object object = this;
        synchronized (object) {
            errorException.loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), this.m_locale);
        }
        object = new StringWriter();
        errorException.printStackTrace(new PrintWriter((Writer)object));
        return errorException.getMessage() + "\n" + ((StringWriter)object).toString();
    }

    private synchronized boolean isInLevel(LogLevel logLevel) {
        return logLevel.ordinal() <= this.m_level.ordinal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isInPackage(String string) {
        if (null == string) {
            return false;
        }
        DSILogger dSILogger = this;
        synchronized (dSILogger) {
            return string.startsWith(this.m_package);
        }
    }

    private synchronized void prepareLogWriter() {
        this.m_logWriter = (PrintWriter)SettingReader.readAdditionalSetting(LOG_PRINT_WRITER_KEY);
        if (this.isEnabled() && null == this.m_logWriter) {
            if (null != this.m_fileName && 0 != this.m_fileName.length() && this.m_logCreationErrors.isEmpty()) {
                try {
                    Object object;
                    File file;
                    int n = this.m_fileName.lastIndexOf(File.separator);
                    if (-1 != n && !(file = new File((String)(object = this.m_fileName.substring(0, n)))).exists() && !file.mkdir()) {
                        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.CANNOT_CREATE_LOGGING_PATH.name(), (String)object, ExceptionType.DEFAULT);
                    }
                    object = new FileOutputStream(this.m_fileName, true);
                    this.m_logWriter = new PrintWriter((OutputStream)object);
                    return;
                }
                catch (Exception exception) {
                    this.m_logCreationErrors.add(exception.getLocalizedMessage());
                }
            }
            this.m_logWriter = new PrintWriter(System.out);
            for (String string : this.m_logCreationErrors) {
                ErrorException errorException = DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.DEFAULT_LOGGING.name(), string, ExceptionType.DEFAULT);
                errorException.loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
                this.m_logWriter.println(errorException.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String resolveDirectory(String string) {
        String string2 = "";
        try {
            File file;
            if (null != string && !(string2 = (file = new File(string)).getCanonicalPath()).endsWith(File.separator)) {
                string2 = string2 + File.separator;
            }
        }
        catch (Exception exception) {
            DSILogger dSILogger = this;
            synchronized (dSILogger) {
                this.m_logCreationErrors.add(exception.getLocalizedMessage());
            }
        }
        return string2;
    }

    private synchronized void writeLogLine(String string) {
        this.m_logWriter.println(string);
        this.m_logWriter.flush();
    }
}

