/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import java.math.BigDecimal;
import java.util.GregorianCalendar;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.builtIns.FNUtil;

class FNDateTimeDuration
extends OXMLFunction {
    static final int nFuncs = 21;
    int funcFlag;
    String fnName;
    OXMLSequenceType retType;
    OXMLSequenceType argType;
    static final String YEARS_YEARMONTHDURATION = "years-from-duration";
    static final String MONTHS_YEARMONTHDURATION = "months-from-duration";
    static final String DAYS_DAYTIMEDURATION = "days-from-duration";
    static final String HOURS_DAYTIMEDURATION = "hours-from-duration";
    static final String MINUTES_DAYTIMEDURATION = "minutes-from-duration";
    static final String SECONDS_DAYTIMEDURATION = "seconds-from-duration";
    static final String YEAR_DATETIME = "year-from-dateTime";
    static final String MONTH_DATETIME = "month-from-dateTime";
    static final String DAY_DATETIME = "day-from-dateTime";
    static final String HOURS_DATETIME = "hours-from-dateTime";
    static final String MINUTES_DATETIME = "minutes-from-dateTime";
    static final String SECONDS_DATETIME = "seconds-from-dateTime";
    static final String TIMEZONE_DATETIME = "timezone-from-dateTime";
    static final String YEAR_DATE = "year-from-date";
    static final String MONTH_DATE = "month-from-date";
    static final String DAY_DATE = "day-from-date";
    static final String TIMEZONE_DATE = "timezone-from-date";
    static final String HOURS_TIME = "hours-from-time";
    static final String MINUTES_TIME = "minutes-from-time";
    static final String SECONDS_TIME = "seconds-from-time";
    static final String TIMEZONE_TIME = "timezone-from-time";

    FNDateTimeDuration(int n) {
        this.funcFlag = n;
        this.retType = OXMLSequenceType.getConstantType(2, 22);
        switch (n) {
            case 0: {
                this.fnName = YEARS_YEARMONTHDURATION;
                this.argType = OXMLSequenceType.getConstantType(2, 6);
                break;
            }
            case 1: {
                this.fnName = MONTHS_YEARMONTHDURATION;
                this.argType = OXMLSequenceType.getConstantType(2, 6);
                break;
            }
            case 2: {
                this.fnName = DAYS_DAYTIMEDURATION;
                this.argType = OXMLSequenceType.getConstantType(2, 6);
                break;
            }
            case 3: {
                this.fnName = HOURS_DAYTIMEDURATION;
                this.argType = OXMLSequenceType.getConstantType(2, 6);
                break;
            }
            case 4: {
                this.fnName = MINUTES_DAYTIMEDURATION;
                this.argType = OXMLSequenceType.getConstantType(2, 6);
                break;
            }
            case 5: {
                this.fnName = SECONDS_DAYTIMEDURATION;
                this.argType = OXMLSequenceType.getConstantType(2, 6);
                this.retType = OXMLSequenceType.getConstantType(2, 5);
                break;
            }
            case 6: {
                this.fnName = YEAR_DATETIME;
                this.argType = OXMLSequenceType.getConstantType(2, 7);
                break;
            }
            case 7: {
                this.fnName = MONTH_DATETIME;
                this.argType = OXMLSequenceType.getConstantType(2, 7);
                break;
            }
            case 8: {
                this.fnName = DAY_DATETIME;
                this.argType = OXMLSequenceType.getConstantType(2, 7);
                break;
            }
            case 9: {
                this.fnName = HOURS_DATETIME;
                this.argType = OXMLSequenceType.getConstantType(2, 7);
                break;
            }
            case 10: {
                this.fnName = MINUTES_DATETIME;
                this.argType = OXMLSequenceType.getConstantType(2, 7);
                break;
            }
            case 11: {
                this.fnName = SECONDS_DATETIME;
                this.argType = OXMLSequenceType.getConstantType(2, 7);
                this.retType = OXMLSequenceType.getConstantType(2, 5);
                break;
            }
            case 12: {
                this.fnName = TIMEZONE_DATETIME;
                this.argType = OXMLSequenceType.getConstantType(2, 7);
                this.retType = OXMLSequenceType.getConstantType(2, 21);
                break;
            }
            case 13: {
                this.fnName = YEAR_DATE;
                this.argType = OXMLSequenceType.getConstantType(2, 9);
                break;
            }
            case 14: {
                this.fnName = MONTH_DATE;
                this.argType = OXMLSequenceType.getConstantType(2, 9);
                break;
            }
            case 15: {
                this.fnName = DAY_DATE;
                this.argType = OXMLSequenceType.getConstantType(2, 9);
                break;
            }
            case 16: {
                this.fnName = TIMEZONE_DATE;
                this.argType = OXMLSequenceType.getConstantType(2, 9);
                this.retType = OXMLSequenceType.getConstantType(2, 21);
                break;
            }
            case 17: {
                this.fnName = HOURS_TIME;
                this.argType = OXMLSequenceType.getConstantType(2, 8);
                break;
            }
            case 18: {
                this.fnName = MINUTES_TIME;
                this.argType = OXMLSequenceType.getConstantType(2, 8);
                break;
            }
            case 19: {
                this.fnName = SECONDS_TIME;
                this.argType = OXMLSequenceType.getConstantType(2, 8);
                this.retType = OXMLSequenceType.getConstantType(2, 5);
                break;
            }
            case 20: {
                this.fnName = TIMEZONE_TIME;
                this.argType = OXMLSequenceType.getConstantType(2, 8);
                this.retType = OXMLSequenceType.getConstantType(2, 21);
            }
        }
    }

    @Override
    public String getFunctionName() {
        return this.fnName;
    }

    @Override
    public int getNumberArgs() {
        return 1;
    }

    @Override
    public OXMLSequenceType getReturnType() {
        return this.retType;
    }

    @Override
    public OXMLSequenceType getArgType(int n) {
        if (n != 0) {
            return null;
        }
        return this.argType;
    }

    @Override
    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence) throws XQException {
        OXMLSequence oXMLSequence2 = oXMLFunctionContext.createSequence();
        OXMLItem oXMLItem = FNUtil.getEmptyOrSingleItem(oXMLSequence);
        if (oXMLItem != null) {
            OXMLItem oXMLItem2 = oXMLFunctionContext.createItem();
            switch (this.funcFlag) {
                case 0: {
                    oXMLItem2.setInt(this.retType, oXMLItem.getInt() / 12);
                    break;
                }
                case 1: {
                    oXMLItem2.setInt(this.retType, oXMLItem.getInt() % 12);
                    break;
                }
                case 2: {
                    oXMLItem2.setInt(this.retType, (int)(oXMLItem.getDouble() / 86400.0));
                    break;
                }
                case 3: {
                    oXMLItem2.setInt(this.retType, (int)(oXMLItem.getDouble() % 86400.0 / 3600.0));
                    break;
                }
                case 4: {
                    oXMLItem2.setInt(this.retType, (int)(oXMLItem.getDouble() % 3600.0 / 60.0));
                    break;
                }
                case 5: {
                    double d = oXMLItem.getDouble() % 60.0;
                    if ((double)((int)d) == d) {
                        oXMLItem2.setInt(this.retType, (int)d);
                        break;
                    }
                    oXMLItem2.setDecimal(this.retType, new BigDecimal(Double.toString(d)));
                    break;
                }
                case 6: {
                    oXMLItem2.setInt(this.retType, oXMLItem.getCalendar().get(1));
                    break;
                }
                case 7: {
                    oXMLItem2.setInt(this.retType, oXMLItem.getCalendar().get(2) + 1);
                    break;
                }
                case 8: {
                    oXMLItem2.setInt(this.retType, oXMLItem.getCalendar().get(5));
                    break;
                }
                case 9: {
                    oXMLItem2.setInt(this.retType, oXMLItem.getCalendar().get(11));
                    break;
                }
                case 10: {
                    oXMLItem2.setInt(this.retType, oXMLItem.getCalendar().get(12));
                    break;
                }
                case 11: {
                    GregorianCalendar gregorianCalendar = oXMLItem.getCalendar();
                    int n = gregorianCalendar.get(13);
                    int n2 = gregorianCalendar.get(14);
                    if (n2 == 0) {
                        oXMLItem2.setInt(this.retType, n);
                        break;
                    }
                    oXMLItem2.setDecimal(this.retType, new BigDecimal(Double.toString((double)n + (double)n2 / 1000.0)));
                    break;
                }
                case 12: {
                    if (oXMLItem.hasTimeZone()) {
                        oXMLItem2.setDuration(this.retType, 0, (double)oXMLItem.getCalendar().get(15) / 1000.0);
                        break;
                    }
                    oXMLItem2 = null;
                    break;
                }
                case 13: {
                    oXMLItem2.setInt(this.retType, oXMLItem.getCalendar().get(1));
                    break;
                }
                case 14: {
                    oXMLItem2.setInt(this.retType, oXMLItem.getCalendar().get(2) + 1);
                    break;
                }
                case 15: {
                    oXMLItem2.setInt(this.retType, oXMLItem.getCalendar().get(5));
                    break;
                }
                case 16: {
                    if (oXMLItem.hasTimeZone()) {
                        oXMLItem2.setDuration(this.retType, 0, (double)oXMLItem.getCalendar().get(15) / 1000.0);
                        break;
                    }
                    oXMLItem2 = null;
                    break;
                }
                case 17: {
                    oXMLItem2.setInt(this.retType, oXMLItem.getCalendar().get(11));
                    break;
                }
                case 18: {
                    oXMLItem2.setInt(this.retType, oXMLItem.getCalendar().get(12));
                    break;
                }
                case 19: {
                    GregorianCalendar gregorianCalendar = oXMLItem.getCalendar();
                    int n = gregorianCalendar.get(13);
                    int n3 = gregorianCalendar.get(14);
                    if (n3 == 0) {
                        oXMLItem2.setInt(this.retType, n);
                        break;
                    }
                    oXMLItem2.setDecimal(this.retType, new BigDecimal(Double.toString((double)n + (double)n3 / 1000.0)));
                    break;
                }
                case 20: {
                    if (oXMLItem.hasTimeZone()) {
                        oXMLItem2.setDuration(this.retType, 0, (double)oXMLItem.getCalendar().get(15) / 1000.0);
                        break;
                    }
                    oXMLItem2 = null;
                }
            }
            if (oXMLItem2 != null) {
                oXMLSequence2.appendItem(oXMLItem2);
            }
        }
        return oXMLSequence2;
    }

    @Override
    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence[] oXMLSequenceArray) throws XQException {
        if (oXMLSequenceArray.length != 1) {
            throw new XQException("FORT0001");
        }
        return this.invoke(oXMLFunctionContext, oXMLSequenceArray[0]);
    }
}

