/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.filter;

import de.javasoft.swing.filter.AbstractRowFilterModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.RowFilter;
import org.jdesktop.swingx.search.PatternModel;
import org.jdesktop.swingx.sort.RowFilters;

public class PatternRowFilterModel<M>
extends AbstractRowFilterModel<M> {
    public static final String MATCH_RULE_CONTAINS_NOT = "containsNot";
    private boolean inverted;
    private Object localMatchRule;
    private PatternModel patternModel;
    private PropertyChangeListener patternModelListener;

    public PatternRowFilterModel() {
        this(0);
    }

    public PatternRowFilterModel(int columnIndex) {
        this(columnIndex, null);
    }

    public PatternRowFilterModel(int columnIndex, Object matchRule) {
        super(columnIndex);
        this.init();
        this.setInitialMatchRule(matchRule);
    }

    private void init() {
        this.patternModel = this.createPatternModel();
        this.patternModelListener = this.createPatternModelChangeListener();
        this.getPatternModel().addPropertyChangeListener(this.patternModelListener);
    }

    protected PatternModel getPatternModel() {
        return this.patternModel;
    }

    protected PatternModel createPatternModel() {
        PatternModel model = new PatternModel();
        return model;
    }

    protected PropertyChangeListener createPatternModelChangeListener() {
        PropertyChangeListener l = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("pattern".equals(evt.getPropertyName())) {
                    PatternRowFilterModel.this.setRowFilter(PatternRowFilterModel.this.createRowFilter());
                } else if ("matchRule".equals(evt.getPropertyName())) {
                    PatternRowFilterModel.this.firePropertyChange("matchRule", evt.getOldValue(), evt.getNewValue());
                } else if ("rawText".equals(evt.getPropertyName())) {
                    PatternRowFilterModel.this.firePropertyChange("matchValue", evt.getOldValue(), evt.getNewValue());
                }
            }
        };
        return l;
    }

    @Override
    protected RowFilter<? super M, ? super Integer> createRowFilter() {
        RowFilter filter = null;
        if (this.getPatternModel().getPattern() != null) {
            filter = RowFilters.regexFilter((Pattern)this.getPatternModel().getPattern(), (int[])new int[]{this.getColumnIndex()});
            if (this.inverted) {
                filter = RowFilter.notFilter(filter);
            }
        }
        return filter;
    }

    @Override
    public void setMatchValue(Object matchValue) {
        if (matchValue != null && !(matchValue instanceof String)) {
            return;
        }
        this.getPatternModel().setRawText((String)matchValue);
    }

    @Override
    public void setMatchRule(Object matchRule) {
        if (!this.getMatchRules().contains(matchRule)) {
            throw new IllegalArgumentException("unknown match rule: " + matchRule);
        }
        if (this.areEqual(matchRule, this.getMatchRule())) {
            return;
        }
        this.getPatternModel().setMatchRule((String)matchRule);
    }

    @Override
    public Object getMatchValue() {
        return this.getPatternModel().getRawText();
    }

    @Override
    public List<String> getMatchRules() {
        ArrayList<String> rules = new ArrayList<String>(this.getPatternModel().getMatchRules());
        return rules;
    }

    @Override
    public Object getMatchRule() {
        if (this.inverted) {
            return this.localMatchRule;
        }
        return this.getPatternModel().getMatchRule();
    }

    private void forceUpdate(Object matchRule) {
        Object oldRule = this.getMatchRule();
        this.inverted = MATCH_RULE_CONTAINS_NOT.equals(matchRule);
        this.localMatchRule = this.inverted ? MATCH_RULE_CONTAINS_NOT : "contains";
        this.setRowFilter(this.createRowFilter());
        this.firePropertyChange("matchRule", oldRule, this.getMatchRule());
    }

    private boolean needsForcedUpdate(Object matchRule) {
        if (MATCH_RULE_CONTAINS_NOT.equals(matchRule)) {
            return "contains".equals(this.getMatchRule());
        }
        return MATCH_RULE_CONTAINS_NOT.equals(matchRule) && "contains".equals(this.getMatchRule()) || "contains".equals(matchRule) && MATCH_RULE_CONTAINS_NOT.equals(this.getMatchRule());
    }
}

