/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.scale;

import com.jidesoft.scale.Period;
import com.jidesoft.scale.ScaleArea;
import com.jidesoft.scale.ScaleAreaPopupMenuCustomizer;
import com.jidesoft.scale.ScaleModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class VisiblePeriodsPopupMenuCustomizer<T>
implements ScaleAreaPopupMenuCustomizer<T>,
ActionListener {
    public static final String RESOURCE_PREFIX = "ScaleArea.MenuItem.";
    public static final String PERIOD_TIER_UP = "periodTierUp";
    public static final String PERIOD_TIER_DOWN = "periodTierDown";
    public static final String HIDE_PERIOD_TIER = "hidePeriodTier";
    public static final String TOGGLE_PERIOD_VISIBILITY_TIER_X = "togglePeriodTier";
    private ScaleArea<T> \u0101;
    private Period \u0102;

    @Override
    public void customizePopup(JPopupMenu jPopupMenu, ScaleArea<T> scaleArea, Period period, T t2) {
        this.\u0101 = scaleArea;
        this.\u0102 = period;
        jPopupMenu.add(this.\u0101(PERIOD_TIER_UP));
        jPopupMenu.add(this.\u0101(PERIOD_TIER_DOWN));
        jPopupMenu.add(this.\u0101(HIDE_PERIOD_TIER));
        jPopupMenu.add(this.\u0101(TOGGLE_PERIOD_VISIBILITY_TIER_X));
    }

    private JMenuItem \u0101(String string) {
        JMenuItem jMenuItem;
        List<Period> list = this.\u0101.getVisiblePeriods();
        if (TOGGLE_PERIOD_VISIBILITY_TIER_X.equals(string)) {
            JMenu jMenu = new JMenu(this.getResourceString(string));
            jMenu.setName(string);
            ScaleModel<T> scaleModel = this.\u0101.getScaleModel();
            if (scaleModel != null) {
                List<Period> list2 = scaleModel.getPeriods();
                for (int i2 = list2.size() - 1; i2 >= 0; --i2) {
                    Period period = list2.get(i2);
                    String string2 = this.\u0101.getPeriodConverter(period).getDisplayName();
                    JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string2);
                    boolean bl = list.contains(period);
                    jCheckBoxMenuItem.setSelected(bl);
                    if (bl && list.size() == 1) {
                        jCheckBoxMenuItem.setEnabled(false);
                    }
                    jCheckBoxMenuItem.setActionCommand(TOGGLE_PERIOD_VISIBILITY_TIER_X + i2);
                    jCheckBoxMenuItem.addActionListener(this);
                    jMenu.add(jCheckBoxMenuItem);
                }
            } else {
                jMenu.setEnabled(false);
            }
            jMenuItem = jMenu;
        } else {
            jMenuItem = new JMenuItem(this.getResourceString(string));
            jMenuItem.setName(string);
            jMenuItem.setActionCommand(string);
            jMenuItem.addActionListener(this);
            int n2 = list.indexOf(this.\u0102);
            if (PERIOD_TIER_UP.equals(string)) {
                jMenuItem.setEnabled(n2 >= 0 && list.indexOf(this.\u0102) < list.size() - 1);
            } else if (PERIOD_TIER_DOWN.equals(string)) {
                jMenuItem.setEnabled(n2 > 0);
            } else if (HIDE_PERIOD_TIER.equals(string)) {
                jMenuItem.setEnabled(n2 != -1 && list.size() > 1);
            }
        }
        return jMenuItem;
    }

    protected String getResourceString(String string) {
        return this.\u0101.getResourceString(RESOURCE_PREFIX + string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        ArrayList<Period> arrayList = new ArrayList<Period>(this.\u0101.getVisiblePeriods());
        int n2 = arrayList.indexOf(this.\u0102);
        if (PERIOD_TIER_UP.equals(string)) {
            Collections.swap(arrayList, n2, n2 + 1);
        } else if (PERIOD_TIER_DOWN.equals(string)) {
            Collections.swap(arrayList, n2, n2 - 1);
        } else if (HIDE_PERIOD_TIER.equals(string)) {
            arrayList.remove(n2);
        } else if (string != null && string.startsWith(TOGGLE_PERIOD_VISIBILITY_TIER_X)) {
            try {
                n2 = Integer.parseInt(string.substring(TOGGLE_PERIOD_VISIBILITY_TIER_X.length(), string.length()));
                List<Period> list = this.\u0101.getScaleModel().getPeriods();
                Period period = list.get(n2);
                if (arrayList.contains(period)) {
                    arrayList.remove(period);
                } else {
                    int n3 = arrayList.size();
                    for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                        if (list.indexOf(arrayList.get(i2)) <= n2) continue;
                        n3 = i2;
                        break;
                    }
                    arrayList.add(n3, period);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.\u0101.setVisiblePeriods(arrayList);
    }
}

