/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.pane;

import com.jidesoft.animation.CustomAnimation;
import com.jidesoft.animation.Function;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.Alignable;
import com.jidesoft.swing.Animator;
import com.jidesoft.swing.AnimatorListener;
import com.jidesoft.swing.JideButton;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.UIResource;

public class FloorTabbedPane
extends JTabbedPane {
    protected Vector<AbstractButton> _buttons;
    protected int _percentage = 100;
    protected int _nextIndex = -1;
    protected int _prevIndex = -1;
    private int \u0103 = 50;
    private int \u0101 = 5;
    private int \u0104 = 50;
    private Function \u0105;
    public static String PERCENTAGE_PROPERTY;
    public static String PROPERTY_ORIENTATION;
    private int \u0102 = 1;

    public FloorTabbedPane() {
        this.setFocusable(true);
        this._buttons = new Vector();
        this.setLayout(this.createLayout());
        this.setBorder(BorderFactory.createBevelBorder(1));
    }

    public FloorTabbedPane(int n2, int n3, int n4) {
        this();
        this.\u0104 = n4;
        this.\u0101 = n3;
        this.\u0103 = n2;
    }

    @Override
    public void updateUI() {
        Component component;
        int n2;
        if (this._buttons != null) {
            for (n2 = 0; n2 < this._buttons.size(); ++n2) {
                component = this._buttons.elementAt(n2);
                ((AbstractButton)component).updateUI();
            }
        }
        for (n2 = 0; n2 < this.getTabCount(); ++n2) {
            component = this.getComponentAt(n2);
            if (!(component instanceof JComponent)) continue;
            ((JComponent)component).updateUI();
        }
    }

    protected LayoutManager createLayout() {
        return new A();
    }

    protected Action createSwitchPageAction(String string, Icon icon, int n2) {
        return new B(string, icon, n2);
    }

    public int getPercentage() {
        return this._percentage;
    }

    private void \u0103(int n2) {
        int n3 = this._percentage;
        if (this._percentage != n2) {
            this._percentage = n2;
            this.firePropertyChange(PERCENTAGE_PROPERTY, n3, this._percentage);
        }
    }

    public Vector<AbstractButton> getButtons() {
        return this._buttons;
    }

    public int getPrevIndex() {
        return this._prevIndex;
    }

    private void \u0105(int n2) {
        this._prevIndex = n2;
    }

    public int getNextIndex() {
        return this._nextIndex;
    }

    private void \u0102(int n2) {
        this._nextIndex = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTabAt(int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            AbstractButton abstractButton = this._buttons.elementAt(n2);
            int n3 = this.getSelectedIndex();
            if (n3 >= this.getTabCount() - 1) {
                this.setSelectedIndex(n3 - 1);
            }
            this._buttons.removeElementAt(n2);
            this.remove(abstractButton);
            int n4 = this._buttons.size();
            for (int i2 = n2; i2 < n4; ++i2) {
                abstractButton = this._buttons.elementAt(i2);
                B b2 = (B)abstractButton.getAction();
                b2.\u0101(i2);
            }
            super.removeTabAt(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertTab(String string, Icon icon, Component component, String string2, int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.insertTab(string, icon, component, string2, n2);
            AbstractButton abstractButton = this.createButton(this.createSwitchPageAction(string, icon, n2));
            if (!(abstractButton instanceof UIResource)) {
                throw new IllegalArgumentException("The button returned from createButton(Action action) method is not an instance of UIResource.");
            }
            if (abstractButton instanceof Alignable) {
                ((Alignable)((Object)abstractButton)).setOrientation(this.\u0101(this.getOrientation()));
            }
            abstractButton.setName(string);
            abstractButton.setToolTipText(string2);
            this.customizeButton(abstractButton);
            this._buttons.insertElementAt(abstractButton, n2);
            this.add(abstractButton);
            this.\u0103(0);
            component.setVisible(true);
            int n3 = this._buttons.size();
            for (int i2 = n2; i2 < n3; ++i2) {
                abstractButton = this._buttons.elementAt(i2);
                B b2 = (B)abstractButton.getAction();
                b2.\u0101(i2);
            }
            this.updateButtonSelectionState(this.getSelectedIndex());
        }
    }

    protected AbstractButton createButton(Action action) {
        return new FloorButton(action);
    }

    private int \u0101(int n2) {
        return n2 == 1 ? 0 : 1;
    }

    @Override
    public void setSelectedIndex(int n2) {
        int n3 = this.getSelectedIndex();
        if (n3 != -1) {
            this.\u0105(n3);
        }
        super.setSelectedIndex(n2);
        if (n2 >= 0) {
            this.\u0102(n2);
        }
        this.\u0101();
        this.updateButtonSelectionState(n2);
    }

    protected void updateButtonSelectionState(int n2) {
        Vector<AbstractButton> vector = this.getButtons();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            AbstractButton abstractButton = vector.get(i2);
            abstractButton.setSelected(i2 == n2);
        }
    }

    private void \u0101() {
        Animator animator = new Animator(this, this.\u0103, this.\u0101, this.\u0104);
        animator.addAnimatorListener(new AnimatorListener(){

            @Override
            public void animationStarts(Component component) {
                if (component instanceof FloorTabbedPane) {
                    ((FloorTabbedPane)component).\u0103(100);
                }
            }

            @Override
            public void animationFrame(Component component, int n2, int n3) {
                if (n2 == 0) {
                    return;
                }
                if (component instanceof FloorTabbedPane) {
                    FloorTabbedPane floorTabbedPane = (FloorTabbedPane)component;
                    double d2 = FloorTabbedPane.this.getAnimationFunction().calculate(n3, n2);
                    int n4 = (int)(100.0 * (1.0 - d2));
                    floorTabbedPane.\u0103(n4);
                    floorTabbedPane.invalidate();
                    floorTabbedPane.validate();
                }
            }

            @Override
            public void animationEnds(Component component) {
                if (component instanceof FloorTabbedPane) {
                    FloorTabbedPane floorTabbedPane = (FloorTabbedPane)component;
                    floorTabbedPane.\u0103(0);
                    floorTabbedPane.invalidate();
                    floorTabbedPane.validate();
                }
            }
        });
        animator.start();
    }

    private void \u0104(int n2) {
        if (n2 < 0 || n2 >= this.getButtons().size()) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ", Tab count: " + this.getButtons().size());
        }
    }

    @Override
    public int getMnemonicAt(int n2) {
        this.\u0104(n2);
        AbstractButton abstractButton = this.getButtons().get(n2);
        return abstractButton.getMnemonic();
    }

    @Override
    public void setMnemonicAt(int n2, int n3) {
        this.\u0104(n2);
        AbstractButton abstractButton = this.getButtons().get(n2);
        abstractButton.setMnemonic(n3);
        super.setMnemonicAt(n2, n3);
    }

    @Override
    public int getDisplayedMnemonicIndexAt(int n2) {
        this.\u0104(n2);
        AbstractButton abstractButton = this.getButtons().get(n2);
        return abstractButton.getDisplayedMnemonicIndex();
    }

    @Override
    public void setDisplayedMnemonicIndexAt(int n2, int n3) {
        this.\u0104(n2);
        AbstractButton abstractButton = this.getButtons().get(n2);
        abstractButton.setDisplayedMnemonicIndex(n3);
        super.setDisplayedMnemonicIndexAt(n2, n3);
    }

    @Override
    public void setTitleAt(int n2, String string) {
        this.\u0104(n2);
        AbstractButton abstractButton = this.getButtons().get(n2);
        abstractButton.setText(string);
        super.setTitleAt(n2, string);
    }

    @Override
    public String getTitleAt(int n2) {
        this.\u0104(n2);
        AbstractButton abstractButton = this.getButtons().get(n2);
        return abstractButton.getText();
    }

    @Override
    public Icon getIconAt(int n2) {
        this.\u0104(n2);
        AbstractButton abstractButton = this.getButtons().get(n2);
        return abstractButton.getIcon();
    }

    @Override
    public void setIconAt(int n2, Icon icon) {
        this.\u0104(n2);
        AbstractButton abstractButton = this.getButtons().get(n2);
        abstractButton.setIcon(icon);
        super.setIconAt(n2, icon);
    }

    @Override
    public Icon getDisabledIconAt(int n2) {
        this.\u0104(n2);
        AbstractButton abstractButton = this.getButtons().get(n2);
        return abstractButton.getDisabledIcon();
    }

    @Override
    public void setDisabledIconAt(int n2, Icon icon) {
        this.\u0104(n2);
        AbstractButton abstractButton = this.getButtons().get(n2);
        abstractButton.setDisabledIcon(icon);
        super.setDisabledIconAt(n2, icon);
    }

    @Override
    public String getToolTipTextAt(int n2) {
        this.\u0104(n2);
        AbstractButton abstractButton = this.getButtons().get(n2);
        return abstractButton.getToolTipText();
    }

    @Override
    public void setToolTipTextAt(int n2, String string) {
        this.\u0104(n2);
        AbstractButton abstractButton = this.getButtons().get(n2);
        abstractButton.setToolTipText(string);
        super.setToolTipTextAt(n2, string);
    }

    @Override
    public boolean isEnabledAt(int n2) {
        this.\u0104(n2);
        AbstractButton abstractButton = this.getButtons().get(n2);
        return abstractButton.isEnabled();
    }

    @Override
    public void setEnabledAt(int n2, boolean bl) {
        this.\u0104(n2);
        AbstractButton abstractButton = this.getButtons().get(n2);
        abstractButton.setEnabled(bl);
        super.setEnabledAt(n2, bl);
    }

    @Override
    public void setForegroundAt(int n2, Color color) {
        this.\u0104(n2);
        AbstractButton abstractButton = this.getButtons().get(n2);
        abstractButton.setForeground(color);
        super.setForegroundAt(n2, color);
    }

    @Override
    public Color getForegroundAt(int n2) {
        this.\u0104(n2);
        AbstractButton abstractButton = this.getButtons().get(n2);
        return abstractButton.getForeground();
    }

    @Override
    public void setBackgroundAt(int n2, Color color) {
        this.\u0104(n2);
        AbstractButton abstractButton = this.getButtons().get(n2);
        abstractButton.setBackground(color);
        super.setBackgroundAt(n2, color);
    }

    @Override
    public Color getBackgroundAt(int n2) {
        this.\u0104(n2);
        AbstractButton abstractButton = this.getButtons().get(n2);
        return abstractButton.getBackground();
    }

    public int getInitDelay() {
        return this.\u0103;
    }

    public void setInitDelay(int n2) {
        this.\u0103 = n2;
    }

    public int getStepDelay() {
        return this.\u0101;
    }

    public void setStepDelay(int n2) {
        this.\u0101 = n2;
    }

    public int getSteps() {
        return this.\u0104;
    }

    public void setSteps(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Steps can not be less than zero. Please pass in non-negative integer.");
        }
        this.\u0104 = n2;
    }

    public Function getAnimationFunction() {
        return this.\u0105 == null ? CustomAnimation.FUNC_POW2 : this.\u0105;
    }

    public void setAnimationFunction(Function function) {
        this.\u0105 = function;
    }

    protected void customizeButton(AbstractButton abstractButton) {
    }

    public int getOrientation() {
        return this.\u0102;
    }

    public void setOrientation(int n2) {
        if (this.\u0102 != n2) {
            int n3 = this.\u0102;
            this.\u0102 = n2;
            this.firePropertyChange(PROPERTY_ORIENTATION, n3, this.\u0102);
            for (AbstractButton abstractButton : this._buttons) {
                if (!(abstractButton instanceof Alignable)) continue;
                ((Alignable)((Object)abstractButton)).setOrientation(this.\u0101(this.getOrientation()));
            }
            this.revalidate();
            this.doLayout();
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTabbedPane();
        }
        return this.accessibleContext;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29) {
                System.err.println("The Lm class is invalid, exiting ...");
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(2)) {
            Lm.showInvalidProductMessage(FloorTabbedPane.class.getName(), 2);
        }
        PERCENTAGE_PROPERTY = "percentage";
        PROPERTY_ORIENTATION = "orientation";
    }

    protected class AccessibleJTabbedPane
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    ChangeListener {
        private static final long \u0101 = -60018244891799895L;

        public AccessibleJTabbedPane() {
            super(FloorTabbedPane.this);
            FloorTabbedPane.this.model.addChangeListener(this);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            this.firePropertyChange("AccessibleSelection", null, object);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PAGE_TAB_LIST;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return FloorTabbedPane.this.getTabCount();
        }

        @Override
        public Accessible getAccessibleChild(int n2) {
            if (n2 < 0 || n2 >= FloorTabbedPane.this.getTabCount()) {
                return null;
            }
            return (Accessible)((Object)FloorTabbedPane.this._buttons.elementAt(n2));
        }

        @Override
        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        @Override
        public Accessible getAccessibleAt(Point point) {
            int n2 = ((TabbedPaneUI)FloorTabbedPane.this.ui).tabForCoordinate(FloorTabbedPane.this, point.x, point.y);
            if (n2 == -1) {
                n2 = FloorTabbedPane.this.getSelectedIndex();
            }
            return this.getAccessibleChild(n2);
        }

        @Override
        public int getAccessibleSelectionCount() {
            return 1;
        }

        @Override
        public Accessible getAccessibleSelection(int n2) {
            int n3 = FloorTabbedPane.this.getSelectedIndex();
            if (n3 == -1) {
                return null;
            }
            return (Accessible)((Object)FloorTabbedPane.this._buttons.elementAt(n3));
        }

        @Override
        public boolean isAccessibleChildSelected(int n2) {
            return n2 == FloorTabbedPane.this.getSelectedIndex();
        }

        @Override
        public void addAccessibleSelection(int n2) {
            FloorTabbedPane.this.setSelectedIndex(n2);
        }

        @Override
        public void removeAccessibleSelection(int n2) {
        }

        @Override
        public void clearAccessibleSelection() {
        }

        @Override
        public void selectAllAccessibleSelection() {
        }
    }

    private class A
    implements LayoutManager {
        private A() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension preferredLayoutSize(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                if (!(container instanceof FloorTabbedPane)) {
                    return new Dimension(0, 0);
                }
                FloorTabbedPane floorTabbedPane = (FloorTabbedPane)container;
                if (floorTabbedPane.getButtons().size() == 0) {
                    return new Dimension(0, 0);
                }
                JButton jButton = (JButton)floorTabbedPane.getButtons().elementAt(0);
                FloorTabbedPane.this.customizeButton(jButton);
                Dimension dimension = jButton.getPreferredSize();
                int n2 = 0;
                int n3 = 0;
                if (FloorTabbedPane.this.getOrientation() == 1) {
                    for (int i2 = 0; i2 < floorTabbedPane.getButtons().size(); ++i2) {
                        int n4;
                        int n5 = floorTabbedPane.getButtons().elementAt((int)i2).getPreferredSize().width;
                        if (n5 > n2) {
                            n2 = n5;
                        }
                        Component component = floorTabbedPane.getComponentAt(i2);
                        int n6 = component.getPreferredSize().width;
                        if (n6 > n2) {
                            n2 = n6;
                        }
                        if ((n4 = component.getPreferredSize().height) <= n3) continue;
                        n3 = n4;
                    }
                    return new Dimension(n2, floorTabbedPane.getTabCount() * dimension.height + n3);
                }
                for (int i3 = 0; i3 < floorTabbedPane.getButtons().size(); ++i3) {
                    int n7;
                    int n8 = floorTabbedPane.getButtons().elementAt((int)i3).getPreferredSize().height;
                    if (n8 > n3) {
                        n3 = n8;
                    }
                    Component component = floorTabbedPane.getComponentAt(i3);
                    int n9 = component.getPreferredSize().height;
                    if (n9 > n3) {
                        n3 = n9;
                    }
                    if ((n7 = component.getPreferredSize().width) <= n2) continue;
                    n2 = n7;
                }
                return new Dimension(floorTabbedPane.getTabCount() * dimension.width + n2, n3);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension minimumLayoutSize(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                if (!(container instanceof FloorTabbedPane)) {
                    return new Dimension(0, 0);
                }
                FloorTabbedPane floorTabbedPane = (FloorTabbedPane)container;
                if (floorTabbedPane.getButtons().size() == 0) {
                    return new Dimension(0, 0);
                }
                JButton jButton = (JButton)floorTabbedPane.getButtons().elementAt(0);
                FloorTabbedPane.this.customizeButton(jButton);
                Dimension dimension = jButton.getMinimumSize();
                int n2 = 0;
                int n3 = 0;
                if (FloorTabbedPane.this.getOrientation() == 1) {
                    for (int i2 = 0; i2 < floorTabbedPane.getButtons().size(); ++i2) {
                        int n4;
                        int n5 = floorTabbedPane.getButtons().elementAt((int)i2).getMinimumSize().width;
                        if (n5 > n2) {
                            n2 = n5;
                        }
                        Component component = floorTabbedPane.getComponentAt(i2);
                        int n6 = component.getMinimumSize().width;
                        if (n6 > n2) {
                            n2 = n6;
                        }
                        if ((n4 = component.getMinimumSize().height) <= n3) continue;
                        n3 = n4;
                    }
                    return new Dimension(n2, floorTabbedPane.getTabCount() * dimension.height + n3);
                }
                for (int i3 = 0; i3 < floorTabbedPane.getButtons().size(); ++i3) {
                    int n7;
                    int n8 = floorTabbedPane.getButtons().elementAt((int)i3).getMinimumSize().height;
                    if (n8 > n3) {
                        n3 = n8;
                    }
                    Component component = floorTabbedPane.getComponentAt(i3);
                    int n9 = component.getMinimumSize().height;
                    if (n9 > n3) {
                        n3 = n9;
                    }
                    if ((n7 = component.getMinimumSize().width) <= n2) continue;
                    n2 = n7;
                }
                return new Dimension(floorTabbedPane.getTabCount() * dimension.width + n2, n3);
            }
        }

        @Override
        public void layoutContainer(Container container) {
            if (!(container instanceof FloorTabbedPane)) {
                return;
            }
            FloorTabbedPane floorTabbedPane = (FloorTabbedPane)container;
            if (floorTabbedPane.getButtons().size() == 0) {
                return;
            }
            Insets insets = floorTabbedPane.getInsets();
            Vector<AbstractButton> vector = floorTabbedPane.getButtons();
            if (FloorTabbedPane.this.getOrientation() == 1) {
                int n2 = floorTabbedPane.getWidth() - insets.left - insets.right;
                int n3 = floorTabbedPane.getButtons().elementAt((int)0).getPreferredSize().height;
                int n4 = floorTabbedPane.getHeight() - insets.top - insets.bottom - vector.size() * n3;
                int n5 = FloorTabbedPane.this.getPercentage() * n4 / 100;
                int n6 = n4 - n5;
                int n7 = insets.top;
                for (int i2 = 0; i2 < vector.size(); ++i2) {
                    JButton jButton = (JButton)vector.elementAt(i2);
                    jButton.setBounds(insets.left, n7, n2, n3);
                    n7 += n3;
                    Component component = floorTabbedPane.getComponentAt(i2);
                    if (floorTabbedPane.getPrevIndex() == i2 && floorTabbedPane.getNextIndex() != i2) {
                        component.setBounds(insets.left, n7, n2, n5);
                        component.setVisible(true);
                        n7 += n5;
                        continue;
                    }
                    if (floorTabbedPane.getNextIndex() == i2) {
                        component.setBounds(insets.left, n7, n2, n6);
                        component.setVisible(true);
                        n7 += n6;
                        continue;
                    }
                    component.setBounds(insets.left, n7, n2, 0);
                    component.setVisible(false);
                }
            } else {
                int n8 = floorTabbedPane.getHeight() - insets.top - insets.bottom;
                int n9 = floorTabbedPane.getButtons().elementAt((int)0).getPreferredSize().width;
                int n10 = floorTabbedPane.getWidth() - insets.left - insets.right - vector.size() * n9;
                int n11 = FloorTabbedPane.this.getPercentage() * n10 / 100;
                int n12 = n10 - n11;
                int n13 = insets.left;
                for (int i3 = 0; i3 < vector.size(); ++i3) {
                    JButton jButton = (JButton)vector.elementAt(i3);
                    jButton.setBounds(n13, insets.top, n9, n8);
                    n13 += n9;
                    Component component = floorTabbedPane.getComponentAt(i3);
                    if (floorTabbedPane.getPrevIndex() == i3 && floorTabbedPane.getNextIndex() != i3) {
                        component.setBounds(n13, insets.top, n11, n8);
                        component.setVisible(true);
                        n13 += n11;
                        continue;
                    }
                    if (floorTabbedPane.getNextIndex() == i3) {
                        component.setBounds(n13, insets.top, n12, n8);
                        component.setVisible(true);
                        n13 += n12;
                        continue;
                    }
                    component.setBounds(n13, insets.top, 0, n8);
                    component.setVisible(false);
                }
            }
        }
    }

    public class FloorButton
    extends JideButton
    implements UIResource {
        public FloorButton(Action action) {
            super(action);
            this.setOpaque(true);
            this.setContentAreaFilled(true);
            this.setButtonStyle(UIDefaultsLookup.getInt("FloorTabbedPane.buttonStyle"));
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setOpaque(true);
            this.setContentAreaFilled(true);
            this.setButtonStyle(UIDefaultsLookup.getInt("FloorTabbedPane.buttonStyle"));
        }

        public int getButtonIndex() {
            if (this.getAction() instanceof B) {
                return ((B)this.getAction()).\u0101();
            }
            return -1;
        }
    }

    private class B
    extends AbstractAction {
        private static final long \u0103 = 9210099378091997660L;
        private int \u0102;

        public B(String string, Icon icon, int n2) {
            super(string, icon);
            this.\u0102 = 0;
            this.\u0102 = n2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (FloorTabbedPane.this.getSelectedIndex() == this.\u0102) {
                return;
            }
            FloorTabbedPane.this.setSelectedIndex(this.\u0102);
            if (actionEvent.getSource() instanceof AbstractButton) {
                ((AbstractButton)actionEvent.getSource()).getModel().setRollover(false);
            }
        }

        public int \u0101() {
            return this.\u0102;
        }

        public void \u0101(int n2) {
            this.\u0102 = n2;
        }
    }
}

