/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.render;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.render.AbstractLineRenderer;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.chart.style.LineFillExtent;
import com.jidesoft.chart.style.LineStyle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;

public class StepLineRenderer
extends AbstractLineRenderer {
    public static final String PROPERTY_CHART = "Chart";
    private PropertyChangeSupport \u0105 = new PropertyChangeSupport(this);
    private Chart \u0104;
    private boolean \u0106 = false;

    public StepLineRenderer(Chart chart) {
        this.\u0104 = chart;
    }

    public Chart getChart() {
        return this.\u0104;
    }

    public void setChart(Chart chart) {
        Chart chart2 = this.\u0104;
        this.\u0104 = chart;
        this.\u0105.firePropertyChange(PROPERTY_CHART, chart2, chart);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.\u0105.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.\u0105.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public Shape renderLine(Graphics graphics, ChartModel chartModel, int[] nArray, int[] nArray2, ChartStyle chartStyle) {
        Serializable serializable;
        Serializable serializable2;
        Object object;
        Object object2;
        if (this.\u0104 == null) {
            throw new IllegalStateException("Chart property has not been set");
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Orientation orientation = Orientation.vertical;
        if (chartStyle != null) {
            object2 = chartStyle.getLineStyle();
            orientation = ((LineStyle)object2).getFillOrientation();
            object = ((LineStyle)object2).getFillExtent();
            if (nArray.length > 0 && ((LineStyle)object2).getFill() != null) {
                serializable2 = orientation == Orientation.vertical || chartModel == null ? this.\u0104(this.\u0104, chartModel, nArray, nArray2, (LineFillExtent)((Object)object)) : this.\u0103(this.\u0104, chartModel, nArray, nArray2, (LineFillExtent)((Object)object));
                serializable = ((Path2D)((Object)serializable2)).getBounds();
                Stroke stroke = graphics2D.getStroke();
                graphics2D.setStroke(new BasicStroke(1.0f));
                Paint paint = this.createLineFillPaint(chartModel, chartStyle, ((Rectangle)serializable).x, ((Rectangle)serializable).y, ((Rectangle)serializable).width, ((Rectangle)serializable).height);
                graphics2D.setPaint(paint);
                graphics2D.draw((Shape)((Object)serializable2));
                graphics2D.fill((Shape)((Object)serializable2));
                graphics2D.setStroke(stroke);
            }
        }
        object2 = chartStyle == null ? Color.black : chartStyle.getLineColor();
        graphics2D.setColor((Color)object2);
        object = chartStyle == null ? LineStyle.DEFAULT_STROKE : chartStyle.getLineStroke();
        graphics2D.setStroke((Stroke)object);
        serializable2 = null;
        serializable = null;
        GeneralPath generalPath = new GeneralPath();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            double d2 = nArray[i2];
            double d3 = nArray2[i2];
            if (serializable2 != null && serializable != null) {
                Line2D.Double double_;
                Line2D.Double double_2;
                if (orientation == Orientation.vertical || orientation == null) {
                    double_2 = new Line2D.Double((Double)serializable2, (Double)serializable, d2, (Double)serializable);
                    graphics2D.draw(double_2);
                    generalPath.append(double_2, false);
                    double_ = new Line2D.Double(d2, (Double)serializable, d2, d3);
                    graphics2D.draw(double_);
                    generalPath.append(double_, false);
                } else {
                    double_2 = new Line2D.Double((Double)serializable2, (Double)serializable, (Double)serializable2, d3);
                    graphics2D.draw(double_2);
                    generalPath.append(double_2, false);
                    double_ = new Line2D.Double((Double)serializable2, d3, d2, d3);
                    graphics2D.draw(double_);
                    generalPath.append(double_, false);
                }
            }
            serializable2 = Double.valueOf(d2);
            serializable = Double.valueOf(d3);
        }
        return generalPath;
    }

    private GeneralPath \u0104(Chart chart, ChartModel chartModel, int[] nArray, int[] nArray2, LineFillExtent lineFillExtent) {
        float f2 = this.calculateYVerticalExtent(chart, chartModel, lineFillExtent);
        GeneralPath generalPath = new GeneralPath();
        if (chartModel != null && chartModel.isCyclical()) {
            generalPath.moveTo(nArray[0], nArray2[0]);
        } else {
            generalPath.moveTo(nArray[0], f2);
        }
        Double d2 = null;
        Double d3 = null;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            double d4 = nArray[i2];
            double d5 = nArray2[i2];
            if (d2 != null && d3 != null) {
                generalPath.lineTo(d4, d3);
                generalPath.lineTo(d4, d5);
            } else {
                generalPath.lineTo(d4, d5);
            }
            d2 = d4;
            d3 = d5;
        }
        if (chartModel != null && chartModel.isCyclical()) {
            generalPath.lineTo(nArray[0], nArray2[0]);
        } else {
            generalPath.lineTo(nArray[nArray.length - 1], f2);
            generalPath.lineTo(nArray[0], f2);
        }
        generalPath.closePath();
        return generalPath;
    }

    private GeneralPath \u0103(Chart chart, ChartModel chartModel, int[] nArray, int[] nArray2, LineFillExtent lineFillExtent) {
        float f2 = this.calculateXHorizontalExtent(chart, chartModel, lineFillExtent);
        GeneralPath generalPath = new GeneralPath();
        if (chartModel != null && chartModel.isCyclical()) {
            generalPath.moveTo(nArray[0], nArray2[0]);
        } else {
            generalPath.moveTo(f2, nArray2[0]);
        }
        Double d2 = null;
        Double d3 = null;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            double d4 = nArray[i2];
            double d5 = nArray2[i2];
            if (d2 != null && d3 != null) {
                generalPath.lineTo(d2, d5);
                generalPath.lineTo(d4, d5);
            } else {
                generalPath.lineTo(d4, d5);
            }
            d2 = d4;
            d3 = d5;
        }
        if (chartModel != null && chartModel.isCyclical()) {
            generalPath.lineTo(nArray[0], nArray2[0]);
        } else {
            generalPath.lineTo(f2, nArray2[nArray.length - 1]);
            generalPath.lineTo(f2, nArray2[0]);
        }
        generalPath.closePath();
        return generalPath;
    }
}

