/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.BigDecimalColumn;
import com.exasol.jdbc.BoolColumn;
import com.exasol.jdbc.CharColumn;
import com.exasol.jdbc.Column;
import com.exasol.jdbc.ConnectionLost;
import com.exasol.jdbc.DateColumn;
import com.exasol.jdbc.DebugLog;
import com.exasol.jdbc.DecimalColumn;
import com.exasol.jdbc.DoubleColumn;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXAInputStream;
import com.exasol.jdbc.EXAResult;
import com.exasol.jdbc.EXASQLException;
import com.exasol.jdbc.EXAStatement;
import com.exasol.jdbc.ExecutionStatus;
import com.exasol.jdbc.NotImplemented;
import com.exasol.jdbc.ProtocolException;
import com.exasol.jdbc.TimestampColumn;
import com.exasol.jdbc.Translator;
import com.exasol.jdbc.VarCharColumn;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class EXAResultSet
extends EXAResult
implements ResultSetMetaData,
ResultSet {
    private String catalogName = "";
    private String schemaName = "";
    private String tableName = "";
    private Column[] columns;
    private boolean lastNull;
    private int cursorpos = -1;
    private int rows;
    private int fetchdirection = 1000;
    private int fetchsize = 2000;
    private long totalRows;
    private int handle = -1;
    private long firstIndex = 0L;
    private int maxRows = 0;
    private boolean closed = false;
    private int resultLineSize = 10000;
    private static int optimalPackageSize = 2000000;

    public void setMaxRows(int n) {
        this.maxRows = n;
    }

    public EXAResultSet(DebugLog debugLog) {
        super("EXAResultSet", debugLog);
        this.connection = null;
        this.columns = null;
    }

    public EXAResultSet(EXAInputStream eXAInputStream, EXAConnection eXAConnection, DebugLog debugLog) throws SQLException {
        this(debugLog);
        this.connection = eXAConnection;
        this.fetchsize = this.connection.getDefaultFetchSize();
        try {
            this.handle = eXAInputStream.readInt();
            switch (this.handle) {
                case -3: {
                    if (this.debug == null) break;
                    this.log("Result set handle = SMALL_RESULTSET");
                    break;
                }
                case -4: {
                    if (this.debug != null) {
                        this.log("Result set handle = INVALID_RESULTSET");
                    }
                    return;
                }
                default: {
                    if (this.debug == null) break;
                    this.log("Result set handle = " + this.handle);
                }
            }
            this.columns = new Column[eXAInputStream.readInt()];
            if (this.debug != null) {
                this.log("Result set has " + this.columns.length + " columns");
            }
            this.totalRows = eXAInputStream.readLong();
            if (this.debug != null) {
                this.log("Result set has " + this.totalRows + " rows");
            }
            this.rows = (int)eXAInputStream.readLong();
            if (this.debug != null) {
                this.log("Received " + this.rows + " rows");
            }
            this.resultLineSize = 0;
            for (int i = 0; i < this.columns.length; ++i) {
                String string = eXAInputStream.readString();
                if (this.debug != null) {
                    this.log("column " + (i + 1) + ": " + string);
                }
                this.columns[i] = Column.from_jdbc_type(eXAInputStream, eXAConnection);
                this.columns[i].resize(this.rows);
                if (string.length() > 0) {
                    this.columns[i].name = string;
                    this.columns[i].label = string;
                }
                this.resultLineSize += this.columns[i].getDisplaySize(eXAConnection);
            }
            this.readRows(eXAInputStream, this.rows);
            if ((long)this.rows == this.totalRows) {
                this.closeInServer();
            }
        }
        catch (IOException iOException) {
            throw new ConnectionLost(iOException.toString(), this.connection.getSessionID());
        }
    }

    public EXAResultSet(EXAResultSet eXAResultSet, String string, DebugLog debugLog) throws SQLException {
        this(debugLog);
        int n;
        String string2 = string.replaceAll("[\\\\]_", "_");
        string2 = string2.replaceAll("[\\\\][?]", "?");
        this.columns = new Column[eXAResultSet.getColumnCount()];
        this.rows = 0;
        eXAResultSet.beforeFirst();
        int n2 = 0;
        while ((long)n2 < eXAResultSet.getNumberOfRows()) {
            eXAResultSet.next();
            String string3 = eXAResultSet.getString(4);
            if (null != string3 && string3.equals(string2)) {
                this.rows = 1;
                break;
            }
            ++n2;
        }
        for (n = 0; n < this.columns.length; ++n) {
            String string4 = eXAResultSet.getColumnName(n + 1);
            switch (eXAResultSet.getColumnType(n + 1)) {
                case 8: {
                    this.columns[n] = new DoubleColumn();
                    break;
                }
                case -5: 
                case 3: 
                case 4: 
                case 5: {
                    this.columns[n] = new DecimalColumn(eXAResultSet.getPrecision(n + 1), eXAResultSet.getScale(n + 1));
                    break;
                }
                case 1: {
                    this.columns[n] = new CharColumn(eXAResultSet.getPrecision(n + 1));
                    break;
                }
                case 12: {
                    this.columns[n] = new VarCharColumn(eXAResultSet.getPrecision(n + 1));
                    break;
                }
                case 91: {
                    this.columns[n] = new DateColumn();
                    break;
                }
                case 93: {
                    this.columns[n] = new TimestampColumn();
                    break;
                }
                case 16: {
                    this.columns[n] = new BoolColumn();
                    break;
                }
                default: {
                    throw new ProtocolException(Translator.illegal_type_code() + eXAResultSet.getColumnType(n + 1));
                }
            }
            this.columns[n].resize(this.rows);
            if (string4.length() <= 0) continue;
            this.columns[n].name = string4;
            this.columns[n].label = string4;
        }
        if (1 == this.rows) {
            block20: for (n = 0; n < eXAResultSet.getColumnCount(); ++n) {
                if (null == eXAResultSet.getObject(n + 1)) {
                    this.columns[n].validMask[0] = false;
                    continue;
                }
                switch (eXAResultSet.getColumnType(n + 1)) {
                    case 8: {
                        ((DoubleColumn)this.columns[n]).setDouble(0, eXAResultSet.getDouble(n + 1));
                        continue block20;
                    }
                    case -5: 
                    case 3: 
                    case 4: 
                    case 5: {
                        if (eXAResultSet.getPrecision(n + 1) <= 18 && eXAResultSet.getScale(n + 1) == 0) {
                            ((DecimalColumn)this.columns[n]).setInt(0, eXAResultSet.getInt(n + 1));
                            continue block20;
                        }
                        ((DecimalColumn)this.columns[n]).setBigDecimal(0, eXAResultSet.getBigDecimal(n + 1));
                        continue block20;
                    }
                    case 1: {
                        ((CharColumn)this.columns[n]).setString(0, eXAResultSet.getString(n + 1));
                        continue block20;
                    }
                    case 12: {
                        ((VarCharColumn)this.columns[n]).setString(0, eXAResultSet.getString(n + 1));
                        continue block20;
                    }
                    case 91: {
                        ((DateColumn)this.columns[n]).setDate(0, eXAResultSet.getDate(n + 1));
                        continue block20;
                    }
                    case 93: {
                        ((TimestampColumn)this.columns[n]).setTimestamp(0, eXAResultSet.getTimestamp(n + 1));
                        continue block20;
                    }
                    case 16: {
                        ((BoolColumn)this.columns[n]).setBoolean(0, eXAResultSet.getBoolean(n + 1));
                        continue block20;
                    }
                    default: {
                        throw new ProtocolException(Translator.illegal_type_code() + eXAResultSet.getColumnType(n + 1));
                    }
                }
            }
        }
        this.totalRows = this.rows;
    }

    public EXAResultSet(String string, String[] stringArray, DebugLog debugLog) {
        this(debugLog);
        if (debugLog != null) {
            debugLog.log("EXAResultSet(String,String[],DebugLog)");
        }
        this.columns = new Column[1];
        this.columns[0] = new VarCharColumn(string, stringArray);
        this.rows = stringArray.length;
        this.cursorpos = -1;
    }

    public EXAResultSet(String string, BigDecimal[] bigDecimalArray, DebugLog debugLog) {
        this(debugLog);
        this.columns = new Column[1];
        this.columns[0] = new BigDecimalColumn(string, 36, 0, bigDecimalArray);
        this.rows = bigDecimalArray.length;
        this.cursorpos = -1;
    }

    private SQLException ex(Throwable throwable) {
        if (this.debug != null) {
            try {
                CharArrayWriter charArrayWriter = new CharArrayWriter();
                throwable.printStackTrace(new PrintWriter(charArrayWriter));
                this.debug.log(charArrayWriter.toString(), 0);
            }
            catch (Throwable throwable2) {
                this.log("internal log error:" + throwable2.toString());
            }
        }
        if (throwable instanceof SQLException) {
            return (SQLException)throwable;
        }
        return new SQLException(throwable.toString());
    }

    public boolean absolute(int n) throws SQLException {
        boolean bl = false;
        if (0 != this.maxRows && n >= this.maxRows) {
            bl = false;
        }
        if (n == 0) {
            bl = this.seek(0L);
            this.cursorpos = -1;
        } else {
            bl = n > 0 ? this.seek(n - 1) : this.seek(this.totalRows + (long)n);
        }
        if (this.debug != null) {
            this.log("absolute(" + n + "): " + bl);
        }
        return bl;
    }

    public int getRow() throws SQLException {
        int n = 0;
        long l = (long)this.cursorpos + this.firstIndex;
        n = l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)(l + 1L);
        if (this.debug != null) {
            this.log("getRow(): " + n + " posInResult=" + this.cursorpos);
        }
        return n;
    }

    public void afterLast() throws SQLException {
        if (this.debug != null) {
            this.log("afterLast()");
        }
        this.cursorpos = 0;
        if (0 != this.maxRows && this.totalRows >= (long)this.maxRows) {
            this.firstIndex = this.maxRows;
        }
        this.firstIndex = this.totalRows;
    }

    public void beforeFirst() throws SQLException {
        if (this.debug != null) {
            this.log("beforeFirst()");
        }
        this.seek(0L);
        this.cursorpos = -1;
    }

    public void cancelRowUpdates() throws SQLException {
        if (this.debug != null) {
            this.log("cancelRowUpdates() -> not implemented");
        }
        throw new NotImplemented(this.debug, "ResultSet.cancelRowUpdates()");
    }

    public void clearWarnings() throws SQLException {
        if (this.debug != null) {
            this.log("clearWarnings()");
        }
    }

    public void close() throws SQLException {
        if (this.debug != null) {
            this.log("close()");
        }
        this.closed = true;
        this.closeInServer();
    }

    private void closeInServer() throws SQLException {
        if (this.debug != null) {
            this.log("closeInServer() for handle " + this.handle);
        }
        if (this.handle < 0) {
            return;
        }
        byte[] byArray = new byte[]{(byte)this.handle, (byte)(this.handle >> 8), (byte)(this.handle >> 16), (byte)(this.handle >> 24)};
        this.handle = -1;
        this.connection.communication(byArray, (byte)13, new ExecutionStatus());
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void deleteRow() throws SQLException {
        if (this.debug != null) {
            this.log("deleteRow() -> not implemented");
        }
        throw new NotImplemented(this.debug, "EXAResultSet.deleteRow");
    }

    public int findColumn(String string) throws SQLException {
        for (int i = 0; i < this.columns.length; ++i) {
            if (!string.equalsIgnoreCase(this.columns[i].name)) continue;
            if (this.debug != null) {
                this.log("findColumn(" + string + "): " + (i + 1));
            }
            return i + 1;
        }
        if (this.debug != null) {
            this.log("findColumn(" + string + ") -> not found");
        }
        throw new SQLException(Translator.Column_name() + " \"" + string + "\" " + Translator.not_found());
    }

    public boolean first() throws SQLException {
        if (this.debug != null) {
            this.log("first(): absolute(1)");
        }
        return this.absolute(1);
    }

    public Array getArray(int n) throws SQLException {
        throw new NotImplemented(this.debug, "EXAResultSet.getArray");
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        throw new NotImplemented(this.debug, "EXAResultSet.getAsciiStream");
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        try {
            this.lastNull = this.columns[n - 1].isNull(this.cursorpos);
            if (this.lastNull) {
                return null;
            }
            BigDecimal bigDecimal = this.columns[n - 1].getBigDecimal(this.cursorpos);
            if (this.debug != null) {
                this.log("getBigDecimal(" + n + "): " + bigDecimal.toString());
            }
            return bigDecimal;
        }
        catch (Throwable throwable) {
            throw this.ex(throwable);
        }
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        try {
            this.lastNull = this.columns[n - 1].isNull(this.cursorpos);
            if (this.lastNull) {
                return null;
            }
            BigDecimal bigDecimal = this.columns[n - 1].getBigDecimal(this.cursorpos, n2);
            return bigDecimal;
        }
        catch (Throwable throwable) {
            throw this.ex(throwable);
        }
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        if (this.debug != null) {
            this.log("getBinaryStream(" + n + ")");
        }
        try {
            this.lastNull = this.columns[n - 1].isNull(this.cursorpos);
            if (this.lastNull) {
                return null;
            }
            return this.columns[n - 1].getBinaryStream(this.cursorpos);
        }
        catch (Throwable throwable) {
            throw this.ex(throwable);
        }
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public Blob getBlob(int n) throws SQLException {
        if (this.debug != null) {
            this.log("getBlob(" + n + ")");
        }
        try {
            this.lastNull = this.columns[n - 1].isNull(this.cursorpos);
            if (this.lastNull) {
                return null;
            }
            return this.columns[n - 1].getBlob(this.cursorpos);
        }
        catch (Throwable throwable) {
            throw this.ex(throwable);
        }
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public boolean getBoolean(int n) throws SQLException {
        try {
            this.lastNull = this.columns[n - 1].isNull(this.cursorpos);
            if (this.lastNull) {
                return false;
            }
            boolean bl = this.columns[n - 1].getBoolean(this.cursorpos);
            return bl;
        }
        catch (Throwable throwable) {
            throw this.ex(throwable);
        }
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(int n) throws SQLException {
        try {
            this.lastNull = this.columns[n - 1].isNull(this.cursorpos);
            if (this.lastNull) {
                return 0;
            }
            byte by = this.columns[n - 1].getByte(this.cursorpos);
            return by;
        }
        catch (Throwable throwable) {
            throw this.ex(throwable);
        }
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public byte[] getBytes(int n) throws SQLException {
        try {
            this.lastNull = this.columns[n - 1].isNull(this.cursorpos);
            if (this.lastNull) {
                return null;
            }
            return this.columns[n - 1].getBytes(this.cursorpos);
        }
        catch (Throwable throwable) {
            throw this.ex(throwable);
        }
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Reader getCharacterStream(int n) throws SQLException {
        if (this.debug != null) {
            this.log("getCharacterStream(" + n + ")");
        }
        try {
            this.lastNull = this.columns[n - 1].isNull(this.cursorpos);
            if (this.lastNull) {
                return null;
            }
            return this.columns[n - 1].getCharacterStream(this.cursorpos);
        }
        catch (Throwable throwable) {
            throw this.ex(throwable);
        }
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public Clob getClob(int n) throws SQLException {
        if (this.debug != null) {
            this.log("getClob(" + n + ")");
        }
        try {
            this.lastNull = this.columns[n - 1].isNull(this.cursorpos);
            if (this.lastNull) {
                return null;
            }
            return this.columns[n - 1].getClob(this.cursorpos);
        }
        catch (Throwable throwable) {
            throw this.ex(throwable);
        }
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public int getConcurrency() throws SQLException {
        if (this.debug != null) {
            this.log("getConcurrency(): CONCUR_READ_ONLY");
        }
        return 1007;
    }

    public String getCursorName() throws SQLException {
        if (this.debug != null) {
            this.log("getCursorName()");
        }
        throw new NotImplemented(this.debug, "Positioned update.");
    }

    public Date getDate(int n) throws SQLException {
        try {
            this.lastNull = this.columns[n - 1].isNull(this.cursorpos);
            if (this.lastNull) {
                return null;
            }
            Date date = this.columns[n - 1].getDate(this.cursorpos);
            return date;
        }
        catch (Throwable throwable) {
            throw this.ex(throwable);
        }
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        try {
            this.lastNull = this.columns[n - 1].isNull(this.cursorpos);
            if (this.lastNull) {
                return null;
            }
            Date date = this.columns[n - 1].getDate(this.cursorpos, calendar);
            return date;
        }
        catch (Throwable throwable) {
            throw this.ex(throwable);
        }
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public double getDouble(int n) throws SQLException {
        try {
            this.lastNull = this.columns[n - 1].isNull(this.cursorpos);
            if (this.lastNull) {
                return 0.0;
            }
            double d = this.columns[n - 1].getDouble(this.cursorpos);
            return d;
        }
        catch (Throwable throwable) {
            throw this.ex(throwable);
        }
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public int getFetchDirection() throws SQLException {
        if (this.debug != null) {
            this.log("getFetchDirection(): " + this.fetchdirection);
        }
        return this.fetchdirection;
    }

    public int getFetchSize() throws SQLException {
        if (this.debug != null) {
            this.log("EXAResultSet:getFetchSize(): " + this.fetchsize);
        }
        return this.fetchsize;
    }

    public float getFloat(int n) throws SQLException {
        try {
            this.lastNull = this.columns[n - 1].isNull(this.cursorpos);
            if (this.lastNull) {
                return 0.0f;
            }
            float f = this.columns[n - 1].getFloat(this.cursorpos);
            return f;
        }
        catch (Throwable throwable) {
            throw this.ex(throwable);
        }
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public int getInt(int n) throws SQLException {
        try {
            this.lastNull = this.columns[n - 1].isNull(this.cursorpos);
            if (this.lastNull) {
                return 0;
            }
            int n2 = this.columns[n - 1].getInt(this.cursorpos);
            return n2;
        }
        catch (Throwable throwable) {
            throw this.ex(throwable);
        }
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(int n) throws SQLException {
        try {
            this.lastNull = this.columns[n - 1].isNull(this.cursorpos);
            if (this.lastNull) {
                return 0L;
            }
            long l = this.columns[n - 1].getLong(this.cursorpos);
            return l;
        }
        catch (Throwable throwable) {
            throw this.ex(throwable);
        }
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.debug != null) {
            this.log("EXAResultSet: getMetaData() - result set meta data");
        }
        return this;
    }

    public Object getObject(int n) throws SQLException {
        try {
            this.lastNull = this.columns[n - 1].isNull(this.cursorpos);
            if (this.lastNull) {
                return null;
            }
            Object object = this.columns[n - 1].getObject(this.cursorpos);
            return object;
        }
        catch (Throwable throwable) {
            throw this.ex(throwable);
        }
    }

    public Object getObject(int n, Map map) throws SQLException {
        try {
            this.lastNull = this.columns[n - 1].isNull(this.cursorpos);
            if (this.lastNull) {
                return null;
            }
            Object object = this.columns[n - 1].getObject(this.cursorpos, map);
            return object;
        }
        catch (Throwable throwable) {
            throw this.ex(throwable);
        }
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    public Ref getRef(int n) throws SQLException {
        try {
            Ref ref = this.columns[n - 1].getRef(this.cursorpos);
            return ref;
        }
        catch (Throwable throwable) {
            throw this.ex(throwable);
        }
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    public short getShort(int n) throws SQLException {
        try {
            this.lastNull = this.columns[n - 1].isNull(this.cursorpos);
            if (this.lastNull) {
                return 0;
            }
            short s = this.columns[n - 1].getShort(this.cursorpos);
            return s;
        }
        catch (Throwable throwable) {
            throw this.ex(throwable);
        }
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public String getString(int n) throws SQLException {
        try {
            this.lastNull = this.columns[n - 1].isNull(this.cursorpos);
            if (this.lastNull) {
                return null;
            }
            String string = this.columns[n - 1].getString(this.cursorpos);
            return string;
        }
        catch (Throwable throwable) {
            throw this.ex(throwable);
        }
    }

    public Statement getStatement() {
        if (this.debug != null) {
            this.log("getStatement(): statement");
        }
        return this.statement;
    }

    public void setStatement(EXAStatement eXAStatement) {
        if (this.debug != null) {
            this.log("setStatement(): statement");
        }
        this.statement = eXAStatement;
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public Time getTime(int n) throws SQLException {
        try {
            this.lastNull = this.columns[n - 1].isNull(this.cursorpos);
            if (this.lastNull) {
                return null;
            }
            Time time = this.columns[n - 1].getTime(this.cursorpos);
            return time;
        }
        catch (Throwable throwable) {
            throw this.ex(throwable);
        }
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        try {
            this.lastNull = this.columns[n - 1].isNull(this.cursorpos);
            if (this.lastNull) {
                return null;
            }
            Time time = this.columns[n - 1].getTime(this.cursorpos, calendar);
            return time;
        }
        catch (Throwable throwable) {
            throw this.ex(throwable);
        }
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        try {
            this.lastNull = this.columns[n - 1].isNull(this.cursorpos);
            if (this.lastNull) {
                return null;
            }
            Timestamp timestamp = this.columns[n - 1].getTimestamp(this.cursorpos);
            return timestamp;
        }
        catch (Throwable throwable) {
            throw this.ex(throwable);
        }
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        try {
            this.lastNull = this.columns[n - 1].isNull(this.cursorpos);
            if (this.lastNull) {
                return null;
            }
            Timestamp timestamp = this.columns[n - 1].getTimestamp(this.cursorpos, calendar);
            return timestamp;
        }
        catch (Throwable throwable) {
            throw this.ex(throwable);
        }
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public int getType() throws SQLException {
        if (this.debug != null) {
            this.log("getType(): TYPE_SCROLL_INSENSITIVE");
        }
        return 1004;
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        if (this.debug != null) {
            this.log("getUnicodeStream(" + n + ")");
        }
        try {
            this.lastNull = this.columns[n - 1].isNull(this.cursorpos);
            if (this.lastNull) {
                return null;
            }
            return this.columns[n - 1].getUnicodeStream(this.cursorpos);
        }
        catch (Throwable throwable) {
            throw this.ex(throwable);
        }
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public URL getURL(int n) throws SQLException {
        if (this.debug != null) {
            this.log("getURL(" + n + ")");
        }
        throw new NotImplemented(this.debug, "getURL");
    }

    public URL getURL(String string) throws SQLException {
        if (this.debug != null) {
            this.log("getURL(" + string + ")");
        }
        throw new NotImplemented(this.debug, "getURL");
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.debug != null) {
            this.log("getWarnings(): null");
        }
        return null;
    }

    public void insertRow() throws SQLException {
        this.readOnly();
    }

    public boolean isAfterLast() throws SQLException {
        if (this.debug != null) {
            this.log("isAfterLast(): " + ((long)this.cursorpos + this.firstIndex == (long)this.rows));
        }
        if (0 != this.maxRows && this.firstIndex + (long)this.cursorpos >= (long)this.maxRows) {
            return true;
        }
        return this.firstIndex + (long)this.cursorpos >= this.totalRows;
    }

    public boolean isBeforeFirst() throws SQLException {
        if (this.debug != null) {
            this.log("isBeforeFirst(): " + ((long)this.cursorpos + this.firstIndex == -1L));
        }
        return (long)this.cursorpos + this.firstIndex == -1L;
    }

    public boolean isFirst() throws SQLException {
        if (this.debug != null) {
            this.log("isFirst(): " + ((long)this.cursorpos + this.firstIndex == 0L));
        }
        return (long)this.cursorpos + this.firstIndex == 0L;
    }

    public boolean isLast() throws SQLException {
        if (this.debug != null) {
            this.log("isLast(): " + (this.totalRows - 1L == (long)this.cursorpos + this.firstIndex));
        }
        if (0 != this.maxRows && this.firstIndex + (long)this.cursorpos == (long)(this.maxRows - 1)) {
            return true;
        }
        return (long)this.cursorpos + this.firstIndex == this.totalRows - 1L;
    }

    public boolean last() throws SQLException {
        if (this.debug != null) {
            this.log("last(): absolute(-1)");
        }
        return this.absolute(-1);
    }

    public void moveToCurrentRow() throws SQLException {
        if (this.debug != null) {
            this.log("moveToCurrentRow()");
        }
    }

    public void moveToInsertRow() throws SQLException {
        if (this.debug != null) {
            this.log("moveToInsertRow()");
        }
    }

    public boolean next() throws SQLException {
        if (0 != this.maxRows && (long)this.cursorpos + this.firstIndex + 1L >= (long)this.maxRows) {
            return false;
        }
        return this.seek((long)this.cursorpos + this.firstIndex + 1L);
    }

    public boolean previous() throws SQLException {
        if (this.debug != null) {
            this.log("previous(): " + (this.cursorpos >= 0));
        }
        return this.seek((long)this.cursorpos + this.firstIndex - 1L);
    }

    public void refreshRow() throws SQLException {
        if (this.debug != null) {
            this.log("refreshRow()");
        }
    }

    public boolean relative(int n) throws SQLException {
        if (this.debug != null) {
            this.log("relative(" + n + "): " + (this.cursorpos >= 0 && this.cursorpos < this.rows));
        }
        if (0 != this.maxRows && this.cursorpos + n >= this.maxRows) {
            return false;
        }
        return this.seek(this.cursorpos + n);
    }

    public boolean rowDeleted() throws SQLException {
        if (this.debug != null) {
            this.log("rowDeleted(): false");
        }
        return false;
    }

    public boolean rowInserted() throws SQLException {
        if (this.debug != null) {
            this.log("rowInserted(): false");
        }
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        if (this.debug != null) {
            this.log("rowUpdated(): false");
        }
        return false;
    }

    public void setFetchDirection(int n) throws SQLException {
        if (this.debug != null) {
            this.log("setFetchDirection(" + n + ")");
        }
        this.fetchdirection = n;
    }

    public void setFetchSize(int n) throws SQLException {
        if (this.debug != null) {
            this.log("EXAResultSet::setFetchSize(" + n + ")");
        }
        if (n <= 0) {
            if (this.debug != null) {
                this.log("Ignoring invalid fetch size: " + n + ". Fetch size will be set to statement default: " + this.statement.getFetchSize());
            }
            n = this.statement.getFetchSize();
        }
        this.fetchsize = n;
    }

    public void updateArray(int n, Array array) throws SQLException {
        if (this.debug != null) {
            this.log("updateArray(" + n + "," + array + ")");
        }
        throw new NotImplemented(this.debug, "updateArray");
    }

    public void updateArray(String string, Array array) throws SQLException {
        if (this.debug != null) {
            this.log("updateArray(" + string + "," + array + ")");
        }
        throw new NotImplemented(this.debug, "updateArray");
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.readOnly();
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.readOnly();
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.readOnly();
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        if (this.debug != null) {
            this.log("updateBlob(" + n + "," + blob + ")");
        }
        throw new NotImplemented(this.debug, "updateBlob");
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        if (this.debug != null) {
            this.log("updateBlob(" + string + "," + blob + ")");
        }
        throw new NotImplemented(this.debug, "updateBlob");
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.readOnly();
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(int n, byte by) throws SQLException {
        this.readOnly();
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.readOnly();
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.readOnly();
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        if (this.debug != null) {
            this.log("updateClob(" + n + "," + clob + ")");
        }
        throw new NotImplemented(this.debug, "updateClob");
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        if (this.debug != null) {
            this.log("updateClob(" + string + "," + clob + ")");
        }
        throw new NotImplemented(this.debug, "updateClob");
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.readOnly();
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateDouble(int n, double d) throws SQLException {
        this.readOnly();
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateFloat(int n, float f) throws SQLException {
        this.readOnly();
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.readOnly();
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(int n, long l) throws SQLException {
        this.readOnly();
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateNull(int n) throws SQLException {
        this.readOnly();
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public void updateObject(int n, Object object) throws SQLException {
        this.readOnly();
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.readOnly();
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    public void updateRow() throws SQLException {
        this.readOnly();
    }

    public void updateShort(int n, short s) throws SQLException {
        this.readOnly();
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateString(int n, String string) throws SQLException {
        this.readOnly();
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.readOnly();
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.readOnly();
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public boolean wasNull() {
        return this.lastNull;
    }

    protected void addColumn(Column column, String string) {
        if (this.columns == null) {
            this.columns = new Column[1];
            this.columns[0] = column;
        } else {
            Column[] columnArray = this.columns;
            this.columns = new Column[columnArray.length + 1];
            for (int i = 0; i < columnArray.length; ++i) {
                this.columns[i] = columnArray[i];
            }
            this.columns[columnArray.length] = column;
        }
        this.columns[this.columns.length - 1].name = string;
        this.columns[this.columns.length - 1].label = string;
    }

    private synchronized void fetchNextRows(long l) throws SQLException {
        if (-3 == this.handle) {
            throw new SQLException("Result is already closed on server, can't fetch rows for this handle.");
        }
        int n = 1000;
        if (0 != this.fetchsize) {
            n = this.fetchsize;
        } else if (this.resultLineSize > 0 && this.resultLineSize < optimalPackageSize) {
            n = optimalPackageSize / this.resultLineSize + 100;
        }
        if (this.handle < 0) {
            throw new SQLException("Invalid resultset handle.");
        }
        if (l >= this.totalRows) {
            throw new SQLException("Invalid row num!");
        }
        this.firstIndex = l;
        if (this.totalRows - l < (long)n) {
            n = (int)(this.totalRows - l);
        }
        if (n != this.rows) {
            for (int i = 0; i < this.columns.length; ++i) {
                this.columns[i].resize(n);
            }
        }
        this.rows = n;
        byte[] byArray = new byte[]{(byte)this.handle, (byte)(this.handle >> 8), (byte)(this.handle >> 16), (byte)(this.handle >> 24), (byte)l, (byte)(l >> 8), (byte)(l >> 16), (byte)(l >> 24), (byte)(l >> 32), (byte)(l >> 40), (byte)(l >> 48), (byte)(l >> 56), (byte)n, (byte)(n >> 8), (byte)(n >> 16), (byte)(n >> 24), 0, 0, 0, 0};
        byte[] byArray2 = this.connection.communication(byArray, (byte)14, new ExecutionStatus());
        EXAInputStream eXAInputStream = new EXAInputStream(byArray2, this.connection);
        try {
            this.readRows(eXAInputStream, n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new SQLException("Error while reading data.");
        }
    }

    private synchronized void fetch2(long l) throws SQLException {
        this.log("EXAResultSet.fetch2(" + l + ")");
        if (-3 == this.handle) {
            throw new SQLException("Result is already closed on server, can't fetch rows for this handle.");
        }
        long l2 = this.fetchsize * 1024;
        byte[] byArray = new byte[]{(byte)this.handle, (byte)(this.handle >> 8), (byte)(this.handle >> 16), (byte)(this.handle >> 24), (byte)l, (byte)(l >> 8), (byte)(l >> 16), (byte)(l >> 24), (byte)(l >> 32), (byte)(l >> 40), (byte)(l >> 48), (byte)(l >> 56), (byte)l2, (byte)(l2 >> 8), (byte)(l2 >> 16), (byte)(l2 >> 24), (byte)(l2 >> 32), (byte)(l2 >> 40), (byte)(l2 >> 48), (byte)(l2 >> 56)};
        byte[] byArray2 = this.connection.communication(byArray, (byte)36, new ExecutionStatus());
        if (null == byArray2) {
            throw new SQLException(Translator.Error_fetching_lines_from_server());
        }
        EXAInputStream eXAInputStream = new EXAInputStream(byArray2, this.connection);
        this.firstIndex = l;
        try {
            int n;
            if (this.connection.getActiveProtocolVersion() >= 9 && (n = eXAInputStream.readByte()) == -1) {
                throw new EXASQLException(eXAInputStream, this.debug).getSQLExceptionIntern(this.connection);
            }
            this.rows = (int)eXAInputStream.readLong();
            for (n = 0; n < this.columns.length; ++n) {
                this.columns[n].resize(this.rows);
            }
            this.readRows(eXAInputStream, this.rows);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new SQLException(Translator.Error_fetching_lines_from_server());
        }
    }

    private void readRows(EXAInputStream eXAInputStream, int n) throws SQLException, IOException {
        for (int i = 0; i < this.columns.length; ++i) {
            for (int j = 0; j < n; ++j) {
                this.columns[i].value_from_jdbc(eXAInputStream, j);
            }
        }
    }

    protected void setHandle(int n) {
        this.handle = n;
    }

    public int GetHandle() {
        return this.handle;
    }

    public String getCatalogName(int n) throws SQLException {
        if (this.debug != null) {
            this.log("getCatalogName(" + n + "): " + this.catalogName);
        }
        return this.catalogName;
    }

    public String getColumnClassName(int n) throws SQLException {
        try {
            String string = this.columns[n - 1].getClassName();
            if (this.debug != null) {
                this.log("getColumnClassName(" + n + "): " + string);
            }
            return string;
        }
        catch (Throwable throwable) {
            throw this.ex(throwable);
        }
    }

    public int getColumnCount() throws SQLException {
        try {
            if (null == this.columns) {
                return 0;
            }
            int n = this.columns.length;
            if (this.debug != null) {
                this.log("getColumnCount(): " + n);
            }
            return n;
        }
        catch (Throwable throwable) {
            throw this.ex(throwable);
        }
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        try {
            int n2 = this.columns[n - 1].getDisplaySize(this.connection);
            if (this.debug != null) {
                this.log("getColumnDisplaySize(" + n + "): " + n2);
            }
            return n2;
        }
        catch (Throwable throwable) {
            throw this.ex(throwable);
        }
    }

    public String getColumnLabel(int n) throws SQLException {
        try {
            String string = this.columns[n - 1].label;
            if (this.debug != null) {
                this.log("getColumnLabel(" + n + "): " + string);
            }
            return string;
        }
        catch (Throwable throwable) {
            throw this.ex(throwable);
        }
    }

    public String getColumnName(int n) throws SQLException {
        try {
            String string = this.columns[n - 1].name;
            if (this.debug != null) {
                this.log("getColumnName(" + n + "): " + string);
            }
            return string;
        }
        catch (Throwable throwable) {
            throw this.ex(throwable);
        }
    }

    public int getColumnType(int n) throws SQLException {
        try {
            int n2 = this.columns[n - 1].getType();
            if (this.debug != null) {
                this.log("getColumnType(" + n + "): " + n2);
            }
            return n2;
        }
        catch (Throwable throwable) {
            throw this.ex(throwable);
        }
    }

    public String getColumnTypeName(int n) throws SQLException {
        try {
            String string = this.columns[n - 1].getTypeName();
            if (this.debug != null) {
                this.log("getColumnTypeName(" + n + "): " + string);
            }
            return string;
        }
        catch (Throwable throwable) {
            throw this.ex(throwable);
        }
    }

    public int getPrecision(int n) throws SQLException {
        try {
            int n2 = this.columns[n - 1].getPrecision();
            if (this.debug != null) {
                this.log("getPrecision(" + n + "): " + n2);
            }
            return n2;
        }
        catch (Throwable throwable) {
            throw this.ex(throwable);
        }
    }

    public int getScale(int n) throws SQLException {
        try {
            int n2 = this.columns[n - 1].getScale();
            if (this.debug != null) {
                this.log("getScale(" + n + "): " + n2);
            }
            return n2;
        }
        catch (Throwable throwable) {
            throw this.ex(throwable);
        }
    }

    public String getSchemaName(int n) throws SQLException {
        if (this.debug != null) {
            this.log("getSchemaName(" + n + "): " + this.schemaName);
        }
        return this.schemaName;
    }

    public String getTableName(int n) throws SQLException {
        if (this.debug != null) {
            this.log("getTableName(" + n + "): " + this.tableName);
        }
        return this.tableName;
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        if (this.debug != null) {
            this.log("isAutoIncrement(" + n + "): false");
        }
        return false;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        if (this.debug != null) {
            this.log("isCaseSensitive(" + n + "): true");
        }
        return true;
    }

    public boolean isCurrency(int n) throws SQLException {
        if (this.debug != null) {
            this.log("isCurrency(" + n + "): false");
        }
        return false;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        if (this.debug != null) {
            this.log("isDefinitelyWritable(" + n + "): false");
        }
        return false;
    }

    public int isNullable(int n) {
        if (this.debug != null) {
            this.log("isNullable(" + n + "): " + 2);
        }
        return 2;
    }

    public boolean isReadOnly(int n) throws SQLException {
        if (this.debug != null) {
            this.log("isReadOnly(" + n + "): true");
        }
        return true;
    }

    public boolean isSearchable(int n) throws SQLException {
        if (this.debug != null) {
            this.log("isSearchable(" + n + ": true");
        }
        return true;
    }

    public boolean isSigned(int n) throws SQLException {
        try {
            boolean bl = this.columns[n - 1].isSigned();
            if (this.debug != null) {
                this.log("isSigned(" + n + "): " + bl);
            }
            return bl;
        }
        catch (Throwable throwable) {
            throw this.ex(throwable);
        }
    }

    public boolean isWritable(int n) throws SQLException {
        if (this.debug != null) {
            this.log("isWritable(" + n + "): false");
        }
        return false;
    }

    private void readOnly() throws SQLException {
        if (this.debug != null) {
            this.log("readOnly() -> error");
        }
        throw new SQLException("resultset is read only");
    }

    public int[] calcOptimalColumnWidths() throws SQLException {
        int[] nArray = new int[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            int n;
            int n2 = this.columns[i].label.length();
            if (n2 > nArray[i]) {
                nArray[i] = n2;
            }
            if (4 > nArray[i]) {
                nArray[i] = 4;
            }
            if ((n = this.columns[i].getDisplaySize(this.connection)) <= nArray[i]) continue;
            nArray[i] = n;
        }
        return nArray;
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        if (this.debug != null) {
            this.log("updateRef(" + n + "," + ref + ")");
        }
        throw new NotImplemented(this.debug, "updateRef");
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        if (this.debug != null) {
            this.log("updateRef(" + string + "," + ref + ")");
        }
        throw new NotImplemented(this.debug, "updateRef");
    }

    protected Column getColumn(int n) {
        if (this.columns == null) {
            return null;
        }
        return this.columns[n];
    }

    protected void resize(int n) {
        this.rows = n;
        this.totalRows = n;
        if (this.columns != null) {
            for (int i = 0; i < this.columns.length; ++i) {
                this.columns[i].resize(n);
            }
        }
    }

    public EXAResultSet toResultSet() {
        return this;
    }

    private boolean seek(long l) throws SQLException {
        if (l < 0L || l > this.totalRows - 1L) {
            return false;
        }
        if (l >= this.firstIndex) {
            if (l >= this.firstIndex + (long)this.rows) {
                if (this.connection.getActiveProtocolVersion() >= 8) {
                    this.fetch2(l);
                } else {
                    this.fetchNextRows(l);
                }
            }
            this.cursorpos = (int)(l - this.firstIndex);
        } else if (this.connection.getActiveProtocolVersion() >= 8) {
            this.fetch2(l);
        } else {
            this.fetchNextRows(l);
        }
        return true;
    }

    public long getNumberOfRows() {
        return this.totalRows;
    }

    public boolean isAscii(int n) throws SQLException {
        if (this.columns[n - 1] instanceof CharColumn) {
            int n2 = ((CharColumn)this.columns[n - 1]).getOctetLength();
            int n3 = ((CharColumn)this.columns[n - 1]).getDisplaySize(this.connection);
            if (n3 == n2) {
                return true;
            }
        }
        return false;
    }

    public int compareTo(EXAResultSet eXAResultSet) {
        int n = 0;
        try {
            int n2;
            if (this.getType() != eXAResultSet.getType()) {
                return 1;
            }
            if (this.getColumnCount() != eXAResultSet.getColumnCount()) {
                return 1;
            }
            if (this.getNumberOfRows() != eXAResultSet.getNumberOfRows()) {
                return 1;
            }
            this.beforeFirst();
            eXAResultSet.beforeFirst();
            for (n2 = 1; n2 <= this.getColumnCount(); ++n2) {
                if (this.getColumnType(n2) != eXAResultSet.getColumnType(n2)) {
                    System.out.println("Difference at getColumnType(" + n2 + ") this: " + this.getColumnType(n2) + ", ref:" + eXAResultSet.getColumnType(n2));
                    ++n;
                }
                if (this.getColumnDisplaySize(n2) != eXAResultSet.getColumnDisplaySize(n2)) {
                    System.out.println("Difference at getColumnDisplaySize(" + n2 + ") this: " + this.getColumnDisplaySize(n2) + ", ref:" + eXAResultSet.getColumnDisplaySize(n2));
                    ++n;
                }
                if (this.getPrecision(n2) != eXAResultSet.getPrecision(n2)) {
                    System.out.println("Difference at getPrecision(" + n2 + ") this: " + this.getPrecision(n2) + ", ref:" + eXAResultSet.getPrecision(n2));
                    ++n;
                }
                if (this.getScale(n2) != eXAResultSet.getScale(n2)) {
                    System.out.println("Difference at getScale(" + n2 + ") this: " + this.getScale(n2) + ", ref:" + eXAResultSet.getScale(n2));
                    ++n;
                }
                if (!this.getColumnTypeName(n2).equals(eXAResultSet.getColumnTypeName(n2))) {
                    System.out.println("Difference at getColumnTypeName(" + n2 + ") this: " + this.getColumnTypeName(n2) + ", ref:" + eXAResultSet.getColumnTypeName(n2));
                    ++n;
                }
                if (!this.getColumnClassName(n2).equals(eXAResultSet.getColumnClassName(n2))) {
                    System.out.println("Difference at getColumnClassName(" + n2 + ") this: " + this.getColumnClassName(n2) + ", ref:" + eXAResultSet.getColumnClassName(n2));
                    ++n;
                }
                if (!this.getColumnName(n2).equals(eXAResultSet.getColumnName(n2))) {
                    System.out.println("Difference at getColumnName(" + n2 + ") this: " + this.getColumnName(n2) + ", ref:" + eXAResultSet.getColumnName(n2));
                    ++n;
                }
                if (this.getColumnLabel(n2).equals(eXAResultSet.getColumnLabel(n2))) continue;
                System.out.println("Difference at getColumnLabel(" + n2 + ") this: " + this.getColumnLabel(n2) + ", ref:" + eXAResultSet.getColumnLabel(n2));
                ++n;
            }
            if (n != 0) {
                return n;
            }
            while (this.next() && eXAResultSet.next()) {
                if (this.cursorpos != eXAResultSet.cursorpos) {
                    System.out.println("Difference: cursorpos does not match. this:" + this.cursorpos + ", " + eXAResultSet.cursorpos);
                    return n + 1;
                }
                for (n2 = 1; n2 <= this.getColumnCount(); ++n2) {
                    if (null == this.getObject(n2) || null == eXAResultSet.getObject(n2)) {
                        if (null == this.getObject(n2) && null == eXAResultSet.getObject(n2)) continue;
                        if (null == this.getObject(n2)) {
                            System.out.println("Difference at row:" + this.cursorpos + ", col:" + n2 + "   null!=" + eXAResultSet.getObject(n2));
                        }
                        if (null == eXAResultSet.getObject(n2)) {
                            System.out.println("Difference at row:" + this.cursorpos + ", col:" + n2 + "   " + this.getObject(n2) + "!=null");
                        }
                        this.PrintRows(this, eXAResultSet);
                        ++n;
                        continue;
                    }
                    if (this.getObject(n2).equals(eXAResultSet.getObject(n2))) continue;
                    System.out.println("Difference at row:" + this.cursorpos + ", col:" + n2 + "   this:" + this.getObject(n2) + ", ref:" + eXAResultSet.getObject(n2));
                    this.PrintRows(this, eXAResultSet);
                    ++n;
                }
            }
            this.beforeFirst();
            eXAResultSet.beforeFirst();
        }
        catch (Exception exception) {
            return n + 1;
        }
        return n;
    }

    private void PrintRows(EXAResultSet eXAResultSet, EXAResultSet eXAResultSet2) throws SQLException {
        int n;
        for (n = 1; n <= eXAResultSet.getColumnCount(); ++n) {
            if (null == eXAResultSet.getObject(n)) {
                System.out.print("null ");
                continue;
            }
            System.out.print(eXAResultSet.getObject(n) + " ");
        }
        System.out.println();
        for (n = 1; n <= eXAResultSet2.getColumnCount(); ++n) {
            if (null == eXAResultSet2.getObject(n)) {
                System.out.print("null ");
                continue;
            }
            System.out.print(eXAResultSet2.getObject(n) + " ");
        }
        System.out.println();
    }

    public String toString() {
        try {
            int n;
            String string = "";
            for (n = 1; n <= this.getColumnCount(); ++n) {
                string = string + this.getColumnName(n) + " ";
            }
            this.beforeFirst();
            while (this.next()) {
                string = string + "\n";
                for (n = 1; n <= this.getColumnCount(); ++n) {
                    string = string + this.getObject(n) + " ";
                }
            }
            this.beforeFirst();
            return string;
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }
}

