/*
 * 'dbtool' is a simple but powerful  commandline interface to the
 * GNU gdbm system (or, alternatively the Berkeley DB), useful for
 * shellscripts which needs a database for data storage.
 */

/*
 *
 *  This file  is part of the DBTOOL program.
 *
 *  By  accessing  this software,  DBTOOL, you  are  duly informed
 *  of and agree to be  bound  by the  conditions  described below
 *  in this notice:
 *
 *  This software product,  DBTOOL,  is developed by Thomas Linden
 *  and  copyrighted  (C)  2001-2009  by  Thomas Linden,  with all
 *  rights reserved.
 *
 *  There  is no charge for DBTOOL software.  You can redistribute
 *  it and/or modify it under the terms of the GNU  General Public
 *  License, which is incorporated by reference herein.
 *
 *  DBTOOL is distributed WITHOUT ANY WARRANTY, IMPLIED OR EXPRESS,
 *  OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE or that
 *  the use of it will not infringe on any third party's intellec-
 *  tual property rights.
 *
 *  You  should  have received a copy of the  GNU  General  Public
 *  License  along with DBTOOL.  Copies can also be obtained from:
 *
 *    http://www.gnu.org/licenses/gpl.txt
 *
 *  or by writing to:
 *
 *  Free Software Foundation, Inc.
 *  59 Temple Place, Suite 330
 *  Boston, MA 02111-1307
 *  USA
 *
 *  Or contact:
 *
 *   "Thomas Linden" <tom@daemon.de>
 *
 *
 */


#ifndef CONFIG_H
#define CONFIG_H

#include <string>
#include <iostream>

extern "C" {
#include <unistd.h>
#include <stdlib.h>
}


/*
 * The Config class will hold all flags, modes and other
 * parameters we need for running.
 * methods defined in cmd.cc
 */
class Config {
 private:
  int     _argc;
  char  **_argv;
  string pkg;
  const char *default_db;

 public:
  Config();
  void args(int argc, char *argv[]);
  int parse();
  int     force, command, with, reverse, readonly, encrypted;
  string  filename, key, value, usage, token, phrase;
  char    separator;
};


#endif // CONFIG_H
