/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.gis;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.data.DBDValue;
import org.jkiss.utils.CommonUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTReader;

public class DBGeometry
implements DBDValue {
    private Object rawValue;
    private int srid;
    private Map<String, Object> properties;

    public DBGeometry() {
        this.rawValue = null;
    }

    public DBGeometry(String rawValue) {
        this.rawValue = rawValue;
    }

    public DBGeometry(DBGeometry source) {
        this.rawValue = source.rawValue;
        this.srid = source.srid;
        this.properties = source.properties == null ? null : new LinkedHashMap<String, Object>(source.properties);
    }

    public DBGeometry(Geometry rawValue) {
        this.rawValue = rawValue;
        this.srid = rawValue == null ? 0 : rawValue.getSRID();
    }

    public DBGeometry(Object rawValue, int srid) {
        this.rawValue = rawValue;
        this.srid = srid;
    }

    public DBGeometry(Object rawValue, int srid, Map<String, Object> properties) {
        this.rawValue = rawValue;
        this.srid = srid;
        this.properties = properties == null ? null : new LinkedHashMap<String, Object>(properties);
    }

    public Geometry getGeometry() {
        return this.rawValue instanceof Geometry ? (Geometry)this.rawValue : null;
    }

    public String getString() {
        return this.rawValue == null ? null : CommonUtils.toString((Object)this.rawValue);
    }

    public Object getRawValue() {
        return this.rawValue;
    }

    public boolean isNull() {
        return this.rawValue == null;
    }

    public boolean isModified() {
        return false;
    }

    public void release() {
    }

    public String toString() {
        return this.rawValue == null ? null : this.rawValue.toString();
    }

    public int getSRID() {
        return this.srid;
    }

    public void setSRID(int srid) {
        this.srid = srid;
        if (this.rawValue instanceof Geometry) {
            ((Geometry)this.rawValue).setSRID(srid);
        }
    }

    public DBGeometry flipCoordinates() throws DBException {
        Geometry jtsGeometry = this.getGeometry();
        if (jtsGeometry == null) {
            try {
                jtsGeometry = new WKTReader().read(this.getString());
            }
            catch (Exception e) {
                throw new DBException("Error parsing geometry WKT", (Throwable)e);
            }
        } else {
            jtsGeometry = jtsGeometry.copy();
        }
        jtsGeometry.apply((CoordinateFilter)InvertCoordinateFilter.INSTANCE);
        return new DBGeometry(jtsGeometry, this.srid, this.properties);
    }

    @NotNull
    public DBGeometry force2D() throws DBException {
        Geometry jtsGeometry = this.getGeometry();
        if (jtsGeometry == null) {
            try {
                jtsGeometry = new WKTReader().read(this.getString());
            }
            catch (Exception e) {
                throw new DBException("Error parsing geometry WKT", (Throwable)e);
            }
        }
        Coordinate[] coordinateArray = jtsGeometry.getCoordinates();
        int n = coordinateArray.length;
        int n2 = 0;
        while (n2 < n) {
            Coordinate coordinate = coordinateArray[n2];
            if (!Double.isNaN(coordinate.getZ())) {
                jtsGeometry = jtsGeometry.copy();
                jtsGeometry.apply((CoordinateFilter)Force2DCoordinateFilter.INSTANCE);
                break;
            }
            ++n2;
        }
        if (jtsGeometry == this.getGeometry()) {
            return this;
        }
        return new DBGeometry(jtsGeometry, this.srid, this.properties);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public DBGeometry copy() {
        return new DBGeometry(this);
    }

    public boolean isEmpty() {
        Geometry geometry = this.getGeometry();
        if (geometry == null) {
            return false;
        }
        Coordinate[] coordinateArray = geometry.getCoordinates();
        int n = coordinateArray.length;
        int n2 = 0;
        while (n2 < n) {
            Coordinate coord = coordinateArray[n2];
            if (coord.getX() != 0.0 || coord.getY() != 0.0 || coord.getZ() != 0.0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static class Force2DCoordinateFilter
    implements CoordinateFilter {
        public static final Force2DCoordinateFilter INSTANCE = new Force2DCoordinateFilter();

        private Force2DCoordinateFilter() {
        }

        public void filter(Coordinate coord) {
            coord.setZ(Double.NaN);
        }
    }

    private static class InvertCoordinateFilter
    implements CoordinateFilter {
        public static final InvertCoordinateFilter INSTANCE = new InvertCoordinateFilter();

        private InvertCoordinateFilter() {
        }

        public void filter(Coordinate coord) {
            double oldX = coord.x;
            coord.x = coord.y;
            coord.y = oldX;
        }
    }
}

