/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import org.eclipse.swt.graphics.Image;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.utils.CommonUtils;

public class BooleanRenderer {
    public static final char CHAR_BOOL_FALSE = '\u2610';
    public static final char CHAR_BOOL_TRUE = '\u2611';
    public static final char CHAR_BOOL_NULL = '\u2612';
    private static final String PREF_NAME_BOOLEAN_STYLE = "ui.render.boolean.style";
    private static Image imageCheckboxEnabledOn;
    private static Image imageCheckboxEnabledOff;
    private static Image imageCheckboxDisabledOn;
    private static Image imageCheckboxDisabledOff;

    public static Style getDefaultStyle() {
        return (Style)CommonUtils.valueOf(Style.class, (String)DBWorkbench.getPlatform().getPreferenceStore().getString(PREF_NAME_BOOLEAN_STYLE), (Enum)Style.TEXTBOX);
    }

    public static void setDefaultStyle(Style style) {
        DBWorkbench.getPlatform().getPreferenceStore().setValue(PREF_NAME_BOOLEAN_STYLE, style.name());
    }

    public static Image getImageCheckboxEnabledOn() {
        if (imageCheckboxEnabledOn == null) {
            BooleanRenderer.initImages();
        }
        return imageCheckboxEnabledOn;
    }

    public static Image getImageCheckboxEnabledOff() {
        if (imageCheckboxEnabledOff == null) {
            BooleanRenderer.initImages();
        }
        return imageCheckboxEnabledOff;
    }

    public static Image getImageCheckboxDisabledOn() {
        if (imageCheckboxDisabledOn == null) {
            BooleanRenderer.initImages();
        }
        return imageCheckboxDisabledOn;
    }

    public static Image getImageCheckboxDisabledOff() {
        if (imageCheckboxDisabledOff == null) {
            BooleanRenderer.initImages();
        }
        return imageCheckboxDisabledOff;
    }

    private static synchronized void initImages() {
        imageCheckboxEnabledOff = DBeaverIcons.getImage((DBPImage)UIIcon.CHECK_OFF);
        imageCheckboxEnabledOn = DBeaverIcons.getImage((DBPImage)UIIcon.CHECK_ON);
        imageCheckboxDisabledOn = BooleanRenderer.makeDisableImage(DBeaverIcons.getImage((DBPImage)UIIcon.CHECK_ON));
        imageCheckboxDisabledOff = BooleanRenderer.makeDisableImage(DBeaverIcons.getImage((DBPImage)UIIcon.CHECK_OFF));
    }

    private static Image makeDisableImage(Image image) {
        return new Image(image.getDevice(), image, 2);
    }

    public static enum Style {
        CHECKBOX(true, "Checkboxes", "Unicode checkbox symbols", String.valueOf('\u2612'), String.valueOf('\u2611'), String.valueOf('\u2610')),
        TEXTBOX(true, "Textboxes", "ASCII checkbox symbols", "[NULL]", "[X]", "[  ]"),
        ICON("Icons", "Checkbox icons"),
        TRUE_FALSE(true, "True/False", "Textual representation", "[NULL]", String.valueOf(true), String.valueOf(false)),
        YES_NO(true, "Yes/No", "Localized textual representation", "[NULL]", "yes", "no");

        private final boolean text;
        private final String displayName;
        private final String description;
        private final String textNull;
        private final String textTrue;
        private final String textFalse;

        public boolean isText() {
            return this.text;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getDescription() {
            return this.description;
        }

        public DBPImage getImage(Boolean value) {
            if (value == null) {
                return UIIcon.CHECK_QUEST;
            }
            if (value.booleanValue()) {
                return UIIcon.CHECK_ON;
            }
            return UIIcon.CHECK_OFF;
        }

        public String getText(Boolean value) {
            return this.text ? String.valueOf(value == null ? this.textNull : (value != false ? this.textTrue : this.textFalse)) : "";
        }

        private Style(String displayName, String description) {
            this(false, displayName, description, null, null, null);
        }

        private Style(boolean text, String displayName, String description, String textNull, String textTrue, String textFalse) {
            this.text = text;
            this.displayName = displayName;
            this.description = description;
            this.textNull = textNull;
            this.textTrue = textTrue;
            this.textFalse = textFalse;
        }
    }
}

