/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.firebird.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.firebird.FireBirdUtils;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdDataSource;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdDataTypeCache;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdSequence;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdTable;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdTableBase;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdTableColumn;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdTrigger;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdTriggerType;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdView;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericSequence;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTrigger;
import org.jkiss.dbeaver.ext.generic.model.GenericView;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaObject;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class FireBirdMetaModel
extends GenericMetaModel {
    private static final int OBJECT_NAME_LENGTH = 63;
    private Pattern ERROR_POSITION_PATTERN = Pattern.compile(" line ([0-9]+), column ([0-9]+)");

    public GenericDataSource createDataSourceImpl(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        return new FireBirdDataSource(monitor, container, this);
    }

    public FireBirdDataTypeCache createDataTypeCache(@NotNull GenericStructContainer container) {
        return new FireBirdDataTypeCache(container);
    }

    public String getViewDDL(DBRProgressMonitor monitor, GenericView sourceObject, Map<String, Object> options) throws DBException {
        return FireBirdUtils.getViewSource(monitor, (GenericTableBase)sourceObject);
    }

    public String getProcedureDDL(DBRProgressMonitor monitor, GenericProcedure sourceObject) throws DBException {
        return FireBirdUtils.getProcedureSource(monitor, sourceObject);
    }

    public boolean supportsSequences(@NotNull GenericDataSource dataSource) {
        return true;
    }

    /*
     * Loose catch block
     */
    public List<GenericSequence> loadSequences(@NotNull DBRProgressMonitor monitor, @NotNull GenericStructContainer container) throws DBException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)container, (String)"Read sequences");){
                ArrayList<GenericSequence> arrayList;
                JDBCPreparedStatement dbStat;
                Throwable throwable2;
                block32: {
                    throwable2 = null;
                    Object var7_11 = null;
                    dbStat = session.prepareStatement("SELECT * FROM RDB$GENERATORS");
                    ArrayList<GenericSequence> result = new ArrayList<GenericSequence>();
                    Throwable throwable3 = null;
                    Object var11_17 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        while (dbResult.next()) {
                            String name = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"RDB$GENERATOR_NAME");
                            if (name == null) continue;
                            String description = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"RDB$DESCRIPTION");
                            FireBirdSequence sequence = new FireBirdSequence(container, name, description, null, 0, -1, 1);
                            result.add(sequence);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                    arrayList = result;
                    if (dbStat == null) break block32;
                    dbStat.close();
                }
                return arrayList;
                {
                    catch (Throwable throwable5) {
                        try {
                            if (dbStat != null) {
                                dbStat.close();
                            }
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            if (throwable2 == null) {
                                throwable2 = throwable6;
                            } else if (throwable2 != throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable7) {
                if (throwable == null) {
                    throwable = throwable7;
                } else if (throwable != throwable7) {
                    throwable.addSuppressed(throwable7);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, (DBPDataSource)container.getDataSource());
        }
    }

    public boolean supportsTriggers(@NotNull GenericDataSource dataSource) {
        return true;
    }

    public boolean supportsDatabaseTriggers(@NotNull GenericDataSource dataSource) {
        return true;
    }

    /*
     * Loose catch block
     */
    public List<GenericTrigger> loadTriggers(DBRProgressMonitor monitor, @NotNull GenericStructContainer container, @Nullable GenericTableBase table) throws DBException {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)container, (String)"Read triggers");){
                ArrayList<GenericTrigger> arrayList;
                JDBCPreparedStatement dbStat;
                Throwable throwable2;
                block33: {
                    throwable2 = null;
                    Object var8_12 = null;
                    dbStat = session.prepareStatement("SELECT * FROM RDB$TRIGGERS\nWHERE RDB$RELATION_NAME" + (table == null ? " IS NULL" : "=?"));
                    if (table != null) {
                        dbStat.setString(1, table.getName());
                    }
                    ArrayList<GenericTrigger> result = new ArrayList<GenericTrigger>();
                    Throwable throwable3 = null;
                    Object var12_18 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        while (dbResult.next()) {
                            String name = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"RDB$TRIGGER_NAME");
                            if (name == null) continue;
                            int sequence = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"RDB$TRIGGER_SEQUENCE");
                            int type = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"RDB$TRIGGER_TYPE");
                            String description = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"RDB$DESCRIPTION");
                            FireBirdTrigger trigger = new FireBirdTrigger(container, table, name, description, FireBirdTriggerType.getByType(type), sequence);
                            result.add(trigger);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                    arrayList = result;
                    if (dbStat == null) break block33;
                    dbStat.close();
                }
                return arrayList;
                {
                    catch (Throwable throwable5) {
                        try {
                            if (dbStat != null) {
                                dbStat.close();
                            }
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            if (throwable2 == null) {
                                throwable2 = throwable6;
                            } else if (throwable2 != throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable7) {
                if (throwable == null) {
                    throwable = throwable7;
                } else if (throwable != throwable7) {
                    throwable.addSuppressed(throwable7);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, (DBPDataSource)container.getDataSource());
        }
    }

    public String getTriggerDDL(@NotNull DBRProgressMonitor monitor, @NotNull GenericTrigger trigger) throws DBException {
        return FireBirdUtils.getTriggerSource(monitor, (FireBirdTrigger)trigger);
    }

    public DBPErrorAssistant.ErrorPosition getErrorPosition(@NotNull Throwable error) {
        Matcher matcher;
        String message = error.getMessage();
        if (!CommonUtils.isEmpty((String)message) && (matcher = this.ERROR_POSITION_PATTERN.matcher(message)).find()) {
            DBPErrorAssistant.ErrorPosition pos = new DBPErrorAssistant.ErrorPosition();
            pos.line = Integer.parseInt(matcher.group(1)) - 1;
            pos.position = Integer.parseInt(matcher.group(2)) - 1;
            return pos;
        }
        return null;
    }

    public boolean isSystemTable(GenericTableBase table) {
        String tableName = table.getName();
        return (tableName = tableName.toUpperCase(Locale.ENGLISH)).startsWith("RDB$") || tableName.startsWith("MON$");
    }

    public JDBCStatement prepareTableLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase object, @Nullable String objectName) throws SQLException {
        String sql = "SELECT * FROM RDB$RELATIONS";
        sql = object == null && objectName == null ? String.valueOf(sql) + "\nORDER BY RDB$RELATION_NAME" : String.valueOf(sql) + "\nWHERE RDB$RELATION_NAME=?";
        JDBCPreparedStatement dbStat = session.prepareStatement(sql);
        if (object != null || objectName != null) {
            dbStat.setString(1, object != null ? object.getName() : objectName);
        }
        return dbStat;
    }

    public GenericTableBase createTableImpl(GenericStructContainer container, @Nullable String tableName, @Nullable String tableType, @Nullable JDBCResultSet dbResult) {
        if (tableType != null && this.isView(tableType)) {
            return new FireBirdView(container, tableName, tableType, dbResult);
        }
        return new FireBirdTable(container, tableName, tableType, dbResult);
    }

    public GenericTableBase createTableImpl(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @NotNull GenericMetaObject tableObject, @NotNull JDBCResultSet dbResult) {
        FireBirdTableBase table;
        int relType;
        String relationName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"RDB$RELATION_NAME");
        boolean isSystem = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"RDB$SYSTEM_FLAG") != 0;
        try {
            relType = dbResult.getInt("RDB$RELATION_TYPE");
        }
        catch (SQLException sQLException) {
            int n = relType = JDBCUtils.safeGetBytes((ResultSet)dbResult, (String)"RDB$VIEW_BLR") == null ? 0 : 1;
        }
        if (relType == 1) {
            table = new FireBirdView(owner, relationName, isSystem ? "SYSTEM VIEW" : "VIEW", dbResult);
        } else {
            String tableType;
            switch (relType) {
                case 2: {
                    tableType = "EXTERNAL TABLE";
                    break;
                }
                case 3: {
                    tableType = "MONITORING TABLE";
                    break;
                }
                case 4: {
                    tableType = "CONNECTION-LEVEL GTT";
                    break;
                }
                case 5: {
                    tableType = "TRANSACTION-LEVEL GTT";
                    break;
                }
                default: {
                    tableType = isSystem ? "SYSTEM TABLE" : "TABLE";
                }
            }
            table = new FireBirdTable(owner, relationName, tableType, dbResult);
        }
        table.setPersisted(true);
        table.setSystem(isSystem);
        table.setDescription(JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"RDB$DESCRIPTION"));
        return table;
    }

    public GenericTableColumn createTableColumnImpl(@NotNull DBRProgressMonitor monitor, JDBCResultSet dbResult, @NotNull GenericTableBase table, String columnName, String typeName, int valueType, int sourceType, int ordinalPos, long columnSize, long charLength, Integer scale, Integer precision, int radix, boolean notNull, String remarks, String defaultValue, boolean autoIncrement, boolean autoGenerated) throws DBException {
        return new FireBirdTableColumn(monitor, dbResult, table, columnName, typeName, valueType, sourceType, ordinalPos, columnSize, charLength, scale, precision, radix, notNull, remarks, defaultValue, autoIncrement, autoGenerated);
    }

    public JDBCStatement prepareUniqueConstraintsLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase forParent) throws SQLException {
        return session.prepareStatement("select RC.RDB$RELATION_NAME TABLE_NAME,ISGMT.RDB$FIELD_NAME as COLUMN_NAME,CAST((ISGMT.RDB$FIELD_POSITION + 1) as SMALLINT) as KEY_SEQ,RC.RDB$CONSTRAINT_NAME as PK_NAME,RC.RDB$CONSTRAINT_TYPE as CONSTRAINT_TYPE FROM RDB$RELATION_CONSTRAINTS RC INNER JOIN RDB$INDEX_SEGMENTS ISGMT ON RC.RDB$INDEX_NAME = ISGMT.RDB$INDEX_NAME where RC.RDB$CONSTRAINT_TYPE IN ('PRIMARY KEY','UNIQUE') " + (forParent == null ? "" : "AND RC.RDB$RELATION_NAME = '" + forParent.getName()) + "' " + "ORDER BY ISGMT.RDB$FIELD_NAME ");
    }

    public DBSEntityConstraintType getUniqueConstraintType(JDBCResultSet dbResult) throws DBException, SQLException {
        String constraintType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSTRAINT_TYPE");
        return "PRIMARY KEY".equals(constraintType) ? DBSEntityConstraintType.PRIMARY_KEY : DBSEntityConstraintType.UNIQUE_KEY;
    }
}

