/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.data;

import java.util.Locale;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.data.gis.handlers.GISGeometryValueHandler;
import org.jkiss.dbeaver.ext.mysql.data.MySQLDateTimeValueHandler;
import org.jkiss.dbeaver.ext.mysql.data.MySQLNumberValueHandler;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDFormatSettings;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.data.DBDValueHandlerProvider;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCContentValueHandler;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCObjectValueHandler;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class MySQLValueHandlerProvider
implements DBDValueHandlerProvider {
    @Nullable
    public DBDValueHandler getValueHandler(DBPDataSource dataSource, DBDFormatSettings preferences, DBSTypedObject typedObject) {
        String typeName;
        DBPDataKind dataKind = typedObject.getDataKind();
        if (dataKind == DBPDataKind.DATETIME) {
            return new MySQLDateTimeValueHandler(preferences);
        }
        if (dataKind == DBPDataKind.NUMERIC) {
            return new MySQLNumberValueHandler(typedObject, preferences);
        }
        switch (typeName = typedObject.getTypeName().toLowerCase(Locale.ENGLISH)) {
            case "json": {
                return JDBCContentValueHandler.INSTANCE;
            }
            case "geometry": {
                return new GISGeometryValueHandler(true);
            }
            case "set": 
            case "enum": {
                return JDBCObjectValueHandler.INSTANCE;
            }
        }
        return null;
    }
}

