/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectMaker;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.navigator.DBNContainer;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.TasksJob;
import org.jkiss.dbeaver.runtime.ui.UIServiceSQL;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditor;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectBase;

class NavigatorObjectsDeleter {
    private static final Log log = Log.getLog(NavigatorObjectsDeleter.class);
    private static final Map<String, Object> OPTIONS_CASCADE = Collections.singletonMap("deleteCascade", Boolean.TRUE);
    private final List<DBRRunnableWithProgress> tasksToExecute = new ArrayList<DBRRunnableWithProgress>();
    private final IWorkbenchWindow window;
    private final List<Object> selection;
    private final boolean showCascade;
    private final boolean showViewScript;
    private final boolean showDeleteContents;
    private final boolean hasNodesFromDifferentDataSources;
    @Nullable
    private DBECommandContext commandContext;
    private boolean deleteCascade = false;
    private boolean deleteContents = false;

    private NavigatorObjectsDeleter(List<Object> selection, IWorkbenchWindow window, boolean hasNodesFromDifferentDataSources, boolean showCascade, boolean showViewScript, boolean showDeleteContents) {
        this.selection = selection;
        this.window = window;
        this.hasNodesFromDifferentDataSources = hasNodesFromDifferentDataSources;
        this.showCascade = showCascade;
        this.showViewScript = showViewScript;
        this.showDeleteContents = showDeleteContents;
    }

    static NavigatorObjectsDeleter of(List<Object> selection, IWorkbenchWindow window) {
        DBPDataSource dataSource = null;
        boolean hasNodesFromDifferentDataSources = false;
        boolean showCascade = false;
        boolean showViewScript = false;
        boolean showKeepContents = false;
        for (Object obj : selection) {
            NavigatorHandlerObjectBase.CommandTarget commandTarget;
            DBEObjectMaker objectMaker;
            DBSObject object;
            if (obj instanceof DBNProject) {
                showKeepContents = true;
                continue;
            }
            if (!(obj instanceof DBNDatabaseNode)) continue;
            DBNDatabaseNode node = (DBNDatabaseNode)obj;
            DBPDataSource currentDatasource = node.getDataSource();
            if (dataSource == null) {
                dataSource = currentDatasource;
            } else if (!dataSource.equals(currentDatasource)) {
                hasNodesFromDifferentDataSources = true;
            }
            if (!(node.getParentNode() instanceof DBNContainer) || (object = node.getObject()) == null || (objectMaker = (DBEObjectMaker)DBWorkbench.getPlatform().getEditorsRegistry().getObjectManager(object.getClass(), DBEObjectMaker.class)) == null) continue;
            showCascade |= (objectMaker.getMakerOptions(object.getDataSource()) & 8L) != 0L;
            try {
                commandTarget = NavigatorHandlerObjectBase.getCommandTarget(window, node.getParentNode(), object.getClass(), false);
            }
            catch (DBException dBException) {
                continue;
            }
            if (!object.isPersisted() || commandTarget.getEditor() != null || commandTarget.getContext() == null) continue;
            showViewScript = true;
        }
        return new NavigatorObjectsDeleter(selection, window, hasNodesFromDifferentDataSources, showCascade, showViewScript, showKeepContents);
    }

    boolean hasNodesFromDifferentDataSources() {
        return this.hasNodesFromDifferentDataSources;
    }

    public boolean isShowCascade() {
        return this.showCascade;
    }

    public boolean isShowViewScript() {
        return this.showViewScript;
    }

    public boolean isShowDeleteContents() {
        return this.showDeleteContents;
    }

    public IProject getProjectToDelete() {
        for (Object obj : this.selection) {
            if (!(obj instanceof DBNProject)) continue;
            return ((DBNProject)obj).getProject().getEclipseProject();
        }
        return null;
    }

    void delete() {
        for (Object obj : this.selection) {
            if (obj instanceof DBNDatabaseNode) {
                this.deleteDatabaseNode((DBNDatabaseNode)obj);
                continue;
            }
            if (obj instanceof DBNResource) {
                this.deleteResource((DBNResource)obj);
                continue;
            }
            if (obj instanceof DBNLocalFolder) {
                this.deleteLocalFolder((DBNLocalFolder)obj);
                continue;
            }
            log.warn((Object)("Don't know how to delete element '" + obj + "'"));
        }
        if (!this.tasksToExecute.isEmpty()) {
            TasksJob.runTasks((String)(this.tasksToExecute.size() > 1 ? "Delete " + this.tasksToExecute.size() + " objects" : "Delete object"), this.tasksToExecute);
        }
    }

    private void deleteLocalFolder(DBNLocalFolder folder) {
        folder.getDataSourceRegistry().removeFolder(folder.getFolder(), false);
        DBNModel.updateConfigAndRefreshDatabases((DBNNode)folder);
    }

    private void deleteResource(DBNResource resourceNode) {
        IResource resource = resourceNode.getResource();
        try {
            NullProgressMonitor monitor = new NullProgressMonitor();
            if (resource instanceof IFolder) {
                ((IFolder)resource).delete(true, true, (IProgressMonitor)monitor);
            } else if (resource instanceof IProject) {
                ((IProject)resource).delete(this.deleteContents, true, (IProgressMonitor)monitor);
            } else if (resource != null) {
                resource.delete(3, (IProgressMonitor)monitor);
            }
        }
        catch (CoreException e) {
            DBWorkbench.getPlatformUI().showError(UINavigatorMessages.error_deleting_resource_title, NLS.bind((String)UINavigatorMessages.error_deleting_resource_message, (Object)resource.getFullPath().toString()), (Throwable)e);
        }
    }

    private void deleteDatabaseNode(DBNDatabaseNode node) {
        try {
            if (!(node.getParentNode() instanceof DBNContainer)) {
                throw new DBException("Node '" + node + "' doesn't have a container");
            }
            DBSObject object = node.getObject();
            if (object == null) {
                throw new DBException("Can't delete node with null object");
            }
            DBEObjectMaker objectMaker = (DBEObjectMaker)DBWorkbench.getPlatform().getEditorsRegistry().getObjectManager(object.getClass(), DBEObjectMaker.class);
            if (objectMaker == null) {
                throw new DBException("Object maker not found for type '" + object.getClass().getName() + "'");
            }
            boolean supportsCascade = (objectMaker.getMakerOptions(object.getDataSource()) & 8L) != 0L;
            NavigatorHandlerObjectBase.CommandTarget commandTarget = NavigatorHandlerObjectBase.getCommandTarget(this.window, node.getParentNode(), object.getClass(), false);
            if ((!object.isPersisted() || commandTarget.getEditor() != null) && this.deleteNewObject(node)) {
                return;
            }
            Map<String, Object> deleteOptions = Collections.emptyMap();
            if (this.deleteCascade && supportsCascade) {
                deleteOptions = OPTIONS_CASCADE;
            }
            objectMaker.deleteObject(commandTarget.getContext(), node.getObject(), deleteOptions);
            if (commandTarget.getEditor() == null && commandTarget.getContext() != null) {
                NavigatorHandlerObjectBase.ObjectSaver deleter = new NavigatorHandlerObjectBase.ObjectSaver(commandTarget.getContext(), deleteOptions);
                this.tasksToExecute.add(deleter);
            }
        }
        catch (Throwable e) {
            DBWorkbench.getPlatformUI().showError(UINavigatorMessages.actions_navigator_error_dialog_delete_object_title, NLS.bind((String)UINavigatorMessages.actions_navigator_error_dialog_delete_object_message, (Object)node.getNodeName()), e);
        }
    }

    private boolean deleteNewObject(DBNDatabaseNode node) {
        IEditorReference[] iEditorReferenceArray = this.window.getActivePage().getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorInput editorInput;
            IEditorReference editorRef = iEditorReferenceArray[n2];
            IEditorPart editor = editorRef.getEditor(false);
            if (editor instanceof IDatabaseEditor && (editorInput = editor.getEditorInput()) instanceof IDatabaseEditorInput && ((IDatabaseEditorInput)editorInput).getDatabaseObject() == node.getObject()) {
                this.window.getActivePage().closeEditor(editor, false);
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean showScriptWindow() {
        String sql = this.collectSQL();
        boolean result = false;
        if (sql.length() > 0) {
            UIServiceSQL serviceSQL = (UIServiceSQL)DBWorkbench.getService(UIServiceSQL.class);
            if (serviceSQL != null) {
                result = serviceSQL.openSQLViewer(this.commandContext.getExecutionContext(), UINavigatorMessages.actions_navigator_delete_script, (DBPImage)UIIcon.SQL_PREVIEW, sql, true, false) == 10;
            }
        } else {
            result = UIUtils.confirmAction((Shell)this.window.getShell(), (String)UINavigatorMessages.actions_navigator_delete_script, (String)UINavigatorMessages.question_no_sql_available);
        }
        this.commandContext.resetChanges(!result);
        return result;
    }

    private String collectSQL() {
        StringBuilder sql = new StringBuilder();
        try {
            UIUtils.runInProgressService(monitor -> {
                for (Object obj : this.selection) {
                    if (!(obj instanceof DBNDatabaseNode)) continue;
                    this.appendScript(monitor, sql, (DBNDatabaseNode)obj);
                }
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError(UINavigatorMessages.error_sql_generation_title, UINavigatorMessages.error_sql_generation_message, e.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
        return sql.toString();
    }

    private void appendScript(DBRProgressMonitor monitor, StringBuilder sql, DBNDatabaseNode node) throws InvocationTargetException {
        NavigatorHandlerObjectBase.CommandTarget commandTarget;
        if (!(node.getParentNode() instanceof DBNContainer)) {
            return;
        }
        DBSObject object = node.getObject();
        if (object == null) {
            return;
        }
        DBEObjectMaker objectMaker = (DBEObjectMaker)DBWorkbench.getPlatform().getEditorsRegistry().getObjectManager(object.getClass(), DBEObjectMaker.class);
        if (objectMaker == null) {
            return;
        }
        boolean supportsCascade = (objectMaker.getMakerOptions(object.getDataSource()) & 8L) != 0L;
        try {
            commandTarget = NavigatorHandlerObjectBase.getCommandTarget(this.window, node.getParentNode(), object.getClass(), false);
        }
        catch (DBException e) {
            log.warn((Object)e);
            return;
        }
        if (this.commandContext == null) {
            this.commandContext = commandTarget.getContext();
        }
        if (!object.isPersisted() || commandTarget.getEditor() != null) {
            return;
        }
        Map<Object, Object> deleteOptions = supportsCascade && this.deleteCascade ? OPTIONS_CASCADE : Collections.emptyMap();
        try {
            objectMaker.deleteObject(commandTarget.getContext(), node.getObject(), deleteOptions);
        }
        catch (DBException e) {
            log.warn((Object)e);
            return;
        }
        StringBuilder script = new StringBuilder();
        DBECommandContext commandContext = commandTarget.getContext();
        Collection commands = commandContext.getFinalCommands();
        try {
            for (DBECommand command : commands) {
                DBEPersistAction[] persistActions = command.getPersistActions(monitor, commandContext.getExecutionContext(), deleteOptions);
                script.append(SQLUtils.generateScript((DBPDataSource)commandContext.getExecutionContext().getDataSource(), (DBEPersistAction[])persistActions, (boolean)false));
                if (script.length() != 0) continue;
                script.append(SQLUtils.generateComments((DBPDataSource)commandContext.getExecutionContext().getDataSource(), (DBEPersistAction[])persistActions, (boolean)false));
            }
        }
        catch (DBException e) {
            throw new InvocationTargetException(e);
        }
        commandTarget.getContext().resetChanges(true);
        if (sql.length() != 0) {
            sql.append("\n");
        }
        sql.append((CharSequence)script);
    }

    void setDeleteCascade(boolean checkCascade) {
        this.deleteCascade = checkCascade;
    }

    public void setDeleteContents(boolean deleteContents) {
        this.deleteContents = deleteContents;
    }
}

